/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class QuerySplitComponent
implements Comparable<QuerySplitComponent> {
    private final Order order;
    private final String propertyName;
    private final int sortIndex;
    private final Query.SortDirection direction;
    private final List<List<Query.FilterPredicate>> filters = new ArrayList<List<Query.FilterPredicate>>();

    public QuerySplitComponent(String propertyName, List<Query.SortPredicate> sorts) {
        this.propertyName = propertyName;
        for (int i = 0; i < sorts.size(); ++i) {
            if (!sorts.get(i).getPropertyName().equals(propertyName)) continue;
            this.order = Order.SEQUENTIAL;
            this.sortIndex = i;
            this.direction = sorts.get(i).getDirection();
            return;
        }
        this.order = Order.ARBITRARY;
        this.sortIndex = -1;
        this.direction = null;
    }

    public void addFilters(Query.FilterPredicate ... filters) {
        this.filters.add(Arrays.asList(filters));
    }

    public List<List<Query.FilterPredicate>> getFilters() {
        return this.filters;
    }

    public Order getOrder() {
        return this.order;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public Query.SortDirection getDirection() {
        return this.direction;
    }

    @Override
    public int compareTo(QuerySplitComponent o) {
        if (!this.order.equals((Object)o.order)) {
            return this.order.compareTo(o.order);
        }
        return this.sortIndex - o.sortIndex;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.direction, this.filters, this.order, this.propertyName, this.sortIndex});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QuerySplitComponent)) {
            return false;
        }
        QuerySplitComponent other = (QuerySplitComponent)obj;
        return this.direction == other.direction || this.direction != null && this.direction.equals((Object)other.direction) && this.filters == other.filters || this.filters != null && this.filters.equals(other.filters) && this.order == other.order || this.order != null && this.order.equals((Object)other.order) && this.propertyName == other.propertyName || this.propertyName != null && this.propertyName.equals(other.propertyName) && this.sortIndex == other.sortIndex;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.filters));
        String result = new StringBuilder(29 + string.length()).append("QuerySplitComponent [filters=").append(string).toString();
        if (this.direction != null) {
            String string2 = String.valueOf(result);
            String string3 = String.valueOf(String.valueOf((Object)this.direction));
            int n = this.sortIndex;
            result = new StringBuilder(35 + string2.length() + string3.length()).append(string2).append(", direction=").append(string3).append(", ").append("sortIndex=").append(n).toString();
        }
        return String.valueOf(result).concat("]");
    }

    public static enum Order {
        SEQUENTIAL,
        ARBITRARY;

    }
}

