/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Cursor;
import com.google.appengine.api.search.FacetResult;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class Results<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = -8342630524311776674L;
    private static final int MAX_RESULTS_TO_STRING = 10;
    private static final int MAX_FACET_RESULTS_TO_STRING = 10;
    private final OperationResult operationResult;
    private final Collection<T> results;
    private final Collection<FacetResult> facets;
    private final long numberFound;
    private final int numberReturned;
    private final Cursor cursor;

    protected Results(OperationResult operationResult, Collection<T> results, long numberFound, int numberReturned, Cursor cursor) {
        this(operationResult, results, numberFound, numberReturned, cursor, Collections.emptyList());
    }

    protected Results(OperationResult operationResult, Collection<T> results, long numberFound, int numberReturned, Cursor cursor, Collection<FacetResult> facets) {
        this.operationResult = Preconditions.checkNotNull(operationResult, "operation result cannot be null");
        this.results = Collections.unmodifiableCollection(Preconditions.checkNotNull(results, "search results cannot be null"));
        this.facets = Collections.unmodifiableCollection(Preconditions.checkNotNull(facets, "facets cannot be null"));
        this.numberFound = numberFound;
        this.numberReturned = numberReturned;
        this.cursor = cursor;
    }

    @Override
    public Iterator<T> iterator() {
        return this.results.iterator();
    }

    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    public long getNumberFound() {
        return this.numberFound;
    }

    public int getNumberReturned() {
        return this.numberReturned;
    }

    public Collection<T> getResults() {
        return this.results;
    }

    public Collection<FacetResult> getFacets() {
        return this.facets;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public String toString() {
        return new Util.ToStringHelper("Results").addField("operationResult", this.operationResult).addIterableField("results", this.results, 10).addIterableField("facets", this.facets, 10).addField("numberFound", this.numberFound).addField("numberReturned", this.numberReturned).addField("cursor", this.cursor).finish();
    }
}

