/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket;

import com.google.appengine.api.socket.SocketServicePb;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import java.io.Serializable;
import java.net.SocketException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SocketApiHelper
implements Serializable {
    static final String PACKAGE = "remote_socket";
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("system_error:\\s*(-?\\d+)\\s*,?\\s*error_detail:\\s*\"([^\"]*)\"\\s*");

    SocketApiHelper() {
    }

    static void parseErrorDetail(CharSequence string, SocketServicePb.RemoteSocketServiceError serviceError) {
        Matcher matcher = MESSAGE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return;
        }
        serviceError.setErrorDetail(matcher.group(2));
        serviceError.setSystemError(Integer.parseInt(matcher.group(1)));
    }

    <T extends ProtocolMessage<T>, V extends ProtocolMessage<V>> boolean makeSyncCall(String method, T request, V response, SocketServicePb.RemoteSocketServiceError serviceError) throws SocketException {
        try {
            byte[] responseBytes = this.apiProxyMakeSyncCall(method, request.toByteArray());
            if (responseBytes != null) {
                response.mergeFrom(responseBytes);
            }
            return true;
        }
        catch (ApiProxy.ApplicationException exception) {
            if (serviceError != null) {
                SocketServicePb.RemoteSocketServiceError.ErrorCode errorCode = SocketServicePb.RemoteSocketServiceError.ErrorCode.valueOf(exception.getApplicationError());
                switch (errorCode) {
                    case SYSTEM_ERROR: 
                    case GAI_ERROR: {
                        SocketApiHelper.parseErrorDetail(exception.getErrorDetail(), serviceError);
                        if (!serviceError.hasErrorDetail() && !serviceError.hasSystemError()) break;
                        return false;
                    }
                }
            }
            throw SocketApiHelper.translateError(exception);
        }
        catch (ApiProxy.ApiDeadlineExceededException e) {
            String string = String.valueOf(e.getMessage());
            throw new SocketException(string.length() != 0 ? "Socket operation timed out: ".concat(string) : new String("Socket operation timed out: "));
        }
    }

    byte[] apiProxyMakeSyncCall(String method, byte[] request) {
        return ApiProxy.makeSyncCall(PACKAGE, method, request);
    }

    static SocketException translateError(int error, String detail) {
        SocketServicePb.RemoteSocketServiceError.ErrorCode errorCode = SocketServicePb.RemoteSocketServiceError.ErrorCode.valueOf(error);
        switch (errorCode) {
            case SYSTEM_ERROR: {
                String string = String.valueOf(detail);
                return new SocketException(string.length() != 0 ? "System error: ".concat(string) : new String("System error: "));
            }
            case GAI_ERROR: {
                String string = String.valueOf(detail);
                return new SocketException(string.length() != 0 ? "Resolver error: ".concat(string) : new String("Resolver error: "));
            }
            case FAILURE: {
                String string = String.valueOf(detail);
                return new SocketException(string.length() != 0 ? "Operation failure: ".concat(string) : new String("Operation failure: "));
            }
            case PERMISSION_DENIED: {
                String string = String.valueOf(detail);
                return new SocketException(string.length() != 0 ? "Permission denied: ".concat(string) : new String("Permission denied: "));
            }
            case INVALID_REQUEST: {
                String string = String.valueOf(detail);
                return new SocketException(string.length() != 0 ? "Invalid request: ".concat(string) : new String("Invalid request: "));
            }
            case SOCKET_CLOSED: {
                String string = String.valueOf(detail);
                return new SocketException(string.length() != 0 ? "Socket is closed: ".concat(string) : new String("Socket is closed: "));
            }
        }
        String string = String.valueOf(String.valueOf(errorCode));
        String string2 = String.valueOf(String.valueOf(detail));
        return new SocketException(new StringBuilder(23 + string.length() + string2.length()).append("Unspecified error (").append(string).append(") : ").append(string2).toString());
    }

    static SocketException translateError(ApiProxy.ApplicationException exception) {
        return SocketApiHelper.translateError(exception.getApplicationError(), exception.getErrorDetail());
    }
}

