/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1beta3.client;

import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponseException;
import com.google.appengine.repackaged.com.google.api.client.http.protobuf.ProtoHttpContent;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.util.Key;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.DatastoreException;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.DatastoreHelper;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.rpc.Code;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

class RemoteRpc {
    private static final Logger logger = Logger.getLogger(RemoteRpc.class.getName());
    private static final JsonFactory JSON_FACTORY = DatastoreHelper.newJsonFactory();
    private static final String API_FORMAT_VERSION_HEADER = "X-Goog-Api-Format-Version";
    private static final String API_FORMAT_VERSION = "2";
    private final HttpRequestFactory client;
    private final HttpRequestInitializer initializer;
    private final String url;
    private final AtomicInteger rpcCount = new AtomicInteger(0);

    RemoteRpc(HttpRequestFactory client, HttpRequestInitializer initializer, String url) {
        this.client = client;
        this.initializer = initializer;
        this.url = url;
        try {
            this.resolveURL("dummyRpc");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(url).length()).append("Unable to construct RemoteRpc due to unsupported url: <").append(url).append(">").toString(), e);
        }
    }

    public InputStream call(String methodName, MessageLite request) throws DatastoreException {
        String string = String.valueOf(methodName);
        logger.fine(string.length() != 0 ? "remote datastore call ".concat(string) : new String("remote datastore call "));
        long startTime = System.currentTimeMillis();
        try {
            this.rpcCount.incrementAndGet();
            ProtoHttpContent payload = new ProtoHttpContent(request);
            HttpRequest httpRequest = this.client.buildPostRequest(this.resolveURL(methodName), payload);
            httpRequest.getHeaders().put(API_FORMAT_VERSION_HEADER, (Object)API_FORMAT_VERSION);
            if (this.initializer != null) {
                this.initializer.initialize(httpRequest);
            }
            HttpResponse httpResponse = httpRequest.execute();
            InputStream inputStream = httpResponse.getContent();
            return inputStream;
        }
        catch (HttpResponseException e) {
            throw RemoteRpc.makeException(this.url, methodName, e);
        }
        catch (IOException e) {
            throw RemoteRpc.makeException(this.url, methodName, Code.UNAVAILABLE, "I/O error", e);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.fine(new StringBuilder(51 + String.valueOf(methodName).length()).append("remote datastore call ").append(methodName).append(" took ").append(elapsedTime).append(" ms").toString());
        }
    }

    void resetRpcCount() {
        this.rpcCount.set(0);
    }

    int getRpcCount() {
        return this.rpcCount.get();
    }

    public String getUrl() {
        return this.url;
    }

    GenericUrl resolveURL(String path) {
        String string = this.url;
        return new GenericUrl(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(path).length()).append(string).append(":").append(path).toString());
    }

    HttpRequestFactory getHttpRequestFactory() {
        return this.client;
    }

    public static DatastoreException makeException(String url, String methodName, Code code, String message, Throwable cause) {
        logger.fine(new StringBuilder(40 + String.valueOf(methodName).length() + String.valueOf(url).length() + String.valueOf(message).length()).append("remote datastore call ").append(methodName).append(" against ").append(url).append(" failed: ").append(message).toString());
        return new DatastoreException(methodName, code, message, cause);
    }

    static DatastoreException makeException(String url, String methodName, String contentString, Throwable cause, int httpStatusCode) {
        Content content;
        if (contentString == null) {
            return RemoteRpc.makeException(url, methodName, Code.INTERNAL, String.format("Invalid error. Response contained no content. HTTP status code was %s.", httpStatusCode), cause);
        }
        try {
            content = JSON_FACTORY.createJsonParser(contentString).parse(Content.class);
        }
        catch (IOException e) {
            return RemoteRpc.makeException(url, methodName, Code.INTERNAL, String.format("Invalid error. Response content was: %s. HTTP status code was %s.", contentString, httpStatusCode), e);
        }
        Content.Error error = content.getError();
        Code code = Code.valueOf(error.getStatus());
        return RemoteRpc.makeException(url, methodName, code, error.getMessage(), cause);
    }

    static DatastoreException makeException(String url, String methodName, HttpResponseException httpResponseException) {
        return RemoteRpc.makeException(url, methodName, httpResponseException.getContent(), httpResponseException, httpResponseException.getStatusCode());
    }

    public static class Content {
        @Key
        private Error error;

        public Error getError() {
            return this.error;
        }

        public static class Error {
            @Key
            private String message;
            @Key
            private String status;

            public String getMessage() {
                return this.message;
            }

            public String getStatus() {
                return this.status;
            }
        }
    }
}

