/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.io.protocol.LazyParsingExtension;
import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;

public final class ExtensionTags
implements MessageAppender,
Serializable {
    private static final long serialVersionUID = 0L;
    private final Map<Integer, LazyParsingExtension> delegate = Maps.newTreeMap();

    @Override
    public final void addLengthDelimited(int tagNumber, byte[] bytes) {
        int lengthSize = Protocol.varIntSize(bytes.length);
        byte[] withLengthPrefix = new byte[lengthSize + bytes.length];
        ProtocolSink sink = new ProtocolSink(withLengthPrefix);
        sink.putVarInt(bytes.length);
        System.arraycopy(bytes, 0, withLengthPrefix, lengthSize, bytes.length);
        this.putBytes(Protocol.makeTagWord(tagNumber, 2), withLengthPrefix);
    }

    @Override
    public final void addMessage(int tagNumber, ProtocolMessage message) {
        int encodedSize = message.encodingSize();
        byte[] bytes = new byte[Protocol.varIntSize(encodedSize) + encodedSize];
        ProtocolSink sink = new ProtocolSink(bytes);
        sink.putVarInt(encodedSize);
        message.outputTo(sink);
        this.putBytes(Protocol.makeTagWord(tagNumber, 2), bytes);
    }

    public final void putBytes(Integer key, byte[] value) {
        if (this.delegate.containsKey(key)) {
            this.delegate.get(key).addRaw(ByteBuffer.wrap(value));
        } else {
            this.delegate.put(key, LazyParsingExtension.raw(ByteBuffer.wrap(value)));
        }
    }

    public final void putExtension(Integer key, LazyParsingExtension extension) {
        this.delegate.put(key, extension);
    }

    public final void putAll(ExtensionTags other) {
        for (Map.Entry<Integer, LazyParsingExtension> tagAndData : other.delegate.entrySet()) {
            LazyParsingExtension ext = this.get(tagAndData.getKey());
            if (ext != null) {
                ext.merge(tagAndData.getValue());
                continue;
            }
            this.putExtension(tagAndData.getKey(), tagAndData.getValue().copy());
        }
    }

    public final void remove(Integer key) {
        this.delegate.remove(key);
    }

    public final boolean containsKey(Integer key) {
        return this.delegate.containsKey(key);
    }

    public final LazyParsingExtension get(Integer key) {
        return this.delegate.get(key);
    }

    public final int encodingSize() {
        int result = 0;
        for (Map.Entry<Integer, LazyParsingExtension> tagAndData : this.delegate.entrySet()) {
            result += tagAndData.getValue().encodingSize(tagAndData.getKey());
        }
        return result;
    }

    public final int maxEncodingSize() {
        return this.encodingSize();
    }

    public final void put(ProtocolSink sink) {
        for (Map.Entry<Integer, LazyParsingExtension> tagAndData : this.delegate.entrySet()) {
            tagAndData.getValue().put(tagAndData.getKey(), sink);
        }
    }

    public static boolean equivalent(ExtensionTags t1, ExtensionTags t2) {
        if (t1 == null || t1.effectivelyEmpty()) {
            return t2 == null || t2.effectivelyEmpty();
        }
        return t1.equals(t2);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ExtensionTags) {
            ExtensionTags other = (ExtensionTags)obj;
            return this.delegate.equals(other.delegate);
        }
        return false;
    }

    public final int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.effectivelyEmpty();
    }

    private boolean effectivelyEmpty() {
        for (Integer key : this.delegate.keySet()) {
            LazyParsingExtension e = this.delegate.get(key);
            if (!e.isParsed()) {
                return false;
            }
            if (!(e.parsed instanceof Collection)) {
                return false;
            }
            if (((Collection)e.parsed).isEmpty()) continue;
            return false;
        }
        return true;
    }

    Map<Integer, LazyParsingExtension> getAllFields() {
        return this.delegate;
    }
}

