/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.InternalProtobufMeta;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MutableGeneratedMetadataProto;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class MessageFactories {
    private static final Logger logger = Logger.getLogger(MessageFactories.class.getName());

    public static ImmutableMessageFactory getImmutableMessageFactory() {
        return ImmutableGeneratedMessageFactory.getInstance();
    }

    public static MutableMessageFactory getMutableMessageFactory() {
        return MutableGeneratedMessageFactory.getInstance();
    }

    private static Message getPrototypeFromMap(Descriptors.Descriptor type, Map<String, LazyGeneratedMessageDefaultInstance> map) {
        String name = type.getFullName();
        LazyGeneratedMessageDefaultInstance lazyDefaultInstance = map.get(name);
        if (lazyDefaultInstance == null) {
            return null;
        }
        Message defaultInstance = lazyDefaultInstance.getDefaultInstance();
        if (defaultInstance.getDescriptorForType() != type) {
            logger.warning("The descriptor doesn't match with the generated message descriptor  with the same name.");
            return null;
        }
        return defaultInstance;
    }

    private static void loadMetadata(Map<String, LazyGeneratedMessageDefaultInstance> map, boolean immutable) {
        for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry message : InternalProtobufMeta.getInstance().getMessages()) {
            MessageFactories.add(message, map, immutable);
        }
    }

    private static void add(MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry entry, Map<String, LazyGeneratedMessageDefaultInstance> map, boolean immutable) {
        LazyGeneratedMessageDefaultInstance lazyDefaultInstance = new LazyGeneratedMessageDefaultInstance(entry.getLoadPathAsBytes());
        String name = entry.getName();
        if (entry.getImmutable() == immutable) {
            map.put(name, lazyDefaultInstance);
        }
    }

    private static final class LazyGeneratedMessageDefaultInstance {
        private byte[] loadPath;
        private volatile Message defaultInstance = null;

        public LazyGeneratedMessageDefaultInstance(byte[] loadPath) {
            this.loadPath = loadPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message getDefaultInstance() {
            if (this.defaultInstance == null) {
                LazyGeneratedMessageDefaultInstance lazyGeneratedMessageDefaultInstance = this;
                synchronized (lazyGeneratedMessageDefaultInstance) {
                    if (this.defaultInstance == null) {
                        this.loadDefaultInstance();
                    }
                }
            }
            return this.defaultInstance;
        }

        private void loadDefaultInstance() {
            String stringLoadPath = new String(this.loadPath, Charset.forName("UTF8"));
            try {
                Class<?> clazz = Class.forName(stringLoadPath);
                Method method = clazz.getDeclaredMethod("getDefaultInstance", new Class[0]);
                this.defaultInstance = (Message)method.invoke(null, new Object[0]);
                this.loadPath = null;
            }
            catch (ClassNotFoundException e) {
                String string = String.valueOf(stringLoadPath);
                throw new IllegalStateException(string.length() != 0 ? "Failed to load the class for the message at the load path: ".concat(string) : new String("Failed to load the class for the message at the load path: "), e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Failed to find getDefaultInstance() method.", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Failed to call getDefaultInstance() method.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to access getDefaultInstance() method.", e);
            }
        }
    }

    private static class MutableGeneratedMessageFactory
    implements MutableMessageFactory {
        private static final MutableGeneratedMessageFactory instance = new MutableGeneratedMessageFactory();
        private final Map<String, LazyGeneratedMessageDefaultInstance> messageByName = new HashMap<String, LazyGeneratedMessageDefaultInstance>();

        public static MutableMessageFactory getInstance() {
            return instance;
        }

        private MutableGeneratedMessageFactory() {
            MessageFactories.loadMetadata(this.messageByName, false);
        }

        @Override
        public MutableMessage getPrototype(Descriptors.Descriptor type) {
            return (MutableMessage)MessageFactories.getPrototypeFromMap(type, this.messageByName);
        }
    }

    private static class ImmutableGeneratedMessageFactory
    implements ImmutableMessageFactory {
        private static final ImmutableGeneratedMessageFactory instance = new ImmutableGeneratedMessageFactory();
        private final Map<String, LazyGeneratedMessageDefaultInstance> messageByName = new HashMap<String, LazyGeneratedMessageDefaultInstance>();

        public static ImmutableMessageFactory getInstance() {
            return instance;
        }

        private ImmutableGeneratedMessageFactory() {
            MessageFactories.loadMetadata(this.messageByName, true);
        }

        @Override
        public Message getPrototype(Descriptors.Descriptor type) {
            return MessageFactories.getPrototypeFromMap(type, this.messageByName);
        }
    }

    public static interface MutableMessageFactory {
        public MutableMessage getPrototype(Descriptors.Descriptor var1);
    }

    public static interface ImmutableMessageFactory {
        public Message getPrototype(Descriptors.Descriptor var1);
    }
}

