/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.chrono;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.IllegalFieldValueException;
import com.google.appengine.repackaged.org.joda.time.chrono.AssembledChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.BasicGJChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.ZonedChronology;
import com.google.appengine.repackaged.org.joda.time.field.SkipDateTimeField;
import java.util.HashMap;
import java.util.Map;

public final class JulianChronology
extends BasicGJChronology {
    private static final long serialVersionUID = -8731039522547897247L;
    private static final long MILLIS_PER_YEAR = 31557600000L;
    private static final long MILLIS_PER_MONTH = 2629800000L;
    private static final int MIN_YEAR = -292269054;
    private static final int MAX_YEAR = 292272992;
    private static final JulianChronology INSTANCE_UTC;
    private static final Map<DateTimeZone, JulianChronology[]> cCache;

    static int adjustYearForSet(int year) {
        if (year <= 0) {
            if (year == 0) {
                throw new IllegalFieldValueException(DateTimeFieldType.year(), (Number)year, null, null);
            }
            ++year;
        }
        return year;
    }

    public static JulianChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static JulianChronology getInstance() {
        return JulianChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static JulianChronology getInstance(DateTimeZone zone) {
        return JulianChronology.getInstance(zone, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JulianChronology getInstance(DateTimeZone zone, int minDaysInFirstWeek) {
        JulianChronology chrono;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        Map<DateTimeZone, JulianChronology[]> map = cCache;
        synchronized (map) {
            JulianChronology[] chronos = cCache.get(zone);
            if (chronos == null) {
                chronos = new JulianChronology[7];
                cCache.put(zone, chronos);
            }
            try {
                chrono = chronos[minDaysInFirstWeek - 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException(new StringBuilder(43).append("Invalid min days in first week: ").append(minDaysInFirstWeek).toString());
            }
            if (chrono == null) {
                if (zone == DateTimeZone.UTC) {
                    chrono = new JulianChronology(null, null, minDaysInFirstWeek);
                } else {
                    chrono = JulianChronology.getInstance(DateTimeZone.UTC, minDaysInFirstWeek);
                    chrono = new JulianChronology(ZonedChronology.getInstance(chrono, zone), null, minDaysInFirstWeek);
                }
                chronos[minDaysInFirstWeek - 1] = chrono;
            }
        }
        return chrono;
    }

    JulianChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param, minDaysInFirstWeek);
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        int minDays = this.getMinimumDaysInFirstWeek();
        minDays = minDays == 0 ? 4 : minDays;
        return base == null ? JulianChronology.getInstance(DateTimeZone.UTC, minDays) : JulianChronology.getInstance(base.getZone(), minDays);
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return JulianChronology.getInstance(zone);
    }

    @Override
    long getDateMidnightMillis(int year, int monthOfYear, int dayOfMonth) throws IllegalArgumentException {
        return super.getDateMidnightMillis(JulianChronology.adjustYearForSet(year), monthOfYear, dayOfMonth);
    }

    @Override
    boolean isLeapYear(int year) {
        return (year & 3) == 0;
    }

    @Override
    long calculateFirstDayOfYearMillis(int year) {
        int leapYears;
        int relativeYear = year - 1968;
        if (relativeYear <= 0) {
            leapYears = relativeYear + 3 >> 2;
        } else {
            leapYears = relativeYear >> 2;
            if (!this.isLeapYear(year)) {
                ++leapYears;
            }
        }
        long millis = ((long)relativeYear * 365L + (long)leapYears) * 86400000L;
        return millis - 62035200000L;
    }

    @Override
    int getMinYear() {
        return -292269054;
    }

    @Override
    int getMaxYear() {
        return 292272992;
    }

    @Override
    long getAverageMillisPerYear() {
        return 31557600000L;
    }

    @Override
    long getAverageMillisPerYearDividedByTwo() {
        return 15778800000L;
    }

    @Override
    long getAverageMillisPerMonth() {
        return 2629800000L;
    }

    @Override
    long getApproxMillisAtEpochDividedByTwo() {
        return 31083663600000L;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.year = new SkipDateTimeField(this, fields.year);
            fields.weekyear = new SkipDateTimeField(this, fields.weekyear);
        }
    }

    static {
        cCache = new HashMap<DateTimeZone, JulianChronology[]>();
        INSTANCE_UTC = JulianChronology.getInstance(DateTimeZone.UTC);
    }
}

