/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.app.DatastoreV4Client;
import com.google.apphosting.client.datastoreservice.app.EntityTranslator;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class CommitHandler
extends DatastoreRpcHandler<DatastoreService.CommitRequest, DatastoreService.CommitResponse, DatastoreV4Client> {
    private final EntityV4Normalizer entityNormalizer;
    private final EntityTranslator.Format inputFormat;
    public static final MutationTransitionState MUTATION_TRANSITION_STATE = MutationTransitionState.CLOUD_BOTH_APP_ENG_OLD;
    @VisibleForTesting
    public static final long DUMMY_NEW_VERSION_FOR_DEPRECATED_MUTATION = 1L;

    public CommitHandler(DatastoreV4Client datastoreClient, EntityV4Normalizer entityNormalizer, EntityTranslator.Format inputFormat) {
        super(datastoreClient);
        this.entityNormalizer = entityNormalizer;
        this.inputFormat = inputFormat;
    }

    @Override
    public Parser<DatastoreService.CommitRequest> getParser() {
        return DatastoreService.CommitRequest.PARSER;
    }

    @Override
    public Class<DatastoreService.CommitRequest> getRequestClass() {
        return DatastoreService.CommitRequest.class;
    }

    @Override
    public DatastoreService.CommitResponse call(RpcHandler.CallOptions callOptions, DatastoreService.CommitRequest req) throws RpcException {
        DatastoreService.CommitResponse resp;
        boolean hasReqDeprecatedMutation = req.hasDeprecatedMutation();
        if (hasReqDeprecatedMutation && !req.getMutationList().isEmpty()) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, "A commit request cannot contain both a mutation list and a deprecated mutation");
        }
        ByteString transaction = req.hasTransaction() ? req.getTransaction() : null;
        DatastoreService.CommitRequest.Mode commitRequestMode = req.getMode();
        switch (MUTATION_TRANSITION_STATE) {
            case CLOUD_BOTH_APP_ENG_OLD: {
                DatastoreV4.CommitResponse internResp;
                DatastoreV4.DeprecatedMutation deprecatedMutation = null;
                deprecatedMutation = hasReqDeprecatedMutation ? req.getDeprecatedMutation() : this.transformMutationListToDeprecatedMutation(req.getMutationList());
                if (deprecatedMutation != null) {
                    deprecatedMutation = this.normalizeDeprecatedMutation(deprecatedMutation);
                }
                if (!(internResp = ((DatastoreV4Client)this.datastoreClient).commit(callOptions, transaction, commitRequestMode, deprecatedMutation)).getMutationResultList().isEmpty()) {
                    throw new IllegalStateException("Unexpected mutation result list.");
                }
                if (hasReqDeprecatedMutation) {
                    DatastoreV4.DeprecatedMutationResult internDeprecatedMutationResult = internResp.getDeprecatedMutationResult();
                    resp = DatastoreService.CommitResponse.newBuilder().setDeprecatedMutationResult(DatastoreV4.DeprecatedMutationResult.newBuilder().setIndexUpdates(internDeprecatedMutationResult.getIndexUpdates()).addAllInsertAutoIdKey(internDeprecatedMutationResult.getInsertAutoIdKeyList()).build()).build();
                    break;
                }
                DatastoreV4.DeprecatedMutationResult deprecatedMutationResult = internResp.hasDeprecatedMutationResult() ? internResp.getDeprecatedMutationResult() : null;
                List<DatastoreV4.MutationResult> mutationResultList = this.transformDeprecatedMutationResultToMutationResultList(req.getMutationList(), deprecatedMutationResult);
                DatastoreService.CommitResponse.Builder respBuilder = DatastoreService.CommitResponse.newBuilder();
                if (!mutationResultList.isEmpty()) {
                    respBuilder.setIndexUpdates(deprecatedMutationResult.getIndexUpdates()).addAllMutationResult(mutationResultList);
                }
                resp = respBuilder.build();
                break;
            }
            case CLOUD_BOTH_APP_ENG_NEW: {
                List<DatastoreV4.Mutation> mutationList = hasReqDeprecatedMutation ? this.transformDeprecatedMutationToMutationList(req.getDeprecatedMutation()) : req.getMutationList();
                mutationList = this.normalizeMutationList(mutationList);
                DatastoreV4.CommitResponse internResp = ((DatastoreV4Client)this.datastoreClient).commit(callOptions, transaction, commitRequestMode, mutationList);
                List<DatastoreV4.MutationResult> mutationResultList = internResp.getMutationResultList();
                int indexUpdates = internResp.getIndexUpdates();
                if (hasReqDeprecatedMutation) {
                    resp = DatastoreService.CommitResponse.newBuilder().setDeprecatedMutationResult(this.transformMutationResultListToDeprecatedMutationResult(mutationResultList, indexUpdates)).build();
                    break;
                }
                resp = DatastoreService.CommitResponse.newBuilder().addAllMutationResult(mutationResultList).setIndexUpdates(indexUpdates).build();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected mutation transition state.");
            }
        }
        return resp;
    }

    private List<DatastoreV4.Mutation> normalizeMutationList(List<DatastoreV4.Mutation> mutationList) {
        ArrayList<DatastoreV4.Mutation> normalMutationList = Lists.newArrayList();
        for (DatastoreV4.Mutation mutation : mutationList) {
            normalMutationList.add(this.normalizeMutation(mutation));
        }
        return normalMutationList;
    }

    private DatastoreV4.Mutation normalizeMutation(DatastoreV4.Mutation mutation) {
        DatastoreV4.Mutation.Builder normalMutationBuilder = DatastoreV4.Mutation.newBuilder();
        normalMutationBuilder.setOp(mutation.getOp());
        if (mutation.hasKey()) {
            normalMutationBuilder.setKey(this.entityNormalizer.normalizeKey(mutation.getKey()));
        }
        if (mutation.hasEntity()) {
            EntityV4.Entity entity = this.entityNormalizer.normalizeEntity(mutation.getEntity(), this.inputFormat);
            normalMutationBuilder.setEntity(entity);
        }
        return normalMutationBuilder.build();
    }

    private DatastoreV4.DeprecatedMutation normalizeDeprecatedMutation(DatastoreV4.DeprecatedMutation deprecatedMutation) {
        DatastoreV4.DeprecatedMutation.Builder internDeprecatedMutation = DatastoreV4.DeprecatedMutation.newBuilder();
        internDeprecatedMutation.addAllUpsert(this.normalizeEntityList(deprecatedMutation.getUpsertList()));
        internDeprecatedMutation.addAllUpdate(this.normalizeEntityList(deprecatedMutation.getUpdateList()));
        internDeprecatedMutation.addAllInsert(this.normalizeEntityList(deprecatedMutation.getInsertList()));
        internDeprecatedMutation.addAllInsertAutoId(this.normalizeEntityList(deprecatedMutation.getInsertAutoIdList()));
        internDeprecatedMutation.addAllDelete(this.normalizeKeyList(deprecatedMutation.getDeleteList()));
        if (deprecatedMutation.hasForce()) {
            internDeprecatedMutation.setForce(deprecatedMutation.getForce());
        }
        return internDeprecatedMutation.build();
    }

    private List<EntityV4.Entity> normalizeEntityList(List<EntityV4.Entity> entityList) {
        ArrayList<EntityV4.Entity> resultEntityList = Lists.newArrayList();
        for (EntityV4.Entity entity : entityList) {
            EntityV4.Entity resultEntity = this.entityNormalizer.normalizeEntity(entity, this.inputFormat);
            resultEntityList.add(resultEntity);
        }
        return resultEntityList;
    }

    private List<EntityV4.Key> normalizeKeyList(List<EntityV4.Key> keyList) {
        ArrayList<EntityV4.Key> resultKeyList = Lists.newArrayList();
        for (EntityV4.Key key : keyList) {
            EntityV4.Key resultKey = this.entityNormalizer.normalizeKey(key);
            resultKeyList.add(resultKey);
        }
        return resultKeyList;
    }

    @Nullable
    private DatastoreV4.DeprecatedMutation transformMutationListToDeprecatedMutation(List<DatastoreV4.Mutation> mutationList) {
        if (mutationList.isEmpty()) {
            return null;
        }
        DatastoreV4.DeprecatedMutation.Builder deprecatedMutationBuilder = DatastoreV4.DeprecatedMutation.newBuilder();
        block5: for (DatastoreV4.Mutation mutation : mutationList) {
            if (mutation.hasKey()) {
                deprecatedMutationBuilder.addDelete(mutation.getKey());
                continue;
            }
            EntityV4.Entity entity = mutation.getEntity();
            if (CommitHandler.hasIncompleteLastElement(entity.getKey())) {
                deprecatedMutationBuilder.addInsertAutoId(entity);
                continue;
            }
            switch (mutation.getOp()) {
                case INSERT: {
                    deprecatedMutationBuilder.addInsert(entity);
                    continue block5;
                }
                case UPDATE: {
                    deprecatedMutationBuilder.addUpdate(entity);
                    continue block5;
                }
                case UPSERT: {
                    deprecatedMutationBuilder.addUpsert(entity);
                    continue block5;
                }
            }
            String string = String.valueOf(mutation.getOp());
            throw new IllegalStateException(new StringBuilder(24 + String.valueOf(string).length()).append("Unexpected mutation op: ").append(string).toString());
        }
        return deprecatedMutationBuilder.build();
    }

    private List<DatastoreV4.Mutation> transformDeprecatedMutationToMutationList(DatastoreV4.DeprecatedMutation deprecatedMutation) {
        ArrayList<DatastoreV4.Mutation> mutationList = Lists.newArrayList();
        this.addEntityListToMutationList(DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertList(), mutationList);
        this.addEntityListToMutationList(DatastoreV4.Mutation.Operation.UPDATE, deprecatedMutation.getUpdateList(), mutationList);
        this.addEntityListToMutationList(DatastoreV4.Mutation.Operation.UPSERT, deprecatedMutation.getUpsertList(), mutationList);
        this.addEntityListToMutationList(DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertAutoIdList(), mutationList);
        this.addDeleteKeyListToMutationList(deprecatedMutation.getDeleteList(), mutationList);
        return mutationList;
    }

    private void addEntityListToMutationList(DatastoreV4.Mutation.Operation op, List<EntityV4.Entity> entityList, List<DatastoreV4.Mutation> mutationList) {
        for (EntityV4.Entity entity : entityList) {
            mutationList.add(DatastoreV4.Mutation.newBuilder().setOp(op).setEntity(entity).build());
        }
    }

    private void addDeleteKeyListToMutationList(List<EntityV4.Key> keyList, List<DatastoreV4.Mutation> mutationList) {
        for (EntityV4.Key key : keyList) {
            mutationList.add(DatastoreV4.Mutation.newBuilder().setOp(DatastoreV4.Mutation.Operation.DELETE).setKey(key).build());
        }
    }

    private DatastoreV4.DeprecatedMutationResult transformMutationResultListToDeprecatedMutationResult(List<DatastoreV4.MutationResult> mutationResultList, int indexUpdates) {
        DatastoreV4.DeprecatedMutationResult.Builder deprecatedMutationResultBuilder = DatastoreV4.DeprecatedMutationResult.newBuilder();
        for (DatastoreV4.MutationResult mutationResult : mutationResultList) {
            if (!mutationResult.hasKey()) continue;
            deprecatedMutationResultBuilder.addInsertAutoIdKey(mutationResult.getKey());
        }
        deprecatedMutationResultBuilder.setIndexUpdates(indexUpdates);
        return deprecatedMutationResultBuilder.build();
    }

    private List<DatastoreV4.MutationResult> transformDeprecatedMutationResultToMutationResultList(List<DatastoreV4.Mutation> mutationList, @Nullable DatastoreV4.DeprecatedMutationResult deprecatedMutationResult) {
        ArrayList<DatastoreV4.MutationResult> mutationResultList = Lists.newArrayList();
        int insertAutoIdKeyIndex = 0;
        for (DatastoreV4.Mutation mutation : mutationList) {
            DatastoreV4.MutationResult.Builder mutationResultBuilder = DatastoreV4.MutationResult.newBuilder().setNewVersion(1L);
            if (mutation.hasEntity() && CommitHandler.hasIncompleteLastElement(mutation.getEntity().getKey())) {
                EntityV4.Key allocatedKey = deprecatedMutationResult.getInsertAutoIdKey(insertAutoIdKeyIndex);
                ++insertAutoIdKeyIndex;
                mutationResultBuilder.setKey(allocatedKey);
            }
            mutationResultList.add(mutationResultBuilder.build());
        }
        return mutationResultList;
    }

    @Override
    public DatastoreService.CommitResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.CommitResponse.newBuilder().setHeader(CommitHandler.makeErrorHeader(errorCode, message)).build();
    }

    public static boolean hasIncompleteLastElement(EntityV4.Key key) {
        if (key.getPathElementCount() == 0) {
            return false;
        }
        EntityV4.Key.PathElement lastPathElement = key.getPathElement(key.getPathElementCount() - 1);
        return !lastPathElement.hasId() && !lastPathElement.hasName();
    }

    @Override
    public RpcHandler.RequestPermissions getRequiredPermissions(DatastoreService.CommitRequest request) {
        if (!request.getDeprecatedMutation().equals(DatastoreV4.DeprecatedMutation.getDefaultInstance()) || !request.getMutationList().isEmpty()) {
            return RpcHandler.RequestPermissions.READ_WRITE;
        }
        return RpcHandler.RequestPermissions.READ;
    }

    public static enum MutationTransitionState {
        CLOUD_BOTH_APP_ENG_OLD,
        CLOUD_BOTH_APP_ENG_NEW;

    }
}

