/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protos.gdata.proto2api.Core;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcHandler;

public abstract class DatastoreRpcHandler<R extends MessageLite, S extends MessageLite, C>
implements RpcHandler<R, S> {
    @VisibleForTesting
    public static final String GOOGLE_API_ERROR_DOMAIN = "util.error.Code";
    protected final C datastoreClient;

    protected DatastoreRpcHandler(C datastoreClient) {
        this.datastoreClient = datastoreClient;
    }

    protected static DatastoreService.ResponseHeader makeErrorHeader(Codes.Code errorCode, String message) {
        DatastoreService.ResponseHeader.Builder response = DatastoreService.ResponseHeader.newBuilder();
        Core.Errors.Builder errors = Core.Errors.newBuilder();
        Core.ErrorProto.Builder errorProto = Core.ErrorProto.newBuilder();
        errorProto.setDomain(GOOGLE_API_ERROR_DOMAIN).setCode(errorCode.toString()).setExternalErrorMessage(message);
        errors.addError(errorProto.build());
        response.setErrors(errors.build());
        return response.build();
    }

    @Override
    public MessageLite getRequestHeader(R request) {
        return null;
    }
}

