/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.InternalTransientException;
import com.google.appengine.api.urlfetch.ResponseTooLargeException;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;

class URLFetchServiceImpl
implements URLFetchService {
    static final String PACKAGE = "urlfetch";
    private static final Logger logger = Logger.getLogger(URLFetchServiceImpl.class.getName());

    URLFetchServiceImpl() {
    }

    @Override
    public HTTPResponse fetch(URL url) throws IOException {
        return this.fetch(new HTTPRequest(url));
    }

    @Override
    public HTTPResponse fetch(HTTPRequest request) throws IOException {
        byte[] responseBytes;
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Fetch", this.convertToPb(request).toByteArray(), this.createApiConfig(request.getFetchOptions()));
        }
        catch (ApiProxy.RequestTooLargeException ex) {
            throw new IOException("The request exceeded the maximum permissible size");
        }
        catch (ApiProxy.ApplicationException ex) {
            Throwable cause = this.convertApplicationException(request.getURL(), ex);
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (ApiProxy.ApiDeadlineExceededException ex) {
            String string = String.valueOf(String.valueOf(request.getURL()));
            throw new SocketTimeoutException(new StringBuilder(24 + string.length()).append("Timeout while fetching: ").append(string).toString());
        }
        URLFetchServicePb.URLFetchResponse responseProto = ((URLFetchServicePb.URLFetchResponse.Builder)URLFetchServicePb.URLFetchResponse.newBuilder().mergeFrom(responseBytes)).build();
        if (!request.getFetchOptions().getAllowTruncate() && responseProto.getContentWasTruncated()) {
            throw new ResponseTooLargeException(request.getURL().toString());
        }
        return this.convertFromPb(responseProto);
    }

    @Override
    public Future<HTTPResponse> fetchAsync(URL url) {
        return this.fetchAsync(new HTTPRequest(url));
    }

    @Override
    public Future<HTTPResponse> fetchAsync(HTTPRequest request) {
        final FetchOptions fetchOptions = request.getFetchOptions();
        final URL url = request.getURL();
        Future<byte[]> response = ApiProxy.makeAsyncCall(PACKAGE, "Fetch", this.convertToPb(request).toByteArray(), this.createApiConfig(fetchOptions));
        return new FutureWrapper<byte[], HTTPResponse>(response){

            @Override
            protected HTTPResponse wrap(byte[] responseBytes) throws IOException {
                URLFetchServicePb.URLFetchResponse responseProto = ((URLFetchServicePb.URLFetchResponse.Builder)URLFetchServicePb.URLFetchResponse.newBuilder().mergeFrom(responseBytes)).build();
                if (!fetchOptions.getAllowTruncate() && responseProto.getContentWasTruncated()) {
                    throw new ResponseTooLargeException(url.toString());
                }
                return URLFetchServiceImpl.this.convertFromPb(responseProto);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof ApiProxy.ApplicationException) {
                    return URLFetchServiceImpl.this.convertApplicationException(url, (ApiProxy.ApplicationException)cause);
                }
                if (cause instanceof ApiProxy.ApiDeadlineExceededException) {
                    String string = String.valueOf(String.valueOf(url));
                    return new SocketTimeoutException(new StringBuilder(24 + string.length()).append("Timeout while fetching: ").append(string).toString());
                }
                return cause;
            }
        };
    }

    private ApiProxy.ApiConfig createApiConfig(FetchOptions options) {
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(options.getDeadline());
        return apiConfig;
    }

    private String getURLExceptionMessage(String formatString, String url, String errorDetail) {
        if (errorDetail == null || errorDetail.trim().isEmpty()) {
            return String.format(formatString, url);
        }
        return String.format(String.valueOf(formatString).concat(", error: %s"), url, errorDetail);
    }

    private Throwable convertApplicationException(URL requestUrl, ApiProxy.ApplicationException ex) {
        String urlString = requestUrl.toString();
        URLFetchServicePb.URLFetchServiceError.ErrorCode errorCode = URLFetchServicePb.URLFetchServiceError.ErrorCode.valueOf(ex.getApplicationError());
        String errorDetail = ex.getErrorDetail();
        switch (errorCode) {
            case INVALID_URL: {
                return new MalformedURLException(this.getURLExceptionMessage("Invalid URL specified: %s", urlString, errorDetail));
            }
            case CLOSED: {
                return new IOException(this.getURLExceptionMessage("Connection closed unexpectedly by server at URL: %s", urlString, null));
            }
            case TOO_MANY_REDIRECTS: {
                return new IOException(this.getURLExceptionMessage("Too many redirects at URL: %s with redirect=true", urlString, null));
            }
            case MALFORMED_REPLY: {
                return new IOException(this.getURLExceptionMessage("Malformed HTTP reply received from server at URL: %s", urlString, errorDetail));
            }
            case RESPONSE_TOO_LARGE: {
                return new ResponseTooLargeException(urlString);
            }
            case DNS_ERROR: {
                return new UnknownHostException(this.getURLExceptionMessage("DNS host lookup failed for URL: %s", urlString, null));
            }
            case FETCH_ERROR: {
                return new IOException(this.getURLExceptionMessage("Could not fetch URL: %s", urlString, errorDetail));
            }
            case INTERNAL_TRANSIENT_ERROR: {
                return new InternalTransientException(urlString);
            }
            case DEADLINE_EXCEEDED: {
                return new SocketTimeoutException(this.getURLExceptionMessage("Timeout while fetching URL: %s", urlString, null));
            }
            case SSL_CERTIFICATE_ERROR: {
                return new SSLHandshakeException(this.getURLExceptionMessage("Could not verify SSL certificate for URL: %s", urlString, null));
            }
        }
        return new IOException(ex.getErrorDetail());
    }

    private URLFetchServicePb.URLFetchRequest convertToPb(HTTPRequest request) {
        URLFetchServicePb.URLFetchRequest.Builder requestProto = URLFetchServicePb.URLFetchRequest.newBuilder();
        requestProto.setUrl(request.getURL().toExternalForm());
        byte[] payload = request.getPayload();
        if (payload != null) {
            requestProto.setPayload(ByteString.copyFrom(payload));
        }
        switch (request.getMethod()) {
            case GET: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.GET);
                break;
            }
            case POST: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.POST);
                break;
            }
            case HEAD: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.HEAD);
                break;
            }
            case PUT: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.PUT);
                break;
            }
            case DELETE: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.DELETE);
                break;
            }
            case PATCH: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.PATCH);
                break;
            }
            default: {
                String string = String.valueOf(String.valueOf((Object)request.getMethod()));
                throw new IllegalArgumentException(new StringBuilder(16 + string.length()).append("unknown method: ").append(string).toString());
            }
        }
        for (HTTPHeader header : request.getHeaders()) {
            URLFetchServicePb.URLFetchRequest.Header.Builder headerProto = URLFetchServicePb.URLFetchRequest.Header.newBuilder();
            headerProto.setKey(header.getName());
            headerProto.setValue(header.getValue());
            requestProto.addHeader(headerProto);
        }
        requestProto.setFollowRedirects(request.getFetchOptions().getFollowRedirects());
        switch (request.getFetchOptions().getCertificateValidationBehavior()) {
            case VALIDATE: {
                requestProto.setMustValidateServerCertificate(true);
                break;
            }
            case DO_NOT_VALIDATE: {
                requestProto.setMustValidateServerCertificate(false);
                break;
            }
        }
        return requestProto.build();
    }

    private HTTPResponse convertFromPb(URLFetchServicePb.URLFetchResponse responseProto) {
        HTTPResponse response = new HTTPResponse(responseProto.getStatusCode());
        if (responseProto.hasContent()) {
            response.setContent(responseProto.getContent().toByteArray());
        }
        for (URLFetchServicePb.URLFetchResponse.Header header : responseProto.getHeaderList()) {
            response.addHeader(header.getKey(), header.getValue());
        }
        if (responseProto.hasFinalUrl() && responseProto.getFinalUrl().length() > 0) {
            try {
                response.setFinalUrl(new URL(responseProto.getFinalUrl()));
            }
            catch (MalformedURLException e) {
                String string = String.valueOf(String.valueOf(e));
                logger.severe(new StringBuilder(21 + string.length()).append("malformed final URL: ").append(string).toString());
            }
        }
        return response;
    }
}

