/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.repackaged.com.google.common.collect.Queues;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AbstractFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AsyncCallable;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AsyncFunction;
import com.google.appengine.repackaged.com.google.common.util.concurrent.CheckedFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.CollectionFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.CombinedFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ExecutionError;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.appengine.repackaged.com.google.common.util.concurrent.FutureFallback;
import com.google.appengine.repackaged.com.google.common.util.concurrent.GwtFuturesCatchingSpecialization;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Platform;
import com.google.appengine.repackaged.com.google.common.util.concurrent.SerializingExecutor;
import com.google.appengine.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Beta
@GwtCompatible(emulated=true)
public final class Futures
extends GwtFuturesCatchingSpecialization {
    private static final AsyncFunction<ListenableFuture<Object>, Object> DEREFERENCER = new AsyncFunction<ListenableFuture<Object>, Object>(){

        @Override
        public ListenableFuture<Object> apply(ListenableFuture<Object> input) {
            return input;
        }
    };
    @GwtIncompatible(value="TODO")
    private static final Ordering<Constructor<?>> WITH_STRING_PARAM_FIRST = Ordering.natural().onResultOf(new Function<Constructor<?>, Boolean>(){

        @Override
        public Boolean apply(Constructor<?> input) {
            return Arrays.asList(input.getParameterTypes()).contains(String.class);
        }
    }).reverse();

    private Futures() {
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> makeChecked(ListenableFuture<V> future, Function<? super Exception, X> mapper) {
        return new MappingCheckedFuture<V, X>(Preconditions.checkNotNull(future), mapper);
    }

    @CheckReturnValue
    @GoogleInternal
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> transformExceptions(ListenableFuture<V> input, Function<Throwable, ? extends Throwable> mapper) {
        return new MappingExceptionHandlingFuture<V>(input, mapper);
    }

    @CheckReturnValue
    public static <V> ListenableFuture<V> immediateFuture(@Nullable V value) {
        return new ImmediateSuccessfulFuture<V>(value);
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> immediateCheckedFuture(@Nullable V value) {
        return new ImmediateSuccessfulCheckedFuture(value);
    }

    @CheckReturnValue
    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFailedFuture(throwable);
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> immediateCancelledFuture() {
        return new ImmediateCancelledFuture();
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> immediateFailedCheckedFuture(X exception) {
        Preconditions.checkNotNull(exception);
        return new ImmediateFailedCheckedFuture(exception);
    }

    @Deprecated
    @CheckReturnValue
    public static <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> input, FutureFallback<? extends V> fallback) {
        return Futures.withFallback(input, fallback, MoreExecutors.directExecutor());
    }

    @Deprecated
    @CheckReturnValue
    public static <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> input, FutureFallback<? extends V> fallback, Executor executor) {
        return Futures.catchingAsync(input, Throwable.class, Futures.asAsyncFunction(fallback), executor);
    }

    @CheckReturnValue
    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback) {
        return Futures.catching(input, exceptionType, fallback, MoreExecutors.directExecutor());
    }

    @CheckReturnValue
    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback, Executor executor) {
        return Futures.catchingAsync(input, exceptionType, Futures.asAsyncFunction(fallback), executor);
    }

    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback) {
        return Futures.catchingAsync(input, exceptionType, fallback, MoreExecutors.directExecutor());
    }

    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback, Executor executor) {
        return new CatchingFuture<V, X>(input, exceptionType, fallback, executor);
    }

    @Deprecated
    static <V> AsyncFunction<Throwable, V> asAsyncFunction(final FutureFallback<V> fallback) {
        Preconditions.checkNotNull(fallback);
        return new AsyncFunction<Throwable, V>(){

            @Override
            public ListenableFuture<V> apply(Throwable t) throws Exception {
                return Preconditions.checkNotNull(fallback.create(t), "FutureFallback.create returned null instead of a Future. Did you mean to return immediateFuture(null)?");
            }
        };
    }

    @CheckReturnValue
    @GwtIncompatible(value="java.util.concurrent.ScheduledExecutorService")
    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> delegate, long time, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        TimeoutFuture<V> result = new TimeoutFuture<V>(delegate);
        TimeoutFuture.Fire<V> fire = new TimeoutFuture.Fire<V>(result);
        result.timer = scheduledExecutor.schedule(fire, time, unit);
        delegate.addListener(fire, MoreExecutors.directExecutor());
        return result;
    }

    @Deprecated
    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
        return Futures.transformAsync(input, function);
    }

    @Deprecated
    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
        return Futures.transformAsync(input, function, executor);
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
        ChainingListenableFuture output = new ChainingListenableFuture(function, input);
        input.addListener(output, MoreExecutors.directExecutor());
        return output;
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(executor);
        ChainingListenableFuture output = new ChainingListenableFuture(function, input);
        input.addListener(Futures.rejectionPropagatingRunnable(output, output, executor), MoreExecutors.directExecutor());
        return output;
    }

    private static Runnable rejectionPropagatingRunnable(final AbstractFuture<?> outputFuture, final Runnable delegateTask, final Executor delegateExecutor) {
        return new Runnable(){

            @Override
            public void run() {
                block2: {
                    final AtomicBoolean thrownFromDelegate = new AtomicBoolean(true);
                    try {
                        delegateExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                thrownFromDelegate.set(false);
                                delegateTask.run();
                            }
                        });
                    }
                    catch (RejectedExecutionException e) {
                        if (!thrownFromDelegate.get()) break block2;
                        outputFuture.setException(e);
                    }
                }
            }
        };
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(function);
        ChainingListenableFuture output = new ChainingListenableFuture(Futures.asAsyncFunction(function), input);
        input.addListener(output, MoreExecutors.directExecutor());
        return output;
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        return Futures.transformAsync(input, Futures.asAsyncFunction(function), executor);
    }

    static <I, O> AsyncFunction<I, O> asAsyncFunction(final Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(function);
        return new AsyncFunction<I, O>(){

            @Override
            public ListenableFuture<O> apply(I input) {
                Object output = function.apply(input);
                return Futures.immediateFuture(output);
            }
        };
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <I, O> Future<O> lazyTransform(final Future<I> input, final Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(function);
        return new Future<O>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return input.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return input.isCancelled();
            }

            @Override
            public boolean isDone() {
                return input.isDone();
            }

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.applyTransformation(input.get());
            }

            @Override
            public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.applyTransformation(input.get(timeout, unit));
            }

            private O applyTransformation(I input2) throws ExecutionException {
                try {
                    return function.apply(input2);
                }
                catch (Throwable t) {
                    throw new ExecutionException(t);
                }
            }
        };
    }

    @CheckReturnValue
    public static <V> ListenableFuture<V> dereference(ListenableFuture<? extends ListenableFuture<? extends V>> nested) {
        return Futures.transformAsync(nested, DEREFERENCER);
    }

    @SafeVarargs
    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(ListenableFuture<? extends V> ... futures) {
        return new ListFuture<V>(ImmutableList.copyOf(futures), true);
    }

    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return new ListFuture(ImmutableList.copyOf(futures), true);
    }

    @Deprecated
    @GoogleInternal
    public static <V> ListenableFuture<V> combine(Callable<V> combiner, Executor executor, ListenableFuture<?> ... futures) {
        return Futures.combine(combiner, executor, ImmutableList.copyOf(futures));
    }

    @Deprecated
    @GoogleInternal
    public static <V> ListenableFuture<V> combine(Callable<V> combiner, Executor executor, Iterable<? extends ListenableFuture<?>> futures) {
        return Futures.whenAllComplete(futures).call(combiner, executor);
    }

    @SafeVarargs
    @CheckReturnValue
    @GoogleInternal
    public static <V> FutureCombiner<V> whenAllComplete(ListenableFuture<? extends V> ... futures) {
        return new FutureCombiner(false, ImmutableList.copyOf(futures));
    }

    @CheckReturnValue
    @GoogleInternal
    public static <V> FutureCombiner<V> whenAllComplete(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return new FutureCombiner(false, ImmutableList.copyOf(futures));
    }

    @SafeVarargs
    @CheckReturnValue
    @GoogleInternal
    public static <V> FutureCombiner<V> whenAllSucceed(ListenableFuture<? extends V> ... futures) {
        return new FutureCombiner(true, ImmutableList.copyOf(futures));
    }

    @CheckReturnValue
    @GoogleInternal
    public static <V> FutureCombiner<V> whenAllSucceed(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return new FutureCombiner(true, ImmutableList.copyOf(futures));
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> nonCancellationPropagating(ListenableFuture<V> future) {
        return new NonCancellationPropagatingFuture<V>(future);
    }

    @SafeVarargs
    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(ListenableFuture<? extends V> ... futures) {
        return new ListFuture<V>(ImmutableList.copyOf(futures), false);
    }

    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return new ListFuture(ImmutableList.copyOf(futures), false);
    }

    @CheckReturnValue
    @GoogleInternal
    @GwtIncompatible(value="TODO")
    public static <K, V> ListenableFuture<Map<K, V>> allAsMap(Map<? extends K, ? extends ListenableFuture<? extends V>> futures) {
        return new MapFuture(ImmutableMap.copyOf(futures), true);
    }

    @CheckReturnValue
    @GoogleInternal
    @GwtIncompatible(value="TODO")
    public static <K, V> ListenableFuture<Map<K, V>> successfulAsMap(Map<? extends K, ? extends ListenableFuture<? extends V>> futures) {
        return new MapFuture(ImmutableMap.copyOf(futures), false);
    }

    @CheckReturnValue
    @Beta
    @GwtIncompatible(value="TODO")
    public static <T> ImmutableList<ListenableFuture<T>> inCompletionOrder(Iterable<? extends ListenableFuture<? extends T>> futures) {
        final ConcurrentLinkedQueue delegates = Queues.newConcurrentLinkedQueue();
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        SerializingExecutor executor = new SerializingExecutor(MoreExecutors.directExecutor());
        for (final ListenableFuture<T> future : futures) {
            SettableFuture delegate = SettableFuture.create();
            delegates.add(delegate);
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    ((SettableFuture)delegates.remove()).setFuture(future);
                }
            }, executor);
            listBuilder.add(delegate);
        }
        return listBuilder.build();
    }

    public static <V> void addCallback(ListenableFuture<V> future, FutureCallback<? super V> callback) {
        Futures.addCallback(future, callback, MoreExecutors.directExecutor());
    }

    public static <V> void addCallback(final ListenableFuture<V> future, final FutureCallback<? super V> callback, Executor executor) {
        Preconditions.checkNotNull(callback);
        Runnable callbackListener = new Runnable(){

            @Override
            public void run() {
                Object value;
                try {
                    value = Uninterruptibles.getUninterruptibly(future);
                }
                catch (ExecutionException e) {
                    callback.onFailure(e.getCause());
                    return;
                }
                catch (RuntimeException e) {
                    callback.onFailure(e);
                    return;
                }
                catch (Error e) {
                    callback.onFailure(e);
                    return;
                }
                callback.onSuccess(value);
            }
        };
        future.addListener(callbackListener, executor);
    }

    @Deprecated
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> V get(Future<V> future, Class<X> exceptionClass) throws X {
        return Futures.getChecked(future, exceptionClass);
    }

    @Deprecated
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> V get(Future<V> future, long timeout, TimeUnit unit, Class<X> exceptionClass) throws X {
        return Futures.getChecked(future, exceptionClass, timeout, unit);
    }

    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass) throws X {
        Preconditions.checkNotNull(future);
        Preconditions.checkArgument(!RuntimeException.class.isAssignableFrom(exceptionClass), "Futures.getChecked exception type (%s) must not be a RuntimeException", exceptionClass);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Futures.newWithCause(exceptionClass, e);
        }
        catch (ExecutionException e) {
            Futures.wrapAndThrowExceptionOrError(e.getCause(), exceptionClass);
            throw new AssertionError();
        }
    }

    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass, long timeout, TimeUnit unit) throws X {
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull(unit);
        Preconditions.checkArgument(!RuntimeException.class.isAssignableFrom(exceptionClass), "Futures.getChecked exception type (%s) must not be a RuntimeException", exceptionClass);
        try {
            return future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Futures.newWithCause(exceptionClass, e);
        }
        catch (TimeoutException e) {
            throw Futures.newWithCause(exceptionClass, e);
        }
        catch (ExecutionException e) {
            Futures.wrapAndThrowExceptionOrError(e.getCause(), exceptionClass);
            throw new AssertionError();
        }
    }

    @GwtIncompatible(value="TODO")
    private static <X extends Exception> void wrapAndThrowExceptionOrError(Throwable cause, Class<X> exceptionClass) throws X {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)cause);
        }
        if (cause instanceof RuntimeException) {
            throw new UncheckedExecutionException(cause);
        }
        throw Futures.newWithCause(exceptionClass, cause);
    }

    @GwtIncompatible(value="TODO")
    public static <V> V getUnchecked(Future<V> future) {
        Preconditions.checkNotNull(future);
        try {
            return Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException e) {
            Futures.wrapAndThrowUnchecked(e.getCause());
            throw new AssertionError();
        }
    }

    @GwtIncompatible(value="TODO")
    private static void wrapAndThrowUnchecked(Throwable cause) {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)cause);
        }
        throw new UncheckedExecutionException(cause);
    }

    @GwtIncompatible(value="TODO")
    private static <X extends Exception> X newWithCause(Class<X> exceptionClass, Throwable cause) {
        List<Constructor<X>> constructors = Arrays.asList(exceptionClass.getConstructors());
        for (Constructor<X> constructor : Futures.preferringStrings(constructors)) {
            Exception instance = (Exception)Futures.newFromConstructor(constructor, cause);
            if (instance == null) continue;
            if (instance.getCause() == null) {
                instance.initCause(cause);
            }
            return (X)instance;
        }
        String string = String.valueOf(exceptionClass);
        throw new IllegalArgumentException(new StringBuilder(82 + String.valueOf(string).length()).append("No appropriate constructor for exception of type ").append(string).append(" in response to chained exception").toString(), cause);
    }

    @GwtIncompatible(value="TODO")
    private static <X extends Exception> List<Constructor<X>> preferringStrings(List<Constructor<X>> constructors) {
        return WITH_STRING_PARAM_FIRST.sortedCopy(constructors);
    }

    @Nullable
    @GwtIncompatible(value="TODO")
    private static <X> X newFromConstructor(Constructor<X> constructor, Throwable cause) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (paramType.equals(String.class)) {
                params[i] = cause.toString();
                continue;
            }
            if (paramType.equals(Throwable.class)) {
                params[i] = cause;
                continue;
            }
            return null;
        }
        try {
            return constructor.newInstance(params);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    @GoogleInternal
    @GwtIncompatible(value="TODO")
    private static class MappingExceptionHandlingFuture<V>
    extends ForwardingListenableFuture<V> {
        private final ListenableFuture<V> delegate;
        private final Function<Throwable, ? extends Throwable> mapper;

        MappingExceptionHandlingFuture(ListenableFuture<V> delegate, Function<Throwable, ? extends Throwable> mapper) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.mapper = Preconditions.checkNotNull(mapper, "mapper");
        }

        @Override
        protected ListenableFuture<V> delegate() {
            return this.delegate;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            try {
                return this.delegate.get();
            }
            catch (ExecutionException e) {
                throw new ExecutionException(this.mapper.apply(e.getCause()));
            }
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return this.delegate.get(timeout, unit);
            }
            catch (ExecutionException e) {
                throw new ExecutionException(this.mapper.apply(e.getCause()));
            }
        }
    }

    @GwtIncompatible(value="TODO")
    private static class MappingCheckedFuture<V, X extends Exception>
    extends AbstractCheckedFuture<V, X> {
        final Function<? super Exception, X> mapper;

        MappingCheckedFuture(ListenableFuture<V> delegate, Function<? super Exception, X> mapper) {
            super(delegate);
            this.mapper = Preconditions.checkNotNull(mapper);
        }

        @Override
        protected X mapException(Exception e) {
            return (X)((Exception)this.mapper.apply(e));
        }
    }

    @GoogleInternal
    @GwtIncompatible(value="TODO")
    private static final class MapFuture<K, V>
    extends CollectionFuture<V, Map<K, V>> {
        MapFuture(ImmutableMap<? extends K, ? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            this.init(new MapFutureRunningState(futures, allMustSucceed));
        }

        private final class MapFutureRunningState
        extends CollectionFuture.CollectionFutureRunningState {
            private ImmutableMap<? extends K, ? extends ListenableFuture<? extends V>> futures;

            MapFutureRunningState(ImmutableMap<? extends K, ? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
                super(futures.values(), allMustSucceed);
                this.futures = futures;
            }

            public Map<K, V> combine(List<Optional<V>> values) {
                LinkedHashMap result = Maps.newLinkedHashMap();
                for (Pair entry : Iterables.pairUp(this.futures.keySet(), values)) {
                    if (entry.second == null) continue;
                    result.put(entry.first, ((Optional)entry.second).orNull());
                }
                return Collections.unmodifiableMap(result);
            }

            @Override
            void releaseResourcesAfterFailure() {
                super.releaseResourcesAfterFailure();
                this.futures = null;
            }
        }
    }

    private static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            this.init(new ListFutureRunningState(futures, allMustSucceed));
        }

        private final class ListFutureRunningState
        extends CollectionFuture.CollectionFutureRunningState {
            ListFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
                super(futures, allMustSucceed);
            }

            public List<V> combine(List<Optional<V>> values) {
                ArrayList<Object> result = Lists.newArrayList();
                for (Optional element : values) {
                    result.add(element != null ? (Object)element.orNull() : null);
                }
                return Collections.unmodifiableList(result);
            }
        }
    }

    @GwtIncompatible(value="TODO")
    private static final class NonCancellationPropagatingFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        NonCancellationPropagatingFuture(final ListenableFuture<V> delegate) {
            delegate.addListener(new Runnable(){

                @Override
                public void run() {
                    NonCancellationPropagatingFuture.this.setFuture(delegate);
                }
            }, MoreExecutors.directExecutor());
        }
    }

    @GoogleInternal
    @GwtCompatible
    public static final class FutureCombiner<V> {
        private final boolean allMustSucceed;
        private final ImmutableList<ListenableFuture<? extends V>> futures;

        private FutureCombiner(boolean allMustSucceed, ImmutableList<ListenableFuture<? extends V>> futures) {
            this.allMustSucceed = allMustSucceed;
            this.futures = futures;
        }

        public <C> ListenableFuture<C> callAsync(AsyncCallable<C> combiner, Executor executor) {
            return new CombinedFuture<C>(this.futures, this.allMustSucceed, executor, combiner);
        }

        public <C> ListenableFuture<C> callAsync(AsyncCallable<C> combiner) {
            return this.callAsync(combiner, MoreExecutors.directExecutor());
        }

        public <C> ListenableFuture<C> call(Callable<C> combiner, Executor executor) {
            return new CombinedFuture<C>(this.futures, this.allMustSucceed, executor, combiner);
        }

        public <C> ListenableFuture<C> call(Callable<C> combiner) {
            return this.call(combiner, MoreExecutors.directExecutor());
        }
    }

    private static final class ChainingListenableFuture<I, O>
    extends AbstractFuture.TrustedFuture<O>
    implements Runnable {
        private AsyncFunction<? super I, ? extends O> function;
        private ListenableFuture<? extends I> inputFuture;

        private ChainingListenableFuture(AsyncFunction<? super I, ? extends O> function, ListenableFuture<? extends I> inputFuture) {
            this.function = Preconditions.checkNotNull(function);
            this.inputFuture = Preconditions.checkNotNull(inputFuture);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                ListenableFuture<I> localInputFuture = this.inputFuture;
                if (localInputFuture != null) {
                    localInputFuture.cancel(mayInterruptIfRunning);
                }
                return true;
            }
            return false;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block14: {
                try {
                    I sourceResult;
                    if (this.isCancelled()) {
                        return;
                    }
                    try {
                        sourceResult = Uninterruptibles.getUninterruptibly(this.inputFuture);
                    }
                    catch (CancellationException e) {
                        this.cancel(false);
                        this.function = null;
                        this.inputFuture = null;
                        return;
                    }
                    catch (ExecutionException e) {
                        this.setException(e.getCause());
                        this.function = null;
                        this.inputFuture = null;
                        return;
                    }
                    ListenableFuture<? extends O> outputFuture = this.function.apply(sourceResult);
                    Preconditions.checkNotNull(outputFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)?");
                    this.setFuture(outputFuture);
                    break block14;
                    {
                        catch (UndeclaredThrowableException e) {
                            this.setException(e.getCause());
                            break block14;
                        }
                        catch (Throwable t) {
                            this.setException(t);
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.function = null;
                    this.inputFuture = null;
                }
            }
        }
    }

    private static final class TimeoutFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        ListenableFuture<V> delegateRef;
        Future<?> timer;

        TimeoutFuture(ListenableFuture<V> delegate) {
            this.delegateRef = Preconditions.checkNotNull(delegate);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            Future<?> localTimer = this.timer;
            ListenableFuture<V> delegate = this.delegateRef;
            if (super.cancel(mayInterruptIfRunning)) {
                if (delegate != null) {
                    this.delegateRef = null;
                    delegate.cancel(mayInterruptIfRunning);
                }
                if (localTimer != null) {
                    this.timer = null;
                    localTimer.cancel(false);
                }
                return true;
            }
            return false;
        }

        private static final class Fire<V>
        implements Runnable {
            TimeoutFuture<V> timeoutFutureRef;

            Fire(TimeoutFuture<V> timeoutFuture) {
                this.timeoutFutureRef = timeoutFuture;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TimeoutFuture timeoutFuture = this.timeoutFutureRef;
                if (timeoutFuture == null) {
                    return;
                }
                ListenableFuture delegate = timeoutFuture.delegateRef;
                if (delegate == null) {
                    return;
                }
                this.timeoutFutureRef = null;
                Future<?> timer = timeoutFuture.timer;
                timeoutFuture.delegateRef = null;
                timeoutFuture.timer = null;
                if (delegate.isDone()) {
                    timeoutFuture.setFuture(delegate);
                    if (timer != null) {
                        timer.cancel(false);
                    }
                } else {
                    try {
                        delegate.cancel(true);
                    }
                    finally {
                        String string = String.valueOf(delegate);
                        timeoutFuture.setException(new TimeoutException(new StringBuilder(18 + String.valueOf(string).length()).append("Future timed out: ").append(string).toString()));
                    }
                }
            }
        }
    }

    static class CatchingFuture<V, X extends Throwable>
    extends AbstractFuture.TrustedFuture<V> {
        ListenableFuture<? extends V> running;

        CatchingFuture(ListenableFuture<? extends V> input, final Class<X> exceptionType, final AsyncFunction<? super X, ? extends V> fallback, Executor executor) {
            Preconditions.checkNotNull(exceptionType);
            Preconditions.checkNotNull(fallback);
            this.running = input;
            input.addListener(new Runnable(){

                @Override
                public void run() {
                    Throwable throwable;
                    ListenableFuture localRunning = CatchingFuture.this.running;
                    CatchingFuture.this.running = null;
                    if (localRunning == null | CatchingFuture.this.isCancelled()) {
                        return;
                    }
                    try {
                        CatchingFuture.this.set(Uninterruptibles.getUninterruptibly(localRunning));
                        return;
                    }
                    catch (ExecutionException e) {
                        throwable = e.getCause();
                    }
                    catch (Throwable e) {
                        throwable = e;
                    }
                    try {
                        if (Platform.isInstanceOfThrowableClass(throwable, exceptionType)) {
                            Throwable castThrowable = throwable;
                            ListenableFuture replacement = fallback.apply(castThrowable);
                            Preconditions.checkNotNull(replacement, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)?");
                            CatchingFuture.this.setFuture(replacement);
                        } else {
                            CatchingFuture.this.setException(throwable);
                        }
                    }
                    catch (Throwable e) {
                        CatchingFuture.this.setException(e);
                    }
                }
            }, executor);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            ListenableFuture<V> current = this.running;
            if (super.cancel(mayInterruptIfRunning)) {
                if (current != null) {
                    current.cancel(mayInterruptIfRunning);
                }
                return true;
            }
            return false;
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateFailedCheckedFuture<V, X extends Exception>
    extends ImmediateFuture<V>
    implements CheckedFuture<V, X> {
        private final X thrown;

        ImmediateFailedCheckedFuture(X thrown) {
            this.thrown = thrown;
        }

        @Override
        public V get() throws ExecutionException {
            throw new ExecutionException((Throwable)this.thrown);
        }

        @Override
        public V checkedGet() throws X {
            throw this.thrown;
        }

        @Override
        public V checkedGet(long timeout, TimeUnit unit) throws X {
            Preconditions.checkNotNull(unit);
            throw this.thrown;
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateCancelledFuture<V>
    extends ImmediateFuture<V> {
        private final CancellationException thrown = new CancellationException("Immediate cancelled future.");

        ImmediateCancelledFuture() {
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public V get() {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", this.thrown);
        }
    }

    private static class ImmediateFailedFuture<V>
    extends ImmediateFuture<V> {
        private final Throwable thrown;

        ImmediateFailedFuture(Throwable thrown) {
            this.thrown = thrown;
        }

        @Override
        public V get() throws ExecutionException {
            throw new ExecutionException(this.thrown);
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateSuccessfulCheckedFuture<V, X extends Exception>
    extends ImmediateFuture<V>
    implements CheckedFuture<V, X> {
        @Nullable
        private final V value;

        ImmediateSuccessfulCheckedFuture(@Nullable V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public V checkedGet() {
            return this.value;
        }

        @Override
        public V checkedGet(long timeout, TimeUnit unit) {
            Preconditions.checkNotNull(unit);
            return this.value;
        }
    }

    private static class ImmediateSuccessfulFuture<V>
    extends ImmediateFuture<V> {
        @Nullable
        private final V value;

        ImmediateSuccessfulFuture(@Nullable V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }
    }

    private static abstract class ImmediateFuture<V>
    implements ListenableFuture<V> {
        private static final Logger log = Logger.getLogger(ImmediateFuture.class.getName());

        private ImmediateFuture() {
        }

        @Override
        public void addListener(Runnable listener, Executor executor) {
            Preconditions.checkNotNull(listener, "Runnable was null.");
            Preconditions.checkNotNull(executor, "Executor was null.");
            try {
                executor.execute(listener);
            }
            catch (RuntimeException e) {
                String string = String.valueOf(listener);
                String string2 = String.valueOf(executor);
                log.log(Level.SEVERE, new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RuntimeException while executing runnable ").append(string).append(" with executor ").append(string2).toString(), e);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public abstract V get() throws ExecutionException;

        @Override
        public V get(long timeout, TimeUnit unit) throws ExecutionException {
            Preconditions.checkNotNull(unit);
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

