/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1beta3.client;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import java.util.Arrays;
import java.util.List;

public class DatastoreOptions {
    private final String projectId;
    private final String host;
    private static final String DEFAULT_HOST = "https://datastore.googleapis.com";
    private final HttpRequestInitializer initializer;
    private final Credential credential;
    private final HttpTransport transport;
    public static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/datastore");

    DatastoreOptions(Builder b) {
        this.projectId = b.projectId;
        this.host = b.host != null ? b.host : DEFAULT_HOST;
        this.initializer = b.initializer;
        this.credential = b.credential;
        this.transport = b.transport;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getHost() {
        return this.host;
    }

    public HttpRequestInitializer getInitializer() {
        return this.initializer;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public static class Builder {
        private String projectId;
        private String host;
        private HttpRequestInitializer initializer;
        private Credential credential;
        private HttpTransport transport;

        public Builder() {
        }

        public Builder(DatastoreOptions options) {
            this.projectId = options.projectId;
            this.host = options.host;
            this.initializer = options.initializer;
            this.credential = options.credential;
            this.transport = options.transport;
        }

        public DatastoreOptions build() {
            return new DatastoreOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder initializer(HttpRequestInitializer initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public Builder transport(HttpTransport transport) {
            this.transport = transport;
            return this;
        }
    }
}

