/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.Interval;
import com.google.appengine.repackaged.org.joda.time.LocalDate;
import com.google.appengine.repackaged.org.joda.time.ReadableDateTime;
import com.google.appengine.repackaged.org.joda.time.ReadableDuration;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.YearMonthDay;
import com.google.appengine.repackaged.org.joda.time.base.BaseDateTime;
import com.google.appengine.repackaged.org.joda.time.field.AbstractReadableInstantFieldProperty;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.joda.convert.FromString;

public final class DateMidnight
extends BaseDateTime
implements ReadableDateTime,
Serializable {
    private static final long serialVersionUID = 156371964018738L;

    public static DateMidnight now() {
        return new DateMidnight();
    }

    public static DateMidnight now(DateTimeZone zone) {
        if (zone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new DateMidnight(zone);
    }

    public static DateMidnight now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new DateMidnight(chronology);
    }

    @FromString
    public static DateMidnight parse(String str) {
        return DateMidnight.parse(str, ISODateTimeFormat.dateTimeParser().withOffsetParsed());
    }

    public static DateMidnight parse(String str, DateTimeFormatter formatter) {
        return formatter.parseDateTime(str).toDateMidnight();
    }

    public DateMidnight() {
    }

    public DateMidnight(DateTimeZone zone) {
        super(zone);
    }

    public DateMidnight(Chronology chronology) {
        super(chronology);
    }

    public DateMidnight(long instant) {
        super(instant);
    }

    public DateMidnight(long instant, DateTimeZone zone) {
        super(instant, zone);
    }

    public DateMidnight(long instant, Chronology chronology) {
        super(instant, chronology);
    }

    public DateMidnight(Object instant) {
        super(instant, (Chronology)null);
    }

    public DateMidnight(Object instant, DateTimeZone zone) {
        super(instant, zone);
    }

    public DateMidnight(Object instant, Chronology chronology) {
        super(instant, DateTimeUtils.getChronology(chronology));
    }

    public DateMidnight(int year, int monthOfYear, int dayOfMonth) {
        super(year, monthOfYear, dayOfMonth, 0, 0, 0, 0);
    }

    public DateMidnight(int year, int monthOfYear, int dayOfMonth, DateTimeZone zone) {
        super(year, monthOfYear, dayOfMonth, 0, 0, 0, 0, zone);
    }

    public DateMidnight(int year, int monthOfYear, int dayOfMonth, Chronology chronology) {
        super(year, monthOfYear, dayOfMonth, 0, 0, 0, 0, chronology);
    }

    @Override
    protected long checkInstant(long instant, Chronology chronology) {
        return chronology.dayOfMonth().roundFloor(instant);
    }

    public DateMidnight withMillis(long newMillis) {
        Chronology chrono = this.getChronology();
        return (newMillis = this.checkInstant(newMillis, chrono)) == this.getMillis() ? this : new DateMidnight(newMillis, chrono);
    }

    public DateMidnight withChronology(Chronology newChronology) {
        return newChronology == this.getChronology() ? this : new DateMidnight(this.getMillis(), newChronology);
    }

    public DateMidnight withZoneRetainFields(DateTimeZone newZone) {
        DateTimeZone originalZone;
        if ((newZone = DateTimeUtils.getZone(newZone)) == (originalZone = DateTimeUtils.getZone(this.getZone()))) {
            return this;
        }
        long millis = originalZone.getMillisKeepLocal(newZone, this.getMillis());
        return new DateMidnight(millis, this.getChronology().withZone(newZone));
    }

    public DateMidnight withFields(ReadablePartial partial) {
        if (partial == null) {
            return this;
        }
        return this.withMillis(this.getChronology().set(partial, this.getMillis()));
    }

    public DateMidnight withField(DateTimeFieldType fieldType, int value) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        long instant = fieldType.getField(this.getChronology()).set(this.getMillis(), value);
        return this.withMillis(instant);
    }

    public DateMidnight withFieldAdded(DurationFieldType fieldType, int amount) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (amount == 0) {
            return this;
        }
        long instant = fieldType.getField(this.getChronology()).add(this.getMillis(), amount);
        return this.withMillis(instant);
    }

    public DateMidnight withDurationAdded(long durationToAdd, int scalar) {
        if (durationToAdd == 0L || scalar == 0) {
            return this;
        }
        long instant = this.getChronology().add(this.getMillis(), durationToAdd, scalar);
        return this.withMillis(instant);
    }

    public DateMidnight withDurationAdded(ReadableDuration durationToAdd, int scalar) {
        if (durationToAdd == null || scalar == 0) {
            return this;
        }
        return this.withDurationAdded(durationToAdd.getMillis(), scalar);
    }

    public DateMidnight withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        long instant = this.getChronology().add(period, this.getMillis(), scalar);
        return this.withMillis(instant);
    }

    public DateMidnight plus(long duration) {
        return this.withDurationAdded(duration, 1);
    }

    public DateMidnight plus(ReadableDuration duration) {
        return this.withDurationAdded(duration, 1);
    }

    public DateMidnight plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public DateMidnight plusYears(int years) {
        if (years == 0) {
            return this;
        }
        long instant = this.getChronology().years().add(this.getMillis(), years);
        return this.withMillis(instant);
    }

    public DateMidnight plusMonths(int months) {
        if (months == 0) {
            return this;
        }
        long instant = this.getChronology().months().add(this.getMillis(), months);
        return this.withMillis(instant);
    }

    public DateMidnight plusWeeks(int weeks) {
        if (weeks == 0) {
            return this;
        }
        long instant = this.getChronology().weeks().add(this.getMillis(), weeks);
        return this.withMillis(instant);
    }

    public DateMidnight plusDays(int days) {
        if (days == 0) {
            return this;
        }
        long instant = this.getChronology().days().add(this.getMillis(), days);
        return this.withMillis(instant);
    }

    public DateMidnight minus(long duration) {
        return this.withDurationAdded(duration, -1);
    }

    public DateMidnight minus(ReadableDuration duration) {
        return this.withDurationAdded(duration, -1);
    }

    public DateMidnight minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public DateMidnight minusYears(int years) {
        if (years == 0) {
            return this;
        }
        long instant = this.getChronology().years().subtract(this.getMillis(), years);
        return this.withMillis(instant);
    }

    public DateMidnight minusMonths(int months) {
        if (months == 0) {
            return this;
        }
        long instant = this.getChronology().months().subtract(this.getMillis(), months);
        return this.withMillis(instant);
    }

    public DateMidnight minusWeeks(int weeks) {
        if (weeks == 0) {
            return this;
        }
        long instant = this.getChronology().weeks().subtract(this.getMillis(), weeks);
        return this.withMillis(instant);
    }

    public DateMidnight minusDays(int days) {
        if (days == 0) {
            return this;
        }
        long instant = this.getChronology().days().subtract(this.getMillis(), days);
        return this.withMillis(instant);
    }

    public Property property(DateTimeFieldType type) {
        if (type == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        DateTimeField field = type.getField(this.getChronology());
        if (!field.isSupported()) {
            String string = String.valueOf(type);
            throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string).length()).append("Field '").append(string).append("' is not supported").toString());
        }
        return new Property(this, field);
    }

    @Deprecated
    public YearMonthDay toYearMonthDay() {
        return new YearMonthDay(this.getMillis(), this.getChronology());
    }

    public LocalDate toLocalDate() {
        return new LocalDate(this.getMillis(), this.getChronology());
    }

    public Interval toInterval() {
        Chronology chrono = this.getChronology();
        long start = this.getMillis();
        long end = DurationFieldType.days().getField(chrono).add(start, 1);
        return new Interval(start, end, chrono);
    }

    public DateMidnight withEra(int era) {
        return this.withMillis(this.getChronology().era().set(this.getMillis(), era));
    }

    public DateMidnight withCenturyOfEra(int centuryOfEra) {
        return this.withMillis(this.getChronology().centuryOfEra().set(this.getMillis(), centuryOfEra));
    }

    public DateMidnight withYearOfEra(int yearOfEra) {
        return this.withMillis(this.getChronology().yearOfEra().set(this.getMillis(), yearOfEra));
    }

    public DateMidnight withYearOfCentury(int yearOfCentury) {
        return this.withMillis(this.getChronology().yearOfCentury().set(this.getMillis(), yearOfCentury));
    }

    public DateMidnight withYear(int year) {
        return this.withMillis(this.getChronology().year().set(this.getMillis(), year));
    }

    public DateMidnight withWeekyear(int weekyear) {
        return this.withMillis(this.getChronology().weekyear().set(this.getMillis(), weekyear));
    }

    public DateMidnight withMonthOfYear(int monthOfYear) {
        return this.withMillis(this.getChronology().monthOfYear().set(this.getMillis(), monthOfYear));
    }

    public DateMidnight withWeekOfWeekyear(int weekOfWeekyear) {
        return this.withMillis(this.getChronology().weekOfWeekyear().set(this.getMillis(), weekOfWeekyear));
    }

    public DateMidnight withDayOfYear(int dayOfYear) {
        return this.withMillis(this.getChronology().dayOfYear().set(this.getMillis(), dayOfYear));
    }

    public DateMidnight withDayOfMonth(int dayOfMonth) {
        return this.withMillis(this.getChronology().dayOfMonth().set(this.getMillis(), dayOfMonth));
    }

    public DateMidnight withDayOfWeek(int dayOfWeek) {
        return this.withMillis(this.getChronology().dayOfWeek().set(this.getMillis(), dayOfWeek));
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = 257629620L;
        private DateMidnight iInstant;
        private DateTimeField iField;

        Property(DateMidnight instant, DateTimeField field) {
            this.iInstant = instant;
            this.iField = field;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.iInstant);
            oos.writeObject(this.iField.getType());
        }

        private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
            this.iInstant = (DateMidnight)oos.readObject();
            DateTimeFieldType type = (DateTimeFieldType)oos.readObject();
            this.iField = type.getField(this.iInstant.getChronology());
        }

        @Override
        public DateTimeField getField() {
            return this.iField;
        }

        @Override
        protected long getMillis() {
            return this.iInstant.getMillis();
        }

        @Override
        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public DateMidnight getDateMidnight() {
            return this.iInstant;
        }

        public DateMidnight addToCopy(int value) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), value));
        }

        public DateMidnight addToCopy(long value) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), value));
        }

        public DateMidnight addWrapFieldToCopy(int value) {
            return this.iInstant.withMillis(this.iField.addWrapField(this.iInstant.getMillis(), value));
        }

        public DateMidnight setCopy(int value) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), value));
        }

        public DateMidnight setCopy(String text, Locale locale) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), text, locale));
        }

        public DateMidnight setCopy(String text) {
            return this.setCopy(text, null);
        }

        public DateMidnight withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public DateMidnight withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }

        public DateMidnight roundFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundFloor(this.iInstant.getMillis()));
        }

        public DateMidnight roundCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundCeiling(this.iInstant.getMillis()));
        }

        public DateMidnight roundHalfFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfFloor(this.iInstant.getMillis()));
        }

        public DateMidnight roundHalfCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfCeiling(this.iInstant.getMillis()));
        }

        public DateMidnight roundHalfEvenCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfEven(this.iInstant.getMillis()));
        }
    }
}

