/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.client.datastoreservice.app.CloudDatastoreLegacyRpcService;
import com.google.apphosting.client.datastoreservice.app.CloudDatastoreV1Beta3RpcService;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.serviceapp.AuthService;
import com.google.apphosting.client.serviceapp.AuthServiceImpl;
import com.google.apphosting.client.serviceapp.BaseApiServlet;
import com.google.apphosting.client.serviceapp.Clock;

public class DatastoreApiServlet
extends BaseApiServlet {
    @VisibleForTesting
    static final String API_HEADER = "X-AppEngine-Datastore-API";
    @VisibleForTesting
    static final String[] OAUTH2_SCOPE_STRINGS = new String[]{"https://www.googleapis.com/auth/datastore", "https://www.googleapis.com/auth/cloud-platform"};
    @VisibleForTesting
    public static final String[] OAUTH2_SCOPE_CODES = new String[]{"43600", "35600"};

    public DatastoreApiServlet() {
        this(new AuthServiceImpl(OAuthServiceFactory.getOAuthService()), Clock.SYSTEM_CLOCK);
    }

    private DatastoreApiServlet(AuthService authService, Clock clock) {
        this(authService, clock, new CloudDatastoreLegacyRpcService(ApiProxy.getCurrentEnvironment().getAppId(), new InternDatastoreRpcService(false), clock), new CloudDatastoreV1Beta3RpcService(new InternDatastoreRpcService(true), clock));
    }

    @VisibleForTesting
    public DatastoreApiServlet(AuthService authService, Clock clock, CloudDatastoreLegacyRpcService legacyService, CloudDatastoreV1Beta3RpcService v1beta3Service) {
        super(authService, clock, legacyService, v1beta3Service);
    }

    @Override
    protected String getApiHeader() {
        return API_HEADER;
    }

    @Override
    protected String[] getOAuthScopeStrings() {
        return OAUTH2_SCOPE_STRINGS;
    }

    @Override
    protected String[] getOAuthScopeCodes() {
        return OAUTH2_SCOPE_CODES;
    }
}

