/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app.mobile;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.Collections2;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.client.datastoreservice.app.DatastoreV4Client;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileValidator;
import com.google.apphosting.client.datastoreservice.mobile.DatastoreMobileService;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DatastoreMobileClient {
    private static final long VERSION_ZERO = 0L;
    private static final long NO_VERSION = -1L;
    @VisibleForTesting
    static final String GCD_USER_KIND = "__gcd_user";
    @VisibleForTesting
    static final String GCD_RECEIPT_PROPERTY_NAME = "__gcd_results";
    static final EntityV4.Key PROJECT_NUMBER_KEY = EntityV4.Key.newBuilder().addPathElement(EntityV4.Key.PathElement.newBuilder().setKind("__gcds_volatile").setName("__gcds_project_number")).build();
    private static final Function<DatastoreMobileService.Mutation, EntityV4.Key> MUTATION_TO_KEY = new Function<DatastoreMobileService.Mutation, EntityV4.Key>(){

        @Override
        public EntityV4.Key apply(DatastoreMobileService.Mutation input) {
            return DatastoreMobileClient.getKey(input);
        }
    };
    private final DatastoreV4Client datastoreClient;
    private final Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> internalTransform;
    private final DatastoreMobileValidator validator;

    private static EntityV4.Key getKey(DatastoreMobileService.Mutation mutation) {
        return mutation.hasKey() ? mutation.getKey() : mutation.getEntity().getKey();
    }

    public DatastoreMobileClient(DatastoreV4Client datastoreClient, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> internalTransform, DatastoreMobileValidator validator) {
        this.datastoreClient = datastoreClient;
        this.internalTransform = internalTransform;
        this.validator = validator;
    }

    public DatastoreMobileService.CommitResponse commit(RpcHandler.CallOptions callOptions, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform, DatastoreMobileService.CommitRequest req) throws RpcException {
        this.validator.validateCommitRequest(req);
        ByteString transaction = this.datastoreClient.beginTransaction(callOptions);
        try {
            DatastoreMobileService.CommitResponse res;
            DatastoreV4.ReadOptions readOptions = DatastoreV4.ReadOptions.newBuilder().setTransaction(transaction).build();
            if (req.hasReceiptEntity() && (res = this.getReceiptResponse(callOptions, readOptions, req.getReceiptEntity())) != null) {
                return res;
            }
            return this.commitInternal(callOptions, readOptions, resultTransform, req);
        }
        catch (RpcException e) {
            this.quietRollback(callOptions, transaction);
            throw e;
        }
    }

    private DatastoreMobileService.CommitResponse commitInternal(RpcHandler.CallOptions callOptions, DatastoreV4.ReadOptions readOptions, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform, DatastoreMobileService.CommitRequest req) throws RpcException {
        if (req.getMutationCount() == 0) {
            return DatastoreMobileService.CommitResponse.getDefaultInstance();
        }
        DatastoreService.LookupResponse lookupResponse = this.datastoreClient.lookup(callOptions, resultTransform, readOptions, Collections2.transform(req.getMutationList(), MUTATION_TO_KEY));
        if (lookupResponse.getDeferredCount() > 0) {
            throw new RpcException(Codes.Code.DEADLINE_EXCEEDED, "Unable to lookup entities");
        }
        HashMap<EntityV4.Key, DatastoreV4.EntityResult> keyToEntityResult = Maps.newHashMapWithExpectedSize(req.getMutationCount());
        for (DatastoreV4.EntityResult result : lookupResponse.getFoundList()) {
            if (result.getVersion() == 0L) {
                String string = String.valueOf(result.getEntity().getKey().toString());
                throw new RpcException(Codes.Code.INVALID_ARGUMENT, string.length() != 0 ? "Conflict resolution not supported for: ".concat(string) : new String("Conflict resolution not supported for: "));
            }
            keyToEntityResult.put(result.getEntity().getKey(), result);
        }
        for (DatastoreV4.EntityResult result : lookupResponse.getMissingList()) {
            keyToEntityResult.put(result.getEntity().getKey(), DatastoreV4.EntityResult.newBuilder().setVersion(result.getVersion()).buildPartial());
        }
        return this.resolveAndCommitEntities(callOptions, req, readOptions.getTransaction(), keyToEntityResult);
    }

    private void quietRollback(RpcHandler.CallOptions callOptions, ByteString transaction) {
        try {
            this.datastoreClient.rollback(callOptions, transaction);
        }
        catch (RpcException rpcException) {
            // empty catch block
        }
    }

    @Nullable
    private DatastoreMobileService.ReceiptData checkReceiptAndGetData(EntityV4.EntityOrBuilder requested, EntityV4.EntityOrBuilder existing) throws RpcException {
        HashMap<String, EntityV4.Value> propMap = Maps.newHashMapWithExpectedSize(existing.getPropertyCount());
        EntityV4.Value receiptDataValue = null;
        for (EntityV4.PropertyOrBuilder propertyOrBuilder : existing.getPropertyList()) {
            if (propertyOrBuilder.getName().equals(GCD_RECEIPT_PROPERTY_NAME)) {
                receiptDataValue = propertyOrBuilder.getValue();
                continue;
            }
            propMap.put(propertyOrBuilder.getName(), propertyOrBuilder.getValue());
        }
        if (propMap.size() != requested.getPropertyCount()) {
            return null;
        }
        for (EntityV4.PropertyOrBuilder propertyOrBuilder : requested.getPropertyOrBuilderList()) {
            if (propertyOrBuilder.getValue().equals(propMap.get(propertyOrBuilder.getName()))) continue;
            return null;
        }
        if (receiptDataValue == null || !receiptDataValue.hasBlobValue()) {
            throw new RpcException(Codes.Code.FAILED_PRECONDITION, "Invalid server side receipt.");
        }
        try {
            return DatastoreMobileService.ReceiptData.parseFrom(receiptDataValue.getBlobValue());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RpcException(Codes.Code.FAILED_PRECONDITION, "Invalid server side receipt.");
        }
    }

    private DatastoreMobileService.CommitResponse getReceiptResponse(RpcHandler.CallOptions callOptions, DatastoreV4.ReadOptions readOptions, EntityV4.Entity receiptEntity) throws RpcException {
        DatastoreService.LookupResponse lookupResponse = this.datastoreClient.lookup(callOptions, this.internalTransform, readOptions, Arrays.asList(receiptEntity.getKey()));
        if (lookupResponse.getDeferredCount() > 0) {
            throw new RpcException(Codes.Code.DEADLINE_EXCEEDED, "Deadline exceeded while looking up receipt");
        }
        if (lookupResponse.getFoundCount() == 0) {
            return null;
        }
        DatastoreV4.EntityResult found = lookupResponse.getFound(0);
        DatastoreMobileService.ReceiptData receiptData = this.checkReceiptAndGetData(receiptEntity, found.getEntity());
        if (receiptData == null) {
            return null;
        }
        DatastoreMobileService.CommitResponse.Builder builder = DatastoreMobileService.CommitResponse.newBuilder();
        for (DatastoreMobileService.MutationResult mutationResult : receiptData.getMutationResultList()) {
            if (mutationResult.getNewVersion() == -1L) {
                builder.addMutationResult(mutationResult.toBuilder().setNewVersion(found.getVersion()));
                continue;
            }
            builder.addMutationResult(mutationResult);
        }
        builder.setFromReceipt(true);
        this.datastoreClient.commit(callOptions, readOptions.getTransaction(), DatastoreService.CommitRequest.Mode.TRANSACTIONAL, Collections.emptyList());
        return builder.build();
    }

    private DatastoreMobileService.CommitResponse resolveAndCommitEntities(RpcHandler.CallOptions callOptions, DatastoreMobileService.CommitRequest req, ByteString transaction, Map<EntityV4.Key, DatastoreV4.EntityResult> keyToMutationState) throws RpcException {
        int[] upsertIndexMap = new int[req.getMutationCount()];
        int upsertIndexMapIndex = 0;
        ArrayList<DatastoreV4.Mutation> commitMutations = Lists.newArrayListWithCapacity(req.getMutationCount());
        DatastoreMobileService.CommitResponse.Builder commitResponse = DatastoreMobileService.CommitResponse.newBuilder();
        block5: for (int i = 0; i < req.getMutationCount(); ++i) {
            DatastoreMobileService.Mutation mutation = req.getMutation(i);
            DatastoreMobileService.MutationResult.Builder mutationResult = commitResponse.addMutationResultBuilder();
            mutationResult.setKey(DatastoreMobileClient.getKey(mutation));
            DatastoreV4.EntityResult serverEntity = keyToMutationState.get(mutationResult.getKey());
            if (serverEntity.hasEntity() && serverEntity.getVersion() < mutation.getBaseVersion()) {
                throw new RpcException(Codes.Code.FAILED_PRECONDITION, String.format("Bad base_version (%d) > server version (%d)", mutation.getBaseVersion(), serverEntity.getVersion()));
            }
            switch (this.resolveConflict(mutation, serverEntity)) {
                case RESOLVED_CLIENT: {
                    mutationResult.setConflictResolution(DatastoreMobileService.MutationResult.ConflictResolution.RESOLVED_CLIENT);
                }
                case NO_CONFLICT: {
                    if (this.isNoop(serverEntity, mutation)) {
                        mutationResult.setNewVersion(serverEntity.getVersion());
                        continue block5;
                    }
                    mutationResult.setNewVersion(-1L);
                    upsertIndexMap[upsertIndexMapIndex++] = i;
                    commitMutations.add(this.toV4Mutation(mutation).build());
                    continue block5;
                }
                case RESOLVED_SERVER: {
                    mutationResult.setConflictResolution(DatastoreMobileService.MutationResult.ConflictResolution.RESOLVED_SERVER);
                    mutationResult.setNewVersion(serverEntity.getVersion());
                }
            }
        }
        if (req.hasReceiptEntity()) {
            EntityV4.Entity.Builder updatedReceipt = req.getReceiptEntity().toBuilder();
            updatedReceipt.addProperty(EntityV4.Property.newBuilder().setName(GCD_RECEIPT_PROPERTY_NAME).setValue(this.toReceiptDataValue(commitResponse)).build());
            commitMutations.add(DatastoreV4.Mutation.newBuilder().setOp(DatastoreV4.Mutation.Operation.UPSERT).setEntity(updatedReceipt).build());
        }
        DatastoreV4.CommitResponse commitResV4 = this.datastoreClient.commit(callOptions, transaction, DatastoreService.CommitRequest.Mode.TRANSACTIONAL, commitMutations);
        for (int i = 0; i < upsertIndexMapIndex; ++i) {
            commitResponse.getMutationResultBuilder(upsertIndexMap[i]).setNewVersion(commitResV4.getMutationResult(i).getNewVersion());
        }
        if (commitResV4.hasIndexUpdates()) {
            commitResponse.setIndexUpdates(commitResV4.getIndexUpdates());
        }
        return commitResponse.build();
    }

    private DatastoreMobileService.MutationResult.ConflictResolution resolveConflict(DatastoreMobileService.Mutation mutation, DatastoreV4.EntityResult serverEntity) throws RpcException {
        if (serverEntity.hasEntity() ? serverEntity.getVersion() == mutation.getBaseVersion() : mutation.getBaseVersion() == 0L) {
            return DatastoreMobileService.MutationResult.ConflictResolution.NO_CONFLICT;
        }
        switch (mutation.getRule().getPolicy()) {
            case CLIENT: {
                return DatastoreMobileService.MutationResult.ConflictResolution.RESOLVED_CLIENT;
            }
            case SERVER: {
                return DatastoreMobileService.MutationResult.ConflictResolution.RESOLVED_SERVER;
            }
            case MAX: 
            case MIN: {
                String string = String.valueOf(mutation.getRule().getPolicy());
                throw new RpcException(Codes.Code.INVALID_ARGUMENT, new StringBuilder(37 + String.valueOf(string).length()).append("Resoluton policy not yet implemented:").append(string).toString());
            }
        }
        throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Unknown resolution policy.");
    }

    private boolean isNoop(DatastoreV4.EntityResult entityResult, DatastoreMobileService.Mutation mutation) {
        if (!entityResult.hasEntity()) {
            return mutation.getOp() == DatastoreMobileService.Mutation.Operation.DELETE;
        }
        if (mutation.getOp() == DatastoreMobileService.Mutation.Operation.DELETE) {
            return false;
        }
        return this.propertiesEquals(entityResult.getEntity().getPropertyList(), mutation.getEntity().getPropertyList());
    }

    private boolean propertiesEquals(List<? extends EntityV4.PropertyOrBuilder> lhs, List<? extends EntityV4.PropertyOrBuilder> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        HashMap<String, EntityV4.Value> propMap = Maps.newHashMap();
        for (EntityV4.PropertyOrBuilder propertyOrBuilder : lhs) {
            propMap.put(propertyOrBuilder.getName(), propertyOrBuilder.getValue());
        }
        for (EntityV4.PropertyOrBuilder propertyOrBuilder : rhs) {
            EntityV4.Value lhsValue = (EntityV4.Value)propMap.get(propertyOrBuilder.getName());
            if (lhsValue == null) {
                return false;
            }
            if (lhsValue.hasEntityValue()) {
                if (!propertyOrBuilder.getValue().hasEntityValue()) {
                    return false;
                }
                EntityV4.Entity lhsEntity = lhsValue.getEntityValue();
                EntityV4.Entity rhsEntity = propertyOrBuilder.getValue().getEntityValue();
                if (lhsEntity.hasKey() == rhsEntity.hasKey() && lhsEntity.getKey().equals(rhsEntity.getKey()) && this.propertiesEquals(lhsEntity.getPropertyList(), rhsEntity.getPropertyList())) continue;
                return false;
            }
            if (lhsValue.equals(propertyOrBuilder.getValue())) continue;
            return false;
        }
        return true;
    }

    private EntityV4.Value.Builder toReceiptDataValue(DatastoreMobileService.CommitResponseOrBuilder commitResponse) {
        DatastoreMobileService.ReceiptData data = DatastoreMobileService.ReceiptData.newBuilder().addAllMutationResult(commitResponse.getMutationResultList()).build();
        return EntityV4.Value.newBuilder().setIndexed(false).setBlobValue(data.toByteString());
    }

    public QueryResponseKey runQuery(RpcHandler.CallOptions options, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform, DatastoreV4.RunQueryRequest req, Predicate<DatastoreV4.EntityResult> predicate) throws RpcException {
        DatastoreV4Client.QueryResponseKey responseKey = this.datastoreClient.runQuery(options, resultTransform, req, predicate);
        return new QueryResponseKey(this.toDatastoreMobileServiceRunQueryResponse(responseKey.getQueryResponse()), responseKey.getLastKey());
    }

    public QueryResponseKey retrieveModifiedServerEntities(RpcHandler.CallOptions callOptions, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform, DatastoreV4.RunQueryRequest sinceQueryReq, long minVersion, String fullUserId, @Nullable DatastoreMobileService.CommitResponse commitRes) throws RpcException {
        ByteString txnHandle = this.datastoreClient.beginTransaction(callOptions);
        try {
            EntityV4.PartitionId partitionId = sinceQueryReq.getPartitionId();
            long entityGroupVersion = this.getEntityGroupVersion(callOptions, fullUserId, txnHandle, partitionId);
            if (minVersion == entityGroupVersion) {
                return new QueryResponseKey(null, null);
            }
            if (minVersion > entityGroupVersion) {
                throw new RpcException(Codes.Code.FAILED_PRECONDITION, String.format("Bad min_version (%d) > server version (%d)", minVersion, entityGroupVersion));
            }
            SinceQueryPredicate sinceQueryPred = new SinceQueryPredicate(minVersion, commitRes);
            DatastoreV4.RunQueryRequest query = sinceQueryReq.toBuilder().setReadOptions(DatastoreV4.ReadOptions.newBuilder().setTransaction(txnHandle)).build();
            QueryResponseKey responseKey = this.runQuery(callOptions, resultTransform, query, sinceQueryPred);
            DatastoreMobileService.RunQueryResponse.Builder res = responseKey.getQueryResponse().toBuilder();
            res.getBatchBuilder().setSnapshotVersion(entityGroupVersion);
            return new QueryResponseKey(res.build(), responseKey.getLastKey());
        }
        catch (RpcException e) {
            this.quietRollback(callOptions, txnHandle);
            throw e;
        }
    }

    @VisibleForTesting
    static EntityV4.Key.Builder getEntityGroupMetadataKey(EntityV4.PartitionId partitionId, String fullUserId) {
        return DatastoreMobileClient.getUserRootKey(partitionId, fullUserId).addPathElement(EntityV4.Key.PathElement.newBuilder().setKind("__entity_group__").setId(1L));
    }

    @VisibleForTesting
    static EntityV4.Key.Builder getUserRootKey(EntityV4.PartitionId partitionId, String fullUserId) {
        return EntityV4.Key.newBuilder().setPartitionId(partitionId).addPathElement(EntityV4.Key.PathElement.newBuilder().setKind(GCD_USER_KIND).setName(fullUserId));
    }

    private long getEntityGroupVersion(RpcHandler.CallOptions callOptions, String fullUserId, ByteString txnHandle, EntityV4.PartitionId partitionId) throws RpcException {
        EntityV4.Key v4Key = DatastoreMobileClient.getEntityGroupMetadataKey(partitionId, fullUserId).build();
        ArrayList<EntityV4.Key> lookupKeys = Lists.newArrayList();
        lookupKeys.add(v4Key);
        DatastoreService.LookupResponse lookupResponse = this.datastoreClient.lookup(callOptions, this.internalTransform, DatastoreV4.ReadOptions.newBuilder().setTransaction(txnHandle).build(), lookupKeys);
        if (lookupResponse.getMissingCount() == 1) {
            return 0L;
        }
        return Iterables.getOnlyElement(lookupResponse.getFoundList()).getEntity().getProperty(0).getValue().getIntegerValue();
    }

    private DatastoreMobileService.RunQueryResponse toDatastoreMobileServiceRunQueryResponse(DatastoreService.RunQueryResponse dsRes) {
        DatastoreMobileService.RunQueryResponse.Builder res = DatastoreMobileService.RunQueryResponse.newBuilder();
        if (dsRes.hasBatch()) {
            res.setBatch(dsRes.getBatch());
        }
        return res.build();
    }

    private DatastoreV4.Mutation.Builder toV4Mutation(DatastoreMobileService.Mutation mutation) {
        DatastoreV4.Mutation.Builder builder = DatastoreV4.Mutation.newBuilder();
        if (mutation.hasOp()) {
            builder.setOp(DatastoreV4.Mutation.Operation.valueOf(mutation.getOp().getNumber()));
        }
        if (mutation.hasKey()) {
            builder.setKey(mutation.getKey());
        }
        if (mutation.hasEntity()) {
            builder.setEntity(mutation.getEntity());
        }
        return builder;
    }

    DatastoreV4Client getDatastoreV4Client() {
        return this.datastoreClient;
    }

    private static class SinceQueryPredicate
    implements Predicate<DatastoreV4.EntityResult> {
        private final long minVersion;
        private final Map<EntityV4.Key, DatastoreMobileService.MutationResult> mutationResultMap;

        SinceQueryPredicate(long minVersion, @Nullable DatastoreMobileService.CommitResponse res) {
            this.minVersion = minVersion;
            if (res == null) {
                this.mutationResultMap = Collections.emptyMap();
            } else {
                this.mutationResultMap = Maps.newHashMapWithExpectedSize(res.getMutationResultCount());
                for (DatastoreMobileService.MutationResult result : res.getMutationResultList()) {
                    if (!result.hasKey()) continue;
                    this.mutationResultMap.put(result.getKey(), result);
                }
            }
        }

        @Override
        public boolean apply(DatastoreV4.EntityResult result) {
            if (result.getVersion() == 0L) {
                throw new RuntimeException(new RpcException(Codes.Code.INVALID_ARGUMENT, "Unsupported since query."));
            }
            if (result.getVersion() <= this.minVersion) {
                return false;
            }
            EntityV4.Key key = result.getEntity().getKey();
            DatastoreMobileService.MutationResult mutationResult = this.mutationResultMap.get(key);
            if (mutationResult == null) {
                return true;
            }
            return result.getVersion() > mutationResult.getNewVersion() || mutationResult.getConflictResolution() != DatastoreMobileService.MutationResult.ConflictResolution.NO_CONFLICT && mutationResult.getConflictResolution() != DatastoreMobileService.MutationResult.ConflictResolution.RESOLVED_CLIENT;
        }
    }

    public static final class QueryResponseKey {
        private final DatastoreMobileService.RunQueryResponse response;
        private final EntityV4.Key lastKey;

        QueryResponseKey(DatastoreMobileService.RunQueryResponse response, EntityV4.Key lastKey) {
            this.response = response;
            this.lastKey = lastKey;
        }

        public DatastoreMobileService.RunQueryResponse getQueryResponse() {
            return this.response;
        }

        public EntityV4.Key getLastKey() {
            return this.lastKey;
        }
    }
}

