/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.io.ByteSource;
import com.google.appengine.repackaged.com.google.common.math.LongMath;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteStrings {
    private ByteStrings() {
    }

    public static ByteString toByteString(ByteSource byteSource) throws IOException {
        if (byteSource instanceof ByteStringSource) {
            return ((ByteStringSource)byteSource).byteString;
        }
        long size = byteSource.size();
        if (size > Integer.MAX_VALUE) {
            throw new IOException("Too big");
        }
        ByteString.Output out = ByteString.newOutput((int)size);
        byteSource.copyTo(out);
        return out.toByteString();
    }

    public static ByteSource asByteSource(ByteString byteString) {
        return new ByteStringSource(byteString);
    }

    private static final class ByteStringSource
    extends ByteSource {
        final ByteString byteString;

        ByteStringSource(ByteString byteString) {
            this.byteString = Preconditions.checkNotNull(byteString);
        }

        @Override
        public InputStream openStream() {
            return this.byteString.newInput();
        }

        @Override
        public InputStream openBufferedStream() {
            return this.openStream();
        }

        @Override
        public boolean isEmpty() {
            return this.byteString.isEmpty();
        }

        @Override
        public long size() {
            return this.byteString.size();
        }

        @Override
        public byte[] read() {
            return this.byteString.toByteArray();
        }

        @Override
        public long copyTo(OutputStream output) throws IOException {
            this.byteString.writeTo(output);
            return this.size();
        }

        @Override
        public ByteSource slice(long offset, long length) {
            long maxLength;
            Preconditions.checkArgument(offset >= 0L, "offset is negative: %s", offset);
            Preconditions.checkArgument(length >= 0L, "length is negative: %s", length);
            int size = this.byteString.size();
            try {
                maxLength = LongMath.checkedAdd(offset, length);
            }
            catch (ArithmeticException e) {
                maxLength = Long.MAX_VALUE;
            }
            return ByteStrings.asByteSource(this.byteString.substring(Math.min(size, Ints.saturatedCast(offset)), Math.min(size, Ints.saturatedCast(maxLength))));
        }

        @Override
        public boolean contentEquals(ByteSource other) throws IOException {
            if (other instanceof ByteStringSource) {
                return this.byteString.equals(((ByteStringSource)other).byteString);
            }
            return super.contentEquals(other);
        }
    }
}

