/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.common.base.StringUtil;
import com.google.appengine.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;

public final class JavaQualifiedNames {
    private static final String OUTER_CLASS_SUFFIX = "OuterClass";

    private JavaQualifiedNames() {
    }

    public static String getPackage(Descriptors.FileDescriptor fileDescriptor) {
        DescriptorProtos.FileOptions fileOptions = fileDescriptor.getOptions();
        int javaApiVersion = fileOptions.getJavaApiVersion();
        if (javaApiVersion == 1 && fileOptions.hasJavaAltApiPackage()) {
            return fileOptions.getJavaAltApiPackage();
        }
        String javaPackage = fileDescriptor.getOptions().getJavaPackage();
        if (javaPackage == null || javaPackage.equals("")) {
            String genericPackage = fileDescriptor.getPackage();
            if (genericPackage == null || genericPackage.equals("")) {
                javaPackage = "com.google.protos";
            } else {
                String string = String.valueOf(fileDescriptor.getPackage());
                String string2 = javaPackage = string.length() != 0 ? "com.google.protos.".concat(string) : new String("com.google.protos.");
            }
        }
        if (javaApiVersion == 1) {
            javaPackage = String.valueOf(javaPackage).concat(".proto2api");
        }
        return javaPackage;
    }

    private static boolean hasConflictingClassName(Descriptors.Descriptor messageDesc, String name) {
        if (name.equals(messageDesc.getName())) {
            return true;
        }
        for (Descriptors.EnumDescriptor enumDesc : messageDesc.getEnumTypes()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (Descriptors.Descriptor nestedMessageDesc : messageDesc.getNestedTypes()) {
            if (!JavaQualifiedNames.hasConflictingClassName(nestedMessageDesc, name)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasConflictingClassName(Descriptors.FileDescriptor fileDesc, String name) {
        for (Descriptors.EnumDescriptor enumDesc : fileDesc.getEnumTypes()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (Descriptors.ServiceDescriptor serviceDesc : fileDesc.getServices()) {
            if (!name.equals(serviceDesc.getName())) continue;
            return true;
        }
        for (Descriptors.Descriptor messageDesc : fileDesc.getMessageTypes()) {
            if (!JavaQualifiedNames.hasConflictingClassName(messageDesc, name)) continue;
            return true;
        }
        return false;
    }

    public static String getOuterClassname(Descriptors.FileDescriptor fileDescriptor) {
        String className = fileDescriptor.getOptions().getJavaOuterClassname();
        if (StringUtil.isEmptyOrWhitespace(className)) {
            int cut1;
            className = fileDescriptor.getName();
            int cut0 = className.lastIndexOf("/");
            if (JavaQualifiedNames.hasConflictingClassName(fileDescriptor, className = JavaQualifiedNames.underscoresToCamelCase(className.substring(cut0 + 1, cut1 = className.lastIndexOf(".")), true))) {
                String string = String.valueOf(className);
                String string2 = String.valueOf(OUTER_CLASS_SUFFIX);
                className = string2.length() != 0 ? string.concat(string2) : new String(string);
            }
        }
        return className;
    }

    private static String getQualifiedName(Descriptors.FileDescriptor fd, String name, Descriptors.Descriptor parent) {
        if (parent == null) {
            String string;
            String result = JavaQualifiedNames.getPackage(fd);
            if (!fd.getOptions().getJavaMultipleFiles()) {
                string = String.valueOf(result);
                String string2 = JavaQualifiedNames.getOuterClassname(fd);
                result = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
            }
            string = String.valueOf(result);
            result = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(name).length()).append(string).append(".").append(name).toString();
            return result;
        }
        String result = JavaQualifiedNames.getQualifiedName(fd, parent.getName(), parent.getContainingType());
        result = String.valueOf(result).concat(".");
        String string = String.valueOf(result);
        String string3 = String.valueOf(name);
        result = string3.length() != 0 ? string.concat(string3) : new String(string);
        return result;
    }

    public static String getQualifiedName(Descriptors.Descriptor msg) {
        return JavaQualifiedNames.getQualifiedName(msg.getFile(), msg.getName(), msg.getContainingType());
    }

    public static String getQualifiedName(Descriptors.EnumDescriptor enumType) {
        return JavaQualifiedNames.getQualifiedName(enumType.getFile(), enumType.getName(), enumType.getContainingType());
    }

    public static String underscoresToCamelCase(String input, boolean capitializeNextLetter) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                if (capitializeNextLetter) {
                    result.append((char)(ch + -32));
                } else {
                    result.append(ch);
                }
                capitializeNextLetter = false;
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                if (i == 0 && !capitializeNextLetter) {
                    result.append((char)(ch + 32));
                } else {
                    result.append(ch);
                }
                capitializeNextLetter = false;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                result.append(ch);
                capitializeNextLetter = true;
                continue;
            }
            capitializeNextLetter = true;
        }
        return result.toString();
    }
}

