/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.serviceapp;

import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthService;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.client.serviceapp.RpcService;
import com.google.apphosting.client.serviceapp.ServiceRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseApiServlet
extends HttpServlet
implements ServiceRegistry {
    private static final Logger logger = Logger.getLogger(BaseApiServlet.class.getName());
    private static final Pattern URI_PATTERN = Pattern.compile("/([^/]*/[^/]*/[^/]*)");
    private static final Pattern APIARY_URI_PATTERN = Pattern.compile("/([^/]*/[^/]*)/datasets/([^/]*)(/[^/]*)");
    private static final String PROTOBUF_CONTENT_TYPE = "application/x-protobuf";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private final OAuthService oauthService;
    private final Map<String, RpcHandler<?, ?>> rpcHandlerMap = new HashMap();

    @VisibleForTesting
    protected BaseApiServlet(RpcService service, OAuthService oauthService) {
        this.oauthService = oauthService;
        service.registerService(this);
    }

    @Override
    public <R extends MessageLite, S extends MessageLite> void registerHandler(String service, String version, String method, RpcHandler<R, S> handler) {
        String uri = String.format("%s/%s/%s", service, version, method);
        if (SystemProperty.environment.value() != SystemProperty.Environment.Value.Development) {
            uri = uri.toLowerCase();
        }
        this.rpcHandlerMap.put(uri, handler);
    }

    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        logger.info("ApiServlet GET");
        try {
            RpcHandler<?, ?> rpcHandler = this.getHandler(httpRequest.getRequestURI());
            if (!this.authenticate(httpRequest)) {
                this.writeErrorResponse(rpcHandler, httpRequest, httpResponse, Codes.Code.PERMISSION_DENIED, "Unauthorized.");
            } else {
                BaseApiServlet.writeTextResponse(httpResponse, 200, "Valid RPC");
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, e.getMessage());
            BaseApiServlet.writeTextResponse(httpResponse, 400, e.getMessage());
        }
    }

    public void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        RpcHandler<?, ?> rpcHandler;
        logger.info("ApiServlet POST");
        try {
            rpcHandler = this.getHandler(httpRequest.getRequestURI());
        }
        catch (IOException e) {
            logger.log(Level.INFO, e.getMessage());
            BaseApiServlet.writeTextResponse(httpResponse, 400, e.getMessage());
            return;
        }
        if (!this.authenticate(httpRequest)) {
            this.writeErrorResponse(rpcHandler, httpRequest, httpResponse, Codes.Code.PERMISSION_DENIED, "Unauthorized.");
            return;
        }
        this.doCall(rpcHandler, httpRequest, httpResponse);
    }

    public <R extends MessageLite, S extends MessageLite> void doCall(RpcHandler<R, S> rpcHandler, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        S response;
        String contentType = httpRequest.getContentType();
        try {
            if (contentType != null && !contentType.equals(PROTOBUF_CONTENT_TYPE)) {
                String message = "unsupported content-type: " + contentType;
                logger.log(Level.INFO, message);
                this.writeErrorResponse(rpcHandler, httpRequest, httpResponse, Codes.Code.INVALID_ARGUMENT, message);
                return;
            }
            R request = BaseApiServlet.readRequestProto(rpcHandler.getParser(), httpRequest);
            response = BaseApiServlet.call(rpcHandler, request);
        }
        catch (IOException exception) {
            logger.log(Level.INFO, "Exception reading rpc request message.", exception);
            this.writeErrorResponse(rpcHandler, httpRequest, httpResponse, Codes.Code.INVALID_ARGUMENT, exception.getMessage());
            return;
        }
        catch (RpcException exception) {
            logger.log(Level.INFO, "Exception executing rpc.", exception);
            this.writeErrorResponse(rpcHandler, httpRequest, httpResponse, exception.getErrorCode(), exception.getMessage());
            return;
        }
        try {
            BaseApiServlet.writeResponseProto(response, httpResponse);
        }
        catch (IOException exception) {
            logger.log(Level.INFO, "Exception sending rpc response message.", exception);
        }
    }

    private String getMethodSpec(String uri) throws IOException {
        Matcher uriMatcher;
        if (SystemProperty.environment.value() != SystemProperty.Environment.Value.Development && (uriMatcher = URI_PATTERN.matcher(uri)).matches()) {
            return uriMatcher.group(1);
        }
        uriMatcher = APIARY_URI_PATTERN.matcher(uri);
        if (uriMatcher.matches()) {
            String datasetId = uriMatcher.group(2);
            String displayId = AppIdentityServiceFactory.getAppIdentityService().parseFullAppId(ApiProxy.getCurrentEnvironment().getAppId()).getId();
            if (!displayId.equals(datasetId)) {
                throw new IOException(String.format("Hosted dataset, %s, does not match requested dataset, %s.", ApiProxy.getCurrentEnvironment().getAppId(), datasetId));
            }
            return uriMatcher.group(1) + uriMatcher.group(3);
        }
        throw new IOException("Malformed uri: " + uri);
    }

    private RpcHandler<?, ?> getHandler(String uri) throws IOException {
        RpcHandler<?, ?> rpcHandler;
        String methodSpec = this.getMethodSpec(uri);
        if (SystemProperty.environment.value() != SystemProperty.Environment.Value.Development) {
            methodSpec = methodSpec.toLowerCase();
        }
        if ((rpcHandler = this.rpcHandlerMap.get(methodSpec)) == null) {
            throw new IOException("unknown rpc: " + methodSpec);
        }
        return rpcHandler;
    }

    private static <R extends MessageLite, S extends MessageLite> S call(RpcHandler<R, S> rpcHandler, R request) throws RpcException, IOException {
        return rpcHandler.call(RpcHandler.CallOptions.DEFAULT, request);
    }

    private boolean authenticate(HttpServletRequest httpRequest) {
        try {
            return this.oauthService.isUserAdmin(this.getOAuthScopeCode());
        }
        catch (OAuthRequestException e) {
            try {
                return this.oauthService.isUserAdmin(this.getOAuthScopeString());
            }
            catch (OAuthRequestException e2) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResponseProto(MessageLite protoResponse, HttpServletResponse httpResponse) throws IOException {
        httpResponse.setStatus(200);
        httpResponse.setContentType(PROTOBUF_CONTENT_TYPE);
        try (ServletOutputStream outputStream = null;){
            outputStream = httpResponse.getOutputStream();
            protoResponse.writeTo((OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R extends MessageLite> R readRequestProto(Parser<R> parser, HttpServletRequest httpRequest) throws IOException {
        ServletInputStream inputStream = null;
        try {
            MessageLite requestProto;
            inputStream = httpRequest.getInputStream();
            MessageLite messageLite = requestProto = (MessageLite)parser.parseFrom((InputStream)inputStream);
            return (R)messageLite;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException exception) {
                    logger.log(Level.INFO, "Exception at end of reading rpc request proto message.", exception);
                }
            }
        }
    }

    protected abstract String getApiHeader();

    protected abstract String getOAuthScopeString();

    protected abstract String getOAuthScopeCode();

    private void writeErrorResponse(RpcHandler<?, ?> rpcHandler, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Codes.Code code, String message) {
        logger.log(Level.SEVERE, code.toString() + ": " + message);
        if (httpRequest.getHeader(this.getApiHeader()) != null) {
            try {
                BaseApiServlet.writeResponseProto(rpcHandler.makeError(code, message), httpResponse);
            }
            catch (IOException exception) {
                logger.log(Level.INFO, "IO Exception sending rpc error proto message", exception);
            }
        } else {
            int httpErrorCode;
            switch (code) {
                case INVALID_ARGUMENT: {
                    httpErrorCode = 400;
                    break;
                }
                case PERMISSION_DENIED: {
                    httpErrorCode = 403;
                    break;
                }
                case RESOURCE_EXHAUSTED: {
                    httpErrorCode = 402;
                    break;
                }
                case FAILED_PRECONDITION: {
                    httpErrorCode = 412;
                    break;
                }
                case ABORTED: {
                    httpErrorCode = 409;
                    break;
                }
                case DEADLINE_EXCEEDED: {
                    httpErrorCode = 403;
                    break;
                }
                case UNAVAILABLE: {
                    httpErrorCode = 503;
                    break;
                }
                default: {
                    httpErrorCode = 500;
                }
            }
            String errorMessage = String.format("{\n  \"error\": {\n    \"errors\": [\n     {\n       \"domain\": \"global\",\n       \"reason\": \"%s\",\n       \"message\": \"%s\"\n     }\n    ],\n    \"code\": %d,\n    \"message\": \"%s\"\n  }\n}\n", code.toString(), message, httpErrorCode, message);
            BaseApiServlet.writeTextResponse(httpResponse, httpErrorCode, errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTextResponse(HttpServletResponse httpResponse, int httpStatusCode, String message) {
        httpResponse.setStatus(httpStatusCode);
        httpResponse.setContentType("text/plain");
        try (ServletOutputStream outputStream = null;){
            outputStream = httpResponse.getOutputStream();
            outputStream.print(message);
        }
        catch (IOException exception) {
            logger.log(Level.INFO, "IO Exception sending error text", exception);
        }
    }
}

