/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AbstractIterator;
import java.util.Iterator;

class SlicingIterator<T>
extends AbstractIterator<T> {
    private final Iterator<T> delegate;
    private int remainingOffset;
    private final Integer limit;
    private Integer numEntitiesReturned = 0;

    SlicingIterator(Iterator<T> delegate, Integer offset, Integer limit) {
        this.remainingOffset = offset == null ? 0 : offset;
        this.limit = limit;
        this.delegate = delegate;
    }

    @Override
    protected T computeNext() {
        if (this.numEntitiesReturned.equals(this.limit)) {
            this.endOfData();
        }
        T next = null;
        while (this.delegate.hasNext() && this.remainingOffset-- >= 0) {
            next = this.delegate.next();
        }
        if (this.remainingOffset >= 0 || next == null) {
            this.endOfData();
        } else {
            this.remainingOffset = 0;
            Integer n = this.numEntitiesReturned;
            Integer n2 = this.numEntitiesReturned = Integer.valueOf(this.numEntitiesReturned + 1);
        }
        return next;
    }
}

