/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultiset;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Multiset;
import com.google.appengine.repackaged.com.google.common.collect.ObjectCountHashMap;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.errorprone.annotations.concurrent.LazyInit;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    static final RegularImmutableMultiset<Object> EMPTY = new RegularImmutableMultiset(ObjectCountHashMap.create());
    private final transient ObjectCountHashMap<E> contents;
    private final transient int size;
    @LazyInit
    private transient ImmutableSet<E> elementSet;

    RegularImmutableMultiset(ObjectCountHashMap<E> contents) {
        this.contents = contents;
        long size = 0L;
        for (int i = 0; i < contents.size(); ++i) {
            size += (long)contents.getValue(i);
        }
        this.size = Ints.saturatedCast(size);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int count(@NullableDecl Object element) {
        return this.contents.get(element);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ElementSet result = this.elementSet;
        return result == null ? (this.elementSet = new ElementSet()) : result;
    }

    @Override
    Multiset.Entry<E> getEntry(int index) {
        return this.contents.getEntry(index);
    }

    private final class ElementSet
    extends ImmutableSet.Indexed<E> {
        private ElementSet() {
        }

        @Override
        E get(int index) {
            return RegularImmutableMultiset.this.contents.getKey(index);
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            return RegularImmutableMultiset.this.contains(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return RegularImmutableMultiset.this.contents.size();
        }
    }
}

