/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.BooleanArrayList;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.DoubleArrayList;
import com.google.appengine.repackaged.com.google.protobuf.FloatArrayList;
import com.google.appengine.repackaged.com.google.protobuf.IntArrayList;
import com.google.appengine.repackaged.com.google.protobuf.Internal;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.LongArrayList;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSetLite;
import com.google.appengine.repackaged.com.google.protobuf.Utf8;
import com.google.appengine.repackaged.com.google.protobuf.WireFormat;
import java.io.IOException;

final class ArrayDecoders {
    ArrayDecoders() {
    }

    static int decodeVarint32(byte[] data, int position, Registers registers) {
        int value;
        if ((value = data[position++]) >= 0) {
            registers.int1 = value;
            return position;
        }
        return ArrayDecoders.decodeVarint32(value, data, position, registers);
    }

    static int decodeVarint32(int firstByte, byte[] data, int position, Registers registers) {
        byte b5;
        byte b4;
        byte b3;
        byte b2;
        int value = firstByte & 0x7F;
        if ((b2 = data[position++]) >= 0) {
            registers.int1 = value | b2 << 7;
            return position;
        }
        value |= (b2 & 0x7F) << 7;
        if ((b3 = data[position++]) >= 0) {
            registers.int1 = value | b3 << 14;
            return position;
        }
        value |= (b3 & 0x7F) << 14;
        if ((b4 = data[position++]) >= 0) {
            registers.int1 = value | b4 << 21;
            return position;
        }
        value |= (b4 & 0x7F) << 21;
        if ((b5 = data[position++]) >= 0) {
            registers.int1 = value | b5 << 28;
            return position;
        }
        value |= (b5 & 0x7F) << 28;
        while (data[position++] < 0) {
        }
        registers.int1 = value;
        return position;
    }

    static int decodeVarint64(byte[] data, int position, Registers registers) {
        long value;
        if ((value = (long)data[position++]) >= 0L) {
            registers.long1 = value;
            return position;
        }
        return ArrayDecoders.decodeVarint64(value, data, position, registers);
    }

    static int decodeVarint64(long firstByte, byte[] data, int position, Registers registers) {
        long value = firstByte & 0x7FL;
        byte next = data[position++];
        int shift = 7;
        value |= (long)(next & 0x7F) << 7;
        while (next < 0) {
            next = data[position++];
            value |= (long)(next & 0x7F) << (shift += 7);
        }
        registers.long1 = value;
        return position;
    }

    static int decodeFixed32(byte[] data, int position) {
        return data[position] & 0xFF | (data[position + 1] & 0xFF) << 8 | (data[position + 2] & 0xFF) << 16 | (data[position + 3] & 0xFF) << 24;
    }

    static long decodeFixed64(byte[] data, int position) {
        return (long)data[position] & 0xFFL | ((long)data[position + 1] & 0xFFL) << 8 | ((long)data[position + 2] & 0xFFL) << 16 | ((long)data[position + 3] & 0xFFL) << 24 | ((long)data[position + 4] & 0xFFL) << 32 | ((long)data[position + 5] & 0xFFL) << 40 | ((long)data[position + 6] & 0xFFL) << 48 | ((long)data[position + 7] & 0xFFL) << 56;
    }

    static double decodeDouble(byte[] data, int position) {
        return Double.longBitsToDouble(ArrayDecoders.decodeFixed64(data, position));
    }

    static float decodeFloat(byte[] data, int position) {
        return Float.intBitsToFloat(ArrayDecoders.decodeFixed32(data, position));
    }

    static int decodeString(byte[] data, int position, Registers registers) throws InvalidProtocolBufferException {
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            registers.object1 = "";
            return position;
        }
        registers.object1 = new String(data, position, length, Internal.UTF_8);
        return position + length;
    }

    static int decodeStringRequireUtf8(byte[] data, int position, Registers registers) throws InvalidProtocolBufferException {
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            registers.object1 = "";
            return position;
        }
        registers.object1 = Utf8.decodeUtf8(data, position, length);
        return position + length;
    }

    static int decodeBytes(byte[] data, int position, Registers registers) throws InvalidProtocolBufferException {
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length > data.length - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (length == 0) {
            registers.object1 = ByteString.EMPTY;
            return position;
        }
        registers.object1 = ByteString.copyFrom(data, position, length);
        return position + length;
    }

    static int decodeVarint32List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        IntArrayList output = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        output.addInt(registers.int1);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, nextPosition, registers);
            output.addInt(registers.int1);
        }
        return position;
    }

    static int decodeVarint64List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        LongArrayList output = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint64(data, position, registers);
        output.addLong(registers.long1);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data, nextPosition, registers);
            output.addLong(registers.long1);
        }
        return position;
    }

    static int decodeFixed32List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        IntArrayList output = (IntArrayList)list;
        output.addInt(ArrayDecoders.decodeFixed32(data, position));
        position += 4;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            output.addInt(ArrayDecoders.decodeFixed32(data, nextPosition));
            position = nextPosition + 4;
        }
        return position;
    }

    static int decodeFixed64List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        LongArrayList output = (LongArrayList)list;
        output.addLong(ArrayDecoders.decodeFixed64(data, position));
        position += 8;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            output.addLong(ArrayDecoders.decodeFixed64(data, nextPosition));
            position = nextPosition + 8;
        }
        return position;
    }

    static int decodeFloatList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        FloatArrayList output = (FloatArrayList)list;
        output.addFloat(ArrayDecoders.decodeFloat(data, position));
        position += 4;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            output.addFloat(ArrayDecoders.decodeFloat(data, nextPosition));
            position = nextPosition + 4;
        }
        return position;
    }

    static int decodeDoubleList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        DoubleArrayList output = (DoubleArrayList)list;
        output.addDouble(ArrayDecoders.decodeDouble(data, position));
        position += 8;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            output.addDouble(ArrayDecoders.decodeDouble(data, nextPosition));
            position = nextPosition + 8;
        }
        return position;
    }

    static int decodeBoolList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        BooleanArrayList output = (BooleanArrayList)list;
        position = ArrayDecoders.decodeVarint64(data, position, registers);
        output.addBoolean(registers.long1 != 0L);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data, nextPosition, registers);
            output.addBoolean(registers.long1 != 0L);
        }
        return position;
    }

    static int decodeSInt32List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        IntArrayList output = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        output.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, nextPosition, registers);
            output.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        return position;
    }

    static int decodeSInt64List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        LongArrayList output = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint64(data, position, registers);
        output.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data, nextPosition, registers);
            output.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        return position;
    }

    static int decodePackedVarint32List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        IntArrayList output = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint32(data, position, registers);
            output.addInt(registers.int1);
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedVarint64List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        LongArrayList output = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint64(data, position, registers);
            output.addLong(registers.long1);
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedFixed32List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        IntArrayList output = (IntArrayList)list;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < fieldLimit; position += 4) {
            output.addInt(ArrayDecoders.decodeFixed32(data, position));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedFixed64List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        LongArrayList output = (LongArrayList)list;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < fieldLimit; position += 8) {
            output.addLong(ArrayDecoders.decodeFixed64(data, position));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedFloatList(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        FloatArrayList output = (FloatArrayList)list;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < fieldLimit; position += 4) {
            output.addFloat(ArrayDecoders.decodeFloat(data, position));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedDoubleList(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        DoubleArrayList output = (DoubleArrayList)list;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < fieldLimit; position += 8) {
            output.addDouble(ArrayDecoders.decodeDouble(data, position));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedBoolList(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        BooleanArrayList output = (BooleanArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint64(data, position, registers);
            output.addBoolean(registers.long1 != 0L);
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedSInt32List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        IntArrayList output = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint32(data, position, registers);
            output.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedSInt64List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        LongArrayList output = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint64(data, position, registers);
            output.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodeStringList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> output = list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            output.add("");
        } else {
            String value = new String(data, position, length, Internal.UTF_8);
            output.add(value);
            position += length;
        }
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, nextPosition, registers);
            int nextLength = registers.int1;
            if (nextLength < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (nextLength == 0) {
                output.add("");
                continue;
            }
            String value = new String(data, position, nextLength, Internal.UTF_8);
            output.add(value);
            position += nextLength;
        }
        return position;
    }

    static int decodeStringListRequireUtf8(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> output = list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            output.add("");
        } else {
            if (!Utf8.isValidUtf8(data, position, position + length)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String value = new String(data, position, length, Internal.UTF_8);
            output.add(value);
            position += length;
        }
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, nextPosition, registers);
            int nextLength = registers.int1;
            if (nextLength < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (nextLength == 0) {
                output.add("");
                continue;
            }
            if (!Utf8.isValidUtf8(data, position, position + nextLength)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String value = new String(data, position, nextLength, Internal.UTF_8);
            output.add(value);
            position += nextLength;
        }
        return position;
    }

    static int decodeBytesList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> output = list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length > data.length - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (length == 0) {
            output.add(ByteString.EMPTY);
        } else {
            output.add(ByteString.copyFrom(data, position, length));
            position += length;
        }
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, nextPosition, registers);
            int nextLength = registers.int1;
            if (nextLength < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (nextLength > data.length - position) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if (nextLength == 0) {
                output.add(ByteString.EMPTY);
                continue;
            }
            output.add(ByteString.copyFrom(data, position, nextLength));
            position += nextLength;
        }
        return position;
    }

    static int decodeUnknownField(int tag, byte[] data, int position, int limit, UnknownFieldSetLite unknownFields, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(tag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                unknownFields.storeField(tag, registers.long1);
                return position;
            }
            case 5: {
                unknownFields.storeField(tag, ArrayDecoders.decodeFixed32(data, position));
                return position + 4;
            }
            case 1: {
                unknownFields.storeField(tag, ArrayDecoders.decodeFixed64(data, position));
                return position + 8;
            }
            case 2: {
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                int length = registers.int1;
                if (length < 0) {
                    throw InvalidProtocolBufferException.negativeSize();
                }
                if (length > data.length - position) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                if (length == 0) {
                    unknownFields.storeField(tag, ByteString.EMPTY);
                } else {
                    unknownFields.storeField(tag, ByteString.copyFrom(data, position, length));
                }
                return position + length;
            }
            case 3: {
                UnknownFieldSetLite child = UnknownFieldSetLite.newInstance();
                int endGroup = tag & 0xFFFFFFF8 | 4;
                int lastTag = 0;
                while (position < limit) {
                    position = ArrayDecoders.decodeVarint32(data, position, registers);
                    lastTag = registers.int1;
                    if (lastTag == endGroup) break;
                    position = ArrayDecoders.decodeUnknownField(lastTag, data, position, limit, child, registers);
                }
                if (position > limit || lastTag != endGroup) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                unknownFields.storeField(tag, child);
                return position;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    static int skipField(int tag, byte[] data, int position, int limit, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(tag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                return position;
            }
            case 5: {
                return position + 4;
            }
            case 1: {
                return position + 8;
            }
            case 2: {
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                return position + registers.int1;
            }
            case 3: {
                int endGroup = tag & 0xFFFFFFF8 | 4;
                int lastTag = 0;
                while (position < limit) {
                    position = ArrayDecoders.decodeVarint32(data, position, registers);
                    lastTag = registers.int1;
                    if (lastTag == endGroup) break;
                    position = ArrayDecoders.skipField(lastTag, data, position, limit, registers);
                }
                if (position > limit || lastTag != endGroup) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                return position;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    static final class Registers {
        public int int1;
        public long long1;
        public Object object1;

        Registers() {
        }
    }
}

