/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.BaseDatastoreServiceImpl;
import com.google.appengine.api.datastore.Batcher;
import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DeleteContext;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityCachingStrategy;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.IndexTranslator;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.PostDeleteFuture;
import com.google.appengine.api.datastore.PostLoadFuture;
import com.google.appengine.api.datastore.PostPutFuture;
import com.google.appengine.api.datastore.PreGetContext;
import com.google.appengine.api.datastore.PreQueryContext;
import com.google.appengine.api.datastore.PreparedMultiQuery;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.PreparedQueryImpl;
import com.google.appengine.api.datastore.PutContext;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitHelper;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.datastore.TransactionRunner;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

class AsyncDatastoreServiceImpl
extends BaseDatastoreServiceImpl
implements AsyncDatastoreService,
CurrentTransactionProvider {
    private final V3KeyBatcher<DatastorePb.DeleteResponse, DatastorePb.DeleteRequest> deleteBatcher = new V3KeyBatcher<DatastorePb.DeleteResponse, DatastorePb.DeleteRequest>(){

        @Override
        void addToBatch(OnestoreEntity.Reference value, DatastorePb.DeleteRequest batch) {
            batch.addKey(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<DatastorePb.DeleteResponse> makeCall(DatastorePb.DeleteRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, "Delete", batch, new DatastorePb.DeleteResponse());
        }
    };
    private final V3KeyBatcher<DatastorePb.GetResponse, DatastorePb.GetRequest> getByKeyBatcher = new V3KeyBatcher<DatastorePb.GetResponse, DatastorePb.GetRequest>(){

        @Override
        void addToBatch(OnestoreEntity.Reference value, DatastorePb.GetRequest batch) {
            batch.addKey(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchReadEntities;
        }

        @Override
        protected Future<DatastorePb.GetResponse> makeCall(DatastorePb.GetRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, "Get", batch, new DatastorePb.GetResponse());
        }
    };
    private final V3Batcher<DatastorePb.GetResponse, DatastorePb.GetRequest, OnestoreEntity.Reference, OnestoreEntity.Reference> getByReferenceBatcher = new V3Batcher<DatastorePb.GetResponse, DatastorePb.GetRequest, OnestoreEntity.Reference, OnestoreEntity.Reference>(){

        @Override
        final Object getGroup(OnestoreEntity.Reference value) {
            return value.getPath().getElement(0);
        }

        @Override
        final OnestoreEntity.Reference toPb(OnestoreEntity.Reference value) {
            return value;
        }

        @Override
        void addToBatch(OnestoreEntity.Reference value, DatastorePb.GetRequest batch) {
            batch.addKey(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchReadEntities;
        }

        @Override
        protected Future<DatastorePb.GetResponse> makeCall(DatastorePb.GetRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, "Get", batch, new DatastorePb.GetResponse());
        }
    };
    private final V3Batcher<DatastorePb.PutResponse, DatastorePb.PutRequest, Entity, OnestoreEntity.EntityProto> putBatcher = new V3Batcher<DatastorePb.PutResponse, DatastorePb.PutRequest, Entity, OnestoreEntity.EntityProto>(){

        @Override
        Object getGroup(Entity value) {
            return value.getKey().getRootKey();
        }

        @Override
        void addToBatch(OnestoreEntity.EntityProto value, DatastorePb.PutRequest batch) {
            batch.addEntity(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<DatastorePb.PutResponse> makeCall(DatastorePb.PutRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, "Put", batch, new DatastorePb.PutResponse());
        }

        @Override
        OnestoreEntity.EntityProto toPb(Entity value) {
            return EntityTranslator.convertToPb(value);
        }
    };
    private DatastoreAttributes.DatastoreType datastoreType;

    public AsyncDatastoreServiceImpl(DatastoreServiceConfig datastoreServiceConfig, TransactionStack defaultTxnProvider) {
        super(datastoreServiceConfig, defaultTxnProvider);
    }

    @Override
    public Future<Entity> get(Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        return this.wrapSingleGet(key, this.get(Arrays.asList(key)));
    }

    @Override
    public Future<Entity> get(Transaction txn, Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        return this.wrapSingleGet(key, this.get(txn, Arrays.asList(key)));
    }

    private Future<Entity> wrapSingleGet(final Key key, Future<Map<Key, Entity>> futureEntities) {
        return new FutureWrapper<Map<Key, Entity>, Entity>(futureEntities){

            @Override
            protected Entity wrap(Map<Key, Entity> entities) throws Exception {
                Entity entity = entities.get(key);
                if (entity == null) {
                    throw new EntityNotFoundException(key);
                }
                return entity;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<Map<Key, Entity>> get(final Iterable<Key> keys) {
        return new TransactionRunner<Map<Key, Entity>>(this.getOrCreateTransaction()){

            @Override
            protected Future<Map<Key, Entity>> runInternal(Transaction txn) {
                return AsyncDatastoreServiceImpl.this.get(txn, keys);
            }
        }.runReadInTransaction();
    }

    @Override
    public Future<Map<Key, Entity>> get(Transaction txn, Iterable<Key> keys) {
        if (keys == null) {
            throw new NullPointerException("keys cannot be null");
        }
        ArrayList<Key> keyList = Lists.newArrayList(keys);
        HashMap<Key, Entity> resultMap = new HashMap<Key, Entity>();
        PreGetContext preGetContext = new PreGetContext(this, keyList, resultMap);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreGetCallbacks(preGetContext);
        keyList.removeAll(resultMap.keySet());
        EntityCachingStrategy.PreGetCachingResult preGetCachingResult = this.entityCachingStrategy.preGet(this, keyList, resultMap);
        keyList.removeAll(preGetCachingResult.getKeysToSkipLoading());
        Future<Map<Key, Entity>> result = this.doBatchGet(txn, Sets.newLinkedHashSet(keyList), resultMap);
        result = this.entityCachingStrategy.createPostGetFuture(result, preGetCachingResult);
        return new PostLoadFuture(result, this.datastoreServiceConfig.getDatastoreCallbacks(), this);
    }

    private Future<Map<Key, Entity>> doBatchGet(Transaction txn, final Set<Key> keysToGet, final Map<Key, Entity> resultMap) {
        final DatastorePb.GetRequest baseReq = new DatastorePb.GetRequest();
        baseReq.setAllowDeferred(true);
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
        }
        if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            baseReq.setFailoverMs(-1L);
            baseReq.setStrong(false);
        }
        final boolean shouldUseMultipleBatches = this.getDatastoreType() != DatastoreAttributes.DatastoreType.MASTER_SLAVE && txn == null && this.datastoreServiceConfig.getReadPolicy().getConsistency() != ReadPolicy.Consistency.EVENTUAL;
        Iterator<DatastorePb.GetRequest> batches = this.getByKeyBatcher.getBatches(keysToGet, baseReq, shouldUseMultipleBatches);
        List futures = this.getByKeyBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new FutureHelper.MultiFuture<DatastorePb.GetResponse, Map<Key, Entity>>(futures){
            private Map<OnestoreEntity.Reference, Key> keyMapIgnoringAppId;

            @Override
            public Map<Key, Entity> get() throws InterruptedException, ExecutionException {
                try {
                    this.aggregate(this.futures, null, null);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
                return resultMap;
            }

            @Override
            public Map<Key, Entity> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.aggregate(this.futures, timeout, unit);
                return resultMap;
            }

            private void aggregate(Iterable<Future<DatastorePb.GetResponse>> currentFutures, Long timeout, TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
                while (true) {
                    LinkedList<OnestoreEntity.Reference> deferredRefs = Lists.newLinkedList();
                    for (Future<DatastorePb.GetResponse> currentFuture : currentFutures) {
                        DatastorePb.GetResponse resp = this.getFutureWithOptionalTimeout(currentFuture, timeout, timeoutUnit);
                        this.addEntitiesToResultMap(resp);
                        deferredRefs.addAll(resp.deferreds());
                    }
                    if (deferredRefs.isEmpty()) break;
                    Iterator<DatastorePb.GetRequest> followupBatches = AsyncDatastoreServiceImpl.this.getByReferenceBatcher.getBatches(deferredRefs, baseReq, shouldUseMultipleBatches);
                    currentFutures = AsyncDatastoreServiceImpl.this.getByReferenceBatcher.makeCalls(followupBatches);
                }
            }

            private DatastorePb.GetResponse getFutureWithOptionalTimeout(Future<DatastorePb.GetResponse> future, Long timeout, TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
                if (timeout == null) {
                    return future.get();
                }
                return future.get(timeout, timeoutUnit);
            }

            private void addEntitiesToResultMap(DatastorePb.GetResponse response) {
                for (DatastorePb.GetResponse.Entity entityResult : response.entitys()) {
                    if (!entityResult.hasEntity()) continue;
                    Entity responseEntity = EntityTranslator.createFromPb(entityResult.getEntity());
                    Key responseKey = responseEntity.getKey();
                    if (!keysToGet.contains(responseKey)) {
                        responseKey = this.findKeyFromRequestIgnoringAppId(entityResult.getEntity().getKey());
                    }
                    resultMap.put(responseKey, responseEntity);
                }
            }

            private Key findKeyFromRequestIgnoringAppId(OnestoreEntity.Reference referenceFromResponse) {
                Key result;
                if (this.keyMapIgnoringAppId == null) {
                    this.keyMapIgnoringAppId = Maps.newHashMap();
                    for (Key requestKey : keysToGet) {
                        OnestoreEntity.Reference requestKeyAsRefWithoutApp = KeyTranslator.convertToPb(requestKey).clearApp();
                        this.keyMapIgnoringAppId.put(requestKeyAsRefWithoutApp, requestKey);
                    }
                }
                if ((result = this.keyMapIgnoringAppId.get(referenceFromResponse.clearApp())) == null) {
                    throw new DatastoreFailureException("Internal error");
                }
                return result;
            }
        });
    }

    @Override
    public Future<Key> put(Entity entity) {
        return this.wrapSinglePut(this.put(Arrays.asList(entity)));
    }

    @Override
    public Future<Key> put(Transaction txn, Entity entity) {
        return this.wrapSinglePut(this.put(txn, Arrays.asList(entity)));
    }

    private Future<Key> wrapSinglePut(Future<List<Key>> futureKeys) {
        return new FutureWrapper<List<Key>, Key>(futureKeys){

            @Override
            protected Key wrap(List<Key> keys) throws Exception {
                return keys.get(0);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<List<Key>> put(final Iterable<Entity> entities) {
        return new TransactionRunner<List<Key>>(this.getOrCreateTransaction()){

            @Override
            protected Future<List<Key>> runInternal(Transaction txn) {
                return AsyncDatastoreServiceImpl.this.put(txn, entities);
            }
        }.runWriteInTransaction();
    }

    @Override
    public Future<List<Key>> put(Transaction txn, Iterable<Entity> entities) {
        ArrayList<Entity> entitiesToPut;
        ArrayList<Entity> entityList = entities instanceof List ? (ArrayList<Entity>)entities : Lists.newArrayList(entities);
        PutContext prePutContext = new PutContext((CurrentTransactionProvider)this, (List<Entity>)entityList);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePrePutCallbacks(prePutContext);
        EntityCachingStrategy.PreMutationCachingResult preMutationCachingResult = this.entityCachingStrategy.prePut(this, entityList);
        ArrayList<Batcher.IndexedItem<Key>> indexedKeysToSkip = Lists.newArrayList();
        Set<Key> mutationKeysToSkip = preMutationCachingResult.getMutationKeysToSkip();
        if (!mutationKeysToSkip.isEmpty()) {
            entitiesToPut = Lists.newArrayList();
            int index = 0;
            for (Entity entity : entityList) {
                if (mutationKeysToSkip.contains(entity.getKey())) {
                    indexedKeysToSkip.add(new Batcher.IndexedItem<Key>(index++, entity.getKey()));
                    continue;
                }
                entitiesToPut.add(entity);
                ++index;
            }
        } else {
            entitiesToPut = ImmutableList.copyOf(entities);
        }
        PostPutFuture result = this.combinePutResult(this.doBatchPut(txn, entitiesToPut), indexedKeysToSkip);
        if (txn == null) {
            result = this.entityCachingStrategy.createPostMutationFuture(result, preMutationCachingResult);
            PutContext postPutContext = new PutContext((CurrentTransactionProvider)this, (List<Entity>)entityList);
            result = new PostPutFuture(result, this.datastoreServiceConfig.getDatastoreCallbacks(), postPutContext);
        } else {
            this.defaultTxnProvider.addPutEntities(txn, entityList);
        }
        return result;
    }

    private Future<List<Key>> combinePutResult(Future<List<Key>> rpcResult, final List<Batcher.IndexedItem<Key>> skippedKeys) {
        if (skippedKeys.isEmpty()) {
            return rpcResult;
        }
        return new FutureWrapper<List<Key>, List<Key>>(rpcResult){

            @Override
            protected List<Key> wrap(List<Key> result) throws Exception {
                LinkedList<Key> combined = Lists.newLinkedList(result);
                for (Batcher.IndexedItem indexedKey : skippedKeys) {
                    combined.add(indexedKey.index, (Key)indexedKey.item);
                }
                return combined;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    private Future<List<Key>> doBatchPut(Transaction txn, final List<Entity> entities) {
        DatastorePb.PutRequest baseReq = new DatastorePb.PutRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
        }
        boolean group = !baseReq.hasTransaction();
        ArrayList<Integer> order = Lists.newArrayListWithCapacity(entities.size());
        Iterator<DatastorePb.PutRequest> batches = this.putBatcher.getBatches(entities, baseReq, group, order);
        List<Future<DatastorePb.PutResponse>> futures = this.putBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new Batcher.ReorderingMultiFuture<DatastorePb.PutResponse, List<Key>>(futures, order){

            @Override
            protected List<Key> aggregate(DatastorePb.PutResponse intermediateResult, Iterator<Integer> indexItr, List<Key> result) {
                for (OnestoreEntity.Reference reference : intermediateResult.keys()) {
                    int index = indexItr.next();
                    Key key = ((Entity)entities.get(index)).getKey();
                    KeyTranslator.updateKey(reference, key);
                    result.set(index, key);
                }
                return result;
            }

            @Override
            protected List<Key> initResult(int size) {
                ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(size, null));
                return result;
            }
        });
    }

    @Override
    public Future<Void> delete(Key ... keys) {
        return this.delete(Arrays.asList(keys));
    }

    @Override
    public Future<Void> delete(Transaction txn, Key ... keys) {
        return this.delete(txn, Arrays.asList(keys));
    }

    @Override
    public Future<Void> delete(final Iterable<Key> keys) {
        return new TransactionRunner<Void>(this.getOrCreateTransaction()){

            @Override
            protected Future<Void> runInternal(Transaction txn) {
                return AsyncDatastoreServiceImpl.this.delete(txn, keys);
            }
        }.runWriteInTransaction();
    }

    @Override
    public Future<Void> delete(Transaction txn, Iterable<Key> keys) {
        AbstractCollection keysToDelete;
        ImmutableList<Key> allKeys = keys instanceof List ? (ImmutableList<Key>)keys : ImmutableList.copyOf(keys);
        DeleteContext preDeleteContext = new DeleteContext((CurrentTransactionProvider)this, (List<Key>)allKeys);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreDeleteCallbacks(preDeleteContext);
        EntityCachingStrategy.PreMutationCachingResult preMutationCachingResult = this.entityCachingStrategy.preDelete(this, allKeys);
        PostDeleteFuture result = null;
        Set<Key> keysToSkip = preMutationCachingResult.getMutationKeysToSkip();
        if (keysToSkip.isEmpty()) {
            keysToDelete = allKeys;
        } else {
            HashSet<Key> keySet = Sets.newHashSet(allKeys);
            keySet.removeAll(keysToSkip);
            keysToDelete = keySet;
        }
        result = this.doBatchDelete(txn, keysToDelete);
        if (txn == null) {
            result = this.entityCachingStrategy.createPostMutationFuture(result, preMutationCachingResult);
            result = new PostDeleteFuture(result, this.datastoreServiceConfig.getDatastoreCallbacks(), new DeleteContext((CurrentTransactionProvider)this, (List<Key>)allKeys));
        } else {
            this.defaultTxnProvider.addDeletedKeys(txn, allKeys);
        }
        return result;
    }

    private Future<Void> doBatchDelete(Transaction txn, Collection<Key> keys) {
        DatastorePb.DeleteRequest baseReq = new DatastorePb.DeleteRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
        }
        boolean group = !baseReq.hasTransaction();
        Iterator<DatastorePb.DeleteRequest> batches = this.deleteBatcher.getBatches(keys, baseReq, group);
        List futures = this.deleteBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new FutureHelper.MultiFuture<DatastorePb.DeleteResponse, Void>(futures){

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                for (Future future : this.futures) {
                    future.get();
                }
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                for (Future future : this.futures) {
                    future.get(timeout, unit);
                }
                return null;
            }
        });
    }

    @Override
    public Collection<Transaction> getActiveTransactions() {
        return this.defaultTxnProvider.getAll();
    }

    private <T> Future<T> registerInTransaction(Transaction txn, Future<T> future) {
        if (txn != null) {
            this.defaultTxnProvider.addFuture(txn, future);
            return new FutureHelper.TxnAwareFuture<T>(future, txn, this.defaultTxnProvider);
        }
        return future;
    }

    @Override
    public Future<Transaction> beginTransaction() {
        return this.beginTransaction(TransactionOptions.Builder.withDefaults());
    }

    @Override
    public Future<Transaction> beginTransaction(TransactionOptions options) {
        return new FutureHelper.FakeFuture<Transaction>(this.beginTransactionInternal(options, true));
    }

    @Override
    public PreparedQuery prepare(Query query) {
        return this.prepare(null, query);
    }

    @Override
    public PreparedQuery prepare(Transaction txn, Query query) {
        PreQueryContext context = new PreQueryContext((CurrentTransactionProvider)this, query);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreQueryCallbacks(context);
        query = (Query)context.getElements().get(0);
        AsyncDatastoreServiceImpl.validateQuery(query);
        List<MultiQueryBuilder> queriesToRun = QuerySplitHelper.splitQuery(query);
        query.setFilter(null);
        query.getFilterPredicates().clear();
        if (queriesToRun.size() == 1 && queriesToRun.get(0).isSingleton()) {
            query.getFilterPredicates().addAll(queriesToRun.get(0).getBaseFilters());
            return new PreparedQueryImpl(this.apiConfig, this.datastoreServiceConfig, query, txn);
        }
        return new PreparedMultiQuery(this.apiConfig, this.datastoreServiceConfig, query, queriesToRun, txn);
    }

    @Override
    public Future<KeyRange> allocateIds(String kind, long num) {
        return this.allocateIds(null, kind, num);
    }

    static OnestoreEntity.Reference buildAllocateIdsRef(Key parent, String kind, AppIdNamespace appIdNamespace) {
        if (parent != null && !parent.isComplete()) {
            throw new IllegalArgumentException("parent key must be complete");
        }
        Key key = new Key(kind, parent, 0L, "ignored", appIdNamespace);
        return KeyTranslator.convertToPb(key);
    }

    @Override
    public Future<KeyRange> allocateIds(final Key parent, final String kind, long num) {
        if (num <= 0L) {
            throw new IllegalArgumentException("num must be > 0");
        }
        if (num > 1000000000L) {
            throw new IllegalArgumentException("num must be < 1 billion");
        }
        final AppIdNamespace appIdNamespace = this.datastoreServiceConfig.getAppIdNamespace();
        OnestoreEntity.Reference allocateIdsRef = AsyncDatastoreServiceImpl.buildAllocateIdsRef(parent, kind, appIdNamespace);
        DatastorePb.AllocateIdsRequest req = new DatastorePb.AllocateIdsRequest().setSize(num).setModelKey(allocateIdsRef);
        DatastorePb.AllocateIdsResponse resp = new DatastorePb.AllocateIdsResponse();
        Future<DatastorePb.AllocateIdsResponse> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, "AllocateIds", req, resp);
        return new FutureWrapper<DatastorePb.AllocateIdsResponse, KeyRange>(future){

            @Override
            protected KeyRange wrap(DatastorePb.AllocateIdsResponse resp) throws Exception {
                return new KeyRange(parent, kind, resp.getStart(), resp.getEnd(), appIdNamespace);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    Future<DatastoreService.KeyRangeState> allocateIdRange(final KeyRange range) {
        Key parent = range.getParent();
        final String kind = range.getKind();
        final long start = range.getStart().getId();
        long end = range.getEnd().getId();
        DatastorePb.AllocateIdsRequest req = new DatastorePb.AllocateIdsRequest().setModelKey(AsyncDatastoreServiceImpl.buildAllocateIdsRef(parent, kind, null)).setMax(end);
        DatastorePb.AllocateIdsResponse resp = new DatastorePb.AllocateIdsResponse();
        Future<DatastorePb.AllocateIdsResponse> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, "AllocateIds", req, resp);
        return new FutureWrapper<DatastorePb.AllocateIdsResponse, DatastoreService.KeyRangeState>(future){

            @Override
            protected DatastoreService.KeyRangeState wrap(DatastorePb.AllocateIdsResponse resp) throws Exception {
                Query query = new Query(kind).setKeysOnly();
                query.addFilter("__key__", Query.FilterOperator.GREATER_THAN_OR_EQUAL, range.getStart());
                query.addFilter("__key__", Query.FilterOperator.LESS_THAN_OR_EQUAL, range.getEnd());
                List<Entity> collision = AsyncDatastoreServiceImpl.this.prepare(query).asList(FetchOptions.Builder.withLimit(1));
                if (!collision.isEmpty()) {
                    return DatastoreService.KeyRangeState.COLLISION;
                }
                boolean raceCondition = start < resp.getStart();
                return raceCondition ? DatastoreService.KeyRangeState.CONTENTION : DatastoreService.KeyRangeState.EMPTY;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    protected DatastoreAttributes.DatastoreType getDatastoreType() {
        if (this.datastoreType == null) {
            this.datastoreType = FutureHelper.quietGet(this.getDatastoreAttributes()).getDatastoreType();
        }
        return this.datastoreType;
    }

    @Override
    public Future<DatastoreAttributes> getDatastoreAttributes() {
        String appId = this.datastoreServiceConfig.getAppIdNamespace().getAppId();
        DatastoreAttributes attributes = new DatastoreAttributes(appId);
        return new FutureHelper.FakeFuture<DatastoreAttributes>(attributes);
    }

    @Override
    public Future<Map<Index, Index.IndexState>> getIndexes() {
        ApiBasePb.StringProto req = new ApiBasePb.StringProto();
        req.setValue(this.datastoreServiceConfig.getAppIdNamespace().getAppId());
        return new FutureWrapper<DatastorePb.CompositeIndices, Map<Index, Index.IndexState>>(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "GetIndices", req, new DatastorePb.CompositeIndices())){

            @Override
            protected Map<Index, Index.IndexState> wrap(DatastorePb.CompositeIndices indices) throws Exception {
                LinkedHashMap<Index, Index.IndexState> answer = new LinkedHashMap<Index, Index.IndexState>();
                block6: for (OnestoreEntity.CompositeIndex ci : indices.indexs()) {
                    Index index = IndexTranslator.convertFromPb(ci);
                    switch (ci.getStateEnum()) {
                        case DELETED: {
                            answer.put(index, Index.IndexState.DELETING);
                            continue block6;
                        }
                        case ERROR: {
                            answer.put(index, Index.IndexState.ERROR);
                            continue block6;
                        }
                        case READ_WRITE: {
                            answer.put(index, Index.IndexState.SERVING);
                            continue block6;
                        }
                        case WRITE_ONLY: {
                            answer.put(index, Index.IndexState.BUILDING);
                            continue block6;
                        }
                    }
                    AsyncDatastoreServiceImpl.this.logger.log(Level.WARNING, "Unrecognized index state for " + index);
                }
                return answer;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    private abstract class V3KeyBatcher<S extends ProtocolMessage<S>, R extends ProtocolMessage<R>>
    extends V3Batcher<S, R, Key, OnestoreEntity.Reference> {
        private V3KeyBatcher() {
        }

        @Override
        final Object getGroup(Key value) {
            return value.getRootKey();
        }

        @Override
        final OnestoreEntity.Reference toPb(Key value) {
            return KeyTranslator.convertToPb(value);
        }
    }

    private abstract class V3Batcher<S extends ProtocolMessage<S>, R extends ProtocolMessage<R>, F, T extends ProtocolMessage<T>>
    extends Batcher<R, F, T> {
        private V3Batcher() {
        }

        protected abstract Future<S> makeCall(R var1);

        @Override
        final R newBatch(R baseBatch) {
            return (R)((ProtocolMessage)baseBatch).clone();
        }

        @Override
        final int getMaxSize() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxRpcSizeBytes;
        }

        @Override
        final int getMaxGroups() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxEntityGroupsPerRpc;
        }

        final List<Future<S>> makeCalls(Iterator<R> batches) {
            ArrayList<Future<S>> futures = new ArrayList<Future<S>>();
            while (batches.hasNext()) {
                futures.add(this.makeCall((ProtocolMessage)batches.next()));
            }
            return futures;
        }
    }
}

