/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.DeleteContext;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityCachingStrategy;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PostOpFuture;
import com.google.appengine.api.datastore.PutContext;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import java.util.List;
import java.util.concurrent.Future;

class TransactionImpl
implements Transaction,
CurrentTransactionProvider {
    private final ApiProxy.ApiConfig apiConfig;
    private final String app;
    private final Future<DatastorePb.Transaction> future;
    private final TransactionStack txnStack;
    private final DatastoreCallbacks callbacks;
    private final EntityCachingStrategy entityCachingStrategy;
    private final boolean isExplicit;
    TransactionState state = TransactionState.BEGUN;

    TransactionImpl(ApiProxy.ApiConfig apiConfig, String app, Future<DatastorePb.Transaction> future, TransactionStack txnStack, DatastoreCallbacks callbacks, EntityCachingStrategy entityCachingStrategy, boolean isExplicit) {
        this.apiConfig = apiConfig;
        this.app = app;
        this.future = future;
        this.txnStack = txnStack;
        this.callbacks = callbacks;
        this.entityCachingStrategy = entityCachingStrategy;
        this.isExplicit = isExplicit;
    }

    private long getHandle() {
        return FutureHelper.quietGet(this.future).getHandle();
    }

    <T extends ProtocolMessage<T>> Future<T> makeAsyncCall(String methodName, ProtocolMessage<?> request, T response) {
        return DatastoreApiHelper.makeAsyncCall(this.apiConfig, methodName, request, response);
    }

    private <T extends ProtocolMessage<T>> Future<T> makeAsyncCall(String methodName, T response) {
        DatastorePb.Transaction txn = new DatastorePb.Transaction();
        txn.setApp(this.app);
        txn.setHandle(this.getHandle());
        return this.makeAsyncCall(methodName, txn, response);
    }

    @Override
    public void commit() {
        FutureHelper.quietGet(this.commitAsync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> commitAsync() {
        this.ensureTxnStarted();
        try {
            for (Future future : this.txnStack.getFutures(this)) {
                FutureHelper.quietGet(future);
            }
            EntityCachingStrategy.PreMutationCachingResult preMutationCachingResult = this.entityCachingStrategy.preCommit(this.txnStack.getPutEntities(this), this.txnStack.getDeletedKeys(this));
            Future<DatastorePb.CommitResponse> future = this.makeAsyncCall("Commit", new DatastorePb.CommitResponse());
            this.state = TransactionState.COMPLETION_IN_PROGRESS;
            Future<Object> result = new FutureWrapper<DatastorePb.CommitResponse, Void>(future){

                @Override
                protected Void wrap(DatastorePb.CommitResponse ignore) throws Exception {
                    TransactionImpl.this.state = TransactionState.COMMITTED;
                    return null;
                }

                @Override
                protected Throwable convertException(Throwable cause) {
                    TransactionImpl.this.state = TransactionState.ERROR;
                    return cause;
                }
            };
            result = this.entityCachingStrategy.createPostMutationFuture(result, preMutationCachingResult);
            PostCommitFuture postCommitFuture = new PostCommitFuture(this.txnStack.getPutEntities(this), this.txnStack.getDeletedKeys(this), result);
            return postCommitFuture;
        }
        finally {
            if (this.isExplicit) {
                this.txnStack.remove(this);
            }
        }
    }

    @Override
    public void rollback() {
        FutureHelper.quietGet(this.rollbackAsync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> rollbackAsync() {
        this.ensureTxnStarted();
        try {
            for (Future futureWrapper : this.txnStack.getFutures(this)) {
                FutureHelper.quietGet(futureWrapper);
            }
            Future<ApiBasePb.VoidProto> future = this.makeAsyncCall("Rollback", new ApiBasePb.VoidProto());
            this.state = TransactionState.COMPLETION_IN_PROGRESS;
            FutureWrapper<ApiBasePb.VoidProto, Void> futureWrapper = new FutureWrapper<ApiBasePb.VoidProto, Void>(future){

                @Override
                protected Void wrap(ApiBasePb.VoidProto ignore) throws Exception {
                    TransactionImpl.this.state = TransactionState.ROLLED_BACK;
                    return null;
                }

                @Override
                protected Throwable convertException(Throwable cause) {
                    TransactionImpl.this.state = TransactionState.ERROR;
                    return cause;
                }
            };
            return futureWrapper;
        }
        finally {
            if (this.isExplicit) {
                this.txnStack.remove(this);
            }
        }
    }

    @Override
    public String getApp() {
        return this.app;
    }

    @Override
    public String getId() {
        return Long.toString(this.getHandle());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionImpl that = (TransactionImpl)o;
        return this.getHandle() == that.getHandle();
    }

    public int hashCode() {
        return (int)(this.getHandle() ^ this.getHandle() >>> 32);
    }

    public String toString() {
        return "Txn [" + this.app + "." + this.getHandle() + ", " + (Object)((Object)this.state) + "]";
    }

    @Override
    public boolean isActive() {
        return this.state == TransactionState.BEGUN || this.state == TransactionState.COMPLETION_IN_PROGRESS;
    }

    @Override
    public Transaction getCurrentTransaction(Transaction defaultValue) {
        return this;
    }

    static void ensureTxnActive(Transaction txn) {
        if (txn != null && !txn.isActive()) {
            throw new IllegalStateException("Transaction with which this operation is associated is not active.");
        }
    }

    private void ensureTxnStarted() {
        if (this.state != TransactionState.BEGUN) {
            throw new IllegalStateException("Transaction is in state " + (Object)((Object)this.state) + ".  There is no legal " + "transition out of this state.");
        }
    }

    private class PostCommitFuture
    extends PostOpFuture<Void> {
        private final List<Entity> putEntities;
        private final List<Key> deletedKeys;

        private PostCommitFuture(List<Entity> putEntities, List<Key> deletedKeys, Future<Void> delegate) {
            super(delegate, TransactionImpl.this.callbacks);
            this.putEntities = putEntities;
            this.deletedKeys = deletedKeys;
        }

        @Override
        void executeCallbacks(Void ignoreMe) {
            PutContext putContext = new PutContext((CurrentTransactionProvider)TransactionImpl.this, this.putEntities);
            TransactionImpl.this.callbacks.executePostPutCallbacks(putContext);
            DeleteContext deleteContext = new DeleteContext((CurrentTransactionProvider)TransactionImpl.this, this.deletedKeys);
            TransactionImpl.this.callbacks.executePostDeleteCallbacks(deleteContext);
        }
    }

    static enum TransactionState {
        BEGUN,
        COMPLETION_IN_PROGRESS,
        COMMITTED,
        ROLLED_BACK,
        ERROR;

    }
}

