/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseAsyncDatastoreServiceImpl;
import com.google.appengine.api.datastore.Batcher;
import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.InternalTransactionV4;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.QueryRunnerV4;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class AsyncDatastoreV4ServiceImpl
extends BaseAsyncDatastoreServiceImpl {
    private final V4Batcher<DatastoreV4.CommitResponse, DatastoreV4.CommitRequest.Builder, Key, DatastoreV4.Mutation> deleteBatcher = new V4Batcher<DatastoreV4.CommitResponse, DatastoreV4.CommitRequest.Builder, Key, DatastoreV4.Mutation>(){

        @Override
        void addToBatch(DatastoreV4.Mutation mutation, DatastoreV4.CommitRequest.Builder batch) {
            batch.addMutation(mutation);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreV4ServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<DatastoreV4.CommitResponse> makeCall(DatastoreV4.CommitRequest.Builder batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreV4ServiceImpl.this.apiConfig, DatastoreV4.DatastoreV4Service.Method.Commit, batch.build(), DatastoreV4.CommitResponse.getDefaultInstance());
        }

        @Override
        final Object getGroup(Key key) {
            return key.getRootKey();
        }

        @Override
        final DatastoreV4.Mutation toPb(Key value) {
            return DatastoreV4.Mutation.newBuilder().setOp(DatastoreV4.Mutation.Operation.DELETE).setKey(DataTypeTranslator.toV4Key(value)).build();
        }
    };
    private final V4Batcher<DatastoreV4.LookupResponse, DatastoreV4.LookupRequest.Builder, Key, EntityV4.Key> lookupByKeyBatcher = new V4Batcher<DatastoreV4.LookupResponse, DatastoreV4.LookupRequest.Builder, Key, EntityV4.Key>(){

        @Override
        void addToBatch(EntityV4.Key key, DatastoreV4.LookupRequest.Builder batch) {
            batch.addKey(key);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreV4ServiceImpl.this.datastoreServiceConfig.maxBatchReadEntities;
        }

        @Override
        protected Future<DatastoreV4.LookupResponse> makeCall(DatastoreV4.LookupRequest.Builder batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreV4ServiceImpl.this.apiConfig, DatastoreV4.DatastoreV4Service.Method.Lookup, batch.build(), DatastoreV4.LookupResponse.getDefaultInstance());
        }

        @Override
        final Object getGroup(Key key) {
            return key.getRootKey();
        }

        @Override
        final EntityV4.Key toPb(Key value) {
            return DataTypeTranslator.toV4Key(value).build();
        }
    };
    private final V4Batcher<DatastoreV4.LookupResponse, DatastoreV4.LookupRequest.Builder, EntityV4.Key, EntityV4.Key> lookupByPbBatcher = new V4Batcher<DatastoreV4.LookupResponse, DatastoreV4.LookupRequest.Builder, EntityV4.Key, EntityV4.Key>(){

        @Override
        void addToBatch(EntityV4.Key key, DatastoreV4.LookupRequest.Builder batch) {
            batch.addKey(key);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreV4ServiceImpl.this.datastoreServiceConfig.maxBatchReadEntities;
        }

        @Override
        protected Future<DatastoreV4.LookupResponse> makeCall(DatastoreV4.LookupRequest.Builder batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreV4ServiceImpl.this.apiConfig, DatastoreV4.DatastoreV4Service.Method.Lookup, batch.build(), DatastoreV4.LookupResponse.getDefaultInstance());
        }

        @Override
        final Object getGroup(EntityV4.Key key) {
            return key.getPathElement(0);
        }

        @Override
        final EntityV4.Key toPb(EntityV4.Key value) {
            return value;
        }
    };
    private final V4Batcher<DatastoreV4.CommitResponse, DatastoreV4.CommitRequest.Builder, Entity, DatastoreV4.Mutation> putBatcher = new V4Batcher<DatastoreV4.CommitResponse, DatastoreV4.CommitRequest.Builder, Entity, DatastoreV4.Mutation>(){

        @Override
        void addToBatch(DatastoreV4.Mutation mutation, DatastoreV4.CommitRequest.Builder batch) {
            batch.addMutation(mutation);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreV4ServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<DatastoreV4.CommitResponse> makeCall(DatastoreV4.CommitRequest.Builder batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreV4ServiceImpl.this.apiConfig, DatastoreV4.DatastoreV4Service.Method.Commit, batch.build(), DatastoreV4.CommitResponse.getDefaultInstance());
        }

        @Override
        final Object getGroup(Entity value) {
            return value.getKey().getRootKey();
        }

        @Override
        final DatastoreV4.Mutation toPb(Entity value) {
            return DatastoreV4.Mutation.newBuilder().setOp(DatastoreV4.Mutation.Operation.UPSERT).setEntity(DataTypeTranslator.toV4Entity(value)).build();
        }
    };
    private final V4Batcher<DatastoreV4.AllocateIdsResponse, DatastoreV4.AllocateIdsRequest.Builder, Key, EntityV4.Key> allocateIdsBatcher = new V4Batcher<DatastoreV4.AllocateIdsResponse, DatastoreV4.AllocateIdsRequest.Builder, Key, EntityV4.Key>(){

        @Override
        void addToBatch(EntityV4.Key key, DatastoreV4.AllocateIdsRequest.Builder batch) {
            batch.addAllocate(key);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreV4ServiceImpl.this.datastoreServiceConfig.maxBatchAllocateIdKeys;
        }

        @Override
        protected Future<DatastoreV4.AllocateIdsResponse> makeCall(DatastoreV4.AllocateIdsRequest.Builder batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreV4ServiceImpl.this.apiConfig, DatastoreV4.DatastoreV4Service.Method.AllocateIds, batch.build(), DatastoreV4.AllocateIdsResponse.getDefaultInstance());
        }

        @Override
        final Object getGroup(Key key) {
            Key parent = key.getParent();
            if (parent == null) {
                return EntityV4.Key.PathElement.getDefaultInstance();
            }
            return DataTypeTranslator.toV4Key(parent).getPathElement(0);
        }

        @Override
        final EntityV4.Key toPb(Key value) {
            return DataTypeTranslator.toV4Key(value).build();
        }
    };

    public AsyncDatastoreV4ServiceImpl(DatastoreServiceConfig datastoreServiceConfig, TransactionStack defaultTxnProvider) {
        super(datastoreServiceConfig, defaultTxnProvider, new QueryRunnerV4());
    }

    @Override
    protected TransactionImpl.InternalTransaction doBeginTransaction(TransactionOptions options) {
        DatastoreV4.BeginTransactionRequest.Builder request = DatastoreV4.BeginTransactionRequest.newBuilder();
        request.setCrossGroup(options.isXG());
        Future<DatastoreV4.BeginTransactionResponse> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastoreV4.DatastoreV4Service.Method.BeginTransaction, request.build(), DatastoreV4.BeginTransactionResponse.getDefaultInstance());
        return InternalTransactionV4.create(this.apiConfig, future);
    }

    @Override
    protected Future<Map<Key, Entity>> doBatchGet(Transaction txn, final Set<Key> keysToGet, final Map<Key, Entity> resultMap) {
        final DatastoreV4.LookupRequest.Builder baseReq = DatastoreV4.LookupRequest.newBuilder();
        DatastoreV4.ReadOptions.Builder readOptionsBuilder = baseReq.getReadOptionsBuilder();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            readOptionsBuilder.setTransaction(InternalTransactionV4.getById(txn.getId()).getHandle());
        } else if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            readOptionsBuilder.setReadConsistency(DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL);
        } else {
            baseReq.clearReadOptions();
        }
        final boolean shouldUseMultipleBatches = this.getDatastoreType() != DatastoreAttributes.DatastoreType.MASTER_SLAVE && txn == null && this.datastoreServiceConfig.getReadPolicy().getConsistency() != ReadPolicy.Consistency.EVENTUAL;
        Iterator<DatastoreV4.LookupRequest.Builder> batches = this.lookupByKeyBatcher.getBatches(keysToGet, baseReq, baseReq.build().getSerializedSize(), shouldUseMultipleBatches);
        List futures = this.lookupByKeyBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new FutureHelper.MultiFuture<DatastoreV4.LookupResponse, Map<Key, Entity>>(futures){
            private Map<EntityV4.Key, Key> keyMapIgnoringAppId;

            @Override
            public Map<Key, Entity> get() throws InterruptedException, ExecutionException {
                try {
                    this.aggregate(this.futures, null, null);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
                return resultMap;
            }

            @Override
            public Map<Key, Entity> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.aggregate(this.futures, timeout, unit);
                return resultMap;
            }

            private void aggregate(Iterable<Future<DatastoreV4.LookupResponse>> currentFutures, Long timeout, TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
                while (true) {
                    ArrayList<EntityV4.Key> deferredKeys = Lists.newArrayList();
                    for (Future<DatastoreV4.LookupResponse> currentFuture : currentFutures) {
                        DatastoreV4.LookupResponse resp = this.getFutureWithOptionalTimeout(currentFuture, timeout, timeoutUnit);
                        this.addEntitiesToResultMap(resp);
                        deferredKeys.addAll(resp.getDeferredList());
                    }
                    if (deferredKeys.isEmpty()) break;
                    Iterator<DatastoreV4.LookupRequest.Builder> followupBatches = AsyncDatastoreV4ServiceImpl.this.lookupByPbBatcher.getBatches(deferredKeys, baseReq, baseReq.build().getSerializedSize(), shouldUseMultipleBatches);
                    currentFutures = AsyncDatastoreV4ServiceImpl.this.lookupByPbBatcher.makeCalls(followupBatches);
                }
            }

            private DatastoreV4.LookupResponse getFutureWithOptionalTimeout(Future<DatastoreV4.LookupResponse> future, Long timeout, TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
                if (timeout == null) {
                    return future.get();
                }
                return future.get(timeout, timeoutUnit);
            }

            private void addEntitiesToResultMap(DatastoreV4.LookupResponse response) {
                for (DatastoreV4.EntityResult entityResult : response.getFoundList()) {
                    Entity responseEntity = DataTypeTranslator.toEntity(entityResult.getEntity());
                    Key responseKey = responseEntity.getKey();
                    if (!keysToGet.contains(responseKey)) {
                        responseKey = this.findKeyFromRequestIgnoringAppId(entityResult.getEntity().getKey());
                    }
                    resultMap.put(responseKey, responseEntity);
                }
            }

            private Key findKeyFromRequestIgnoringAppId(EntityV4.Key keyFromResponse) {
                if (this.keyMapIgnoringAppId == null) {
                    this.keyMapIgnoringAppId = Maps.newHashMap();
                    for (Key requestKey : keysToGet) {
                        EntityV4.Key.Builder requestKeyAsRefWithoutApp = DataTypeTranslator.toV4Key(requestKey);
                        requestKeyAsRefWithoutApp.getPartitionIdBuilder().clearDatasetId();
                        this.keyMapIgnoringAppId.put(requestKeyAsRefWithoutApp.build(), requestKey);
                    }
                }
                EntityV4.Key.Builder keyBuilder = keyFromResponse.toBuilder();
                keyBuilder.getPartitionIdBuilder().clearDatasetId();
                Key result = this.keyMapIgnoringAppId.get(keyBuilder.build());
                if (result == null) {
                    throw new DatastoreFailureException("Internal error");
                }
                return result;
            }
        });
    }

    @Override
    protected Future<List<Key>> doBatchPut(Transaction txn, final List<Entity> entities) {
        if (txn == null) {
            DatastoreV4.CommitRequest.Builder baseReq = DatastoreV4.CommitRequest.newBuilder();
            baseReq.setMode(DatastoreV4.CommitRequest.Mode.NON_TRANSACTIONAL);
            ArrayList<Integer> order = Lists.newArrayListWithCapacity(entities.size());
            Iterator<DatastoreV4.CommitRequest.Builder> batches = this.putBatcher.getBatches(entities, baseReq, baseReq.build().getSerializedSize(), true, order);
            List futures = this.putBatcher.makeCalls(batches);
            return new Batcher.ReorderingMultiFuture<DatastoreV4.CommitResponse, List<Key>>(futures, order){

                @Override
                protected List<Key> aggregate(DatastoreV4.CommitResponse intermediateResult, Iterator<Integer> indexItr, List<Key> result) {
                    for (DatastoreV4.MutationResult mutationResult : intermediateResult.getMutationResultList()) {
                        int index = indexItr.next();
                        Key key = ((Entity)entities.get(index)).getKey();
                        if (mutationResult.hasKey()) {
                            List<EntityV4.Key.PathElement> pathElements = mutationResult.getKey().getPathElementList();
                            key.setId(pathElements.get(pathElements.size() - 1).getId());
                        }
                        result.set(index, key);
                    }
                    return result;
                }

                @Override
                protected List<Key> initResult(int size) {
                    ArrayList<Key> keyList = Lists.newArrayListWithCapacity(size);
                    keyList.addAll(Collections.nCopies(size, null));
                    return keyList;
                }
            };
        }
        TransactionImpl.ensureTxnActive(txn);
        final InternalTransactionV4 v4txn = InternalTransactionV4.getById(txn.getId());
        ImmutableList.Builder keyListBuilder = ImmutableList.builder();
        final ArrayList<Key> incompleteKeys = Lists.newArrayList();
        final ArrayList<EntityV4.Entity.Builder> incompleteEntityBldrs = Lists.newArrayList();
        for (Entity entity : entities) {
            Key key = entity.getKey();
            keyListBuilder.add(key);
            if (key.isComplete()) {
                v4txn.deferPut(entity);
                continue;
            }
            EntityV4.Entity.Builder v4Entity = EntityV4.Entity.newBuilder();
            DataTypeTranslator.addPropertiesToPb(entity.getPropertyMap(), v4Entity);
            incompleteEntityBldrs.add(v4Entity);
            incompleteKeys.add(key);
        }
        ImmutableCollection allKeys = keyListBuilder.build();
        if (incompleteKeys.isEmpty()) {
            return new FutureHelper.FakeFuture<ImmutableCollection>(allKeys);
        }
        return this.registerInTransaction(txn, new FutureWrapper<List<EntityV4.Key>, List<Key>>(this.allocateIds(incompleteKeys), (List)((Object)allKeys)){
            final /* synthetic */ List val$allKeys;
            {
                this.val$allKeys = list3;
                super(x0);
            }

            @Override
            protected List<Key> wrap(List<EntityV4.Key> completedKeyPbs) {
                Iterator entityPbBldrIt = incompleteEntityBldrs.iterator();
                Iterator incompleteKeysIt = incompleteKeys.iterator();
                for (EntityV4.Key v4Key : completedKeyPbs) {
                    AsyncDatastoreV4ServiceImpl.updateKey(v4Key, (Key)incompleteKeysIt.next());
                    v4txn.deferPut(((EntityV4.Entity.Builder)entityPbBldrIt.next()).setKey(v4Key).build());
                }
                return this.val$allKeys;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        });
    }

    @Override
    protected Future<Void> doBatchDelete(Transaction txn, Collection<Key> keys) {
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            InternalTransactionV4 v4txn = InternalTransactionV4.getById(txn.getId());
            for (Key key : keys) {
                v4txn.deferDelete(key);
            }
            return new FutureHelper.FakeFuture<Object>(null);
        }
        DatastoreV4.CommitRequest.Builder baseReq = DatastoreV4.CommitRequest.newBuilder();
        baseReq.setMode(DatastoreV4.CommitRequest.Mode.NON_TRANSACTIONAL);
        Iterator<DatastoreV4.CommitRequest.Builder> batches = this.deleteBatcher.getBatches(keys, baseReq, baseReq.build().getSerializedSize(), true);
        List futures = this.deleteBatcher.makeCalls(batches);
        return new FutureHelper.MultiFuture<DatastoreV4.CommitResponse, Void>(futures){

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                for (Future future : this.futures) {
                    future.get();
                }
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                for (Future future : this.futures) {
                    future.get(timeout, unit);
                }
                return null;
            }
        };
    }

    @Override
    public Future<KeyRange> allocateIds(Key parent, String kind, long num) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<DatastoreService.KeyRangeState> allocateIdRange(KeyRange range) {
        throw new UnsupportedOperationException();
    }

    protected Future<List<EntityV4.Key>> allocateIds(List<Key> keyList) {
        ArrayList<Integer> order = Lists.newArrayListWithCapacity(keyList.size());
        Iterator<DatastoreV4.AllocateIdsRequest.Builder> batches = this.allocateIdsBatcher.getBatches(keyList, DatastoreV4.AllocateIdsRequest.newBuilder(), 0, true, order);
        List futures = this.allocateIdsBatcher.makeCalls(batches);
        return new Batcher.ReorderingMultiFuture<DatastoreV4.AllocateIdsResponse, List<EntityV4.Key>>(futures, order){

            @Override
            protected List<EntityV4.Key> aggregate(DatastoreV4.AllocateIdsResponse batch, Iterator<Integer> indexItr, List<EntityV4.Key> result) {
                for (EntityV4.Key key : batch.getAllocatedList()) {
                    result.set(indexItr.next(), key);
                }
                return result;
            }

            @Override
            protected List<EntityV4.Key> initResult(int size) {
                return Arrays.asList(new EntityV4.Key[size]);
            }
        };
    }

    @Override
    public Future<Map<Index, Index.IndexState>> getIndexes() {
        throw new UnsupportedOperationException();
    }

    static void updateKey(EntityV4.Key v4Key, Key key) {
        EntityV4.Key.PathElement lastElement;
        List<EntityV4.Key.PathElement> pathElements = v4Key.getPathElementList();
        if (!pathElements.isEmpty() && (lastElement = pathElements.get(pathElements.size() - 1)).hasId()) {
            key.setId(lastElement.getId());
        }
    }

    private abstract class V4Batcher<S extends Message, R extends Message.Builder, F, T extends Message>
    extends BaseAsyncDatastoreServiceImpl.BaseRpcBatcher<S, R, F, T> {
        private V4Batcher() {
            super(AsyncDatastoreV4ServiceImpl.this);
        }

        @Override
        final R newBatch(R baseBatch) {
            return (R)baseBatch.clone();
        }
    }
}

