/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.DatastoreCallbacksImpl;
import com.google.appengine.api.datastore.EntityCacheConfig;
import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class DatastoreServiceConfig {
    static final int DEFAULT_RPC_SIZE_LIMIT_BYTES = 0x100000;
    static final int DEFAULT_MAX_BATCH_GET_KEYS = 1000;
    static final int DEFAULT_MAX_BATCH_WRITE_ENTITIES = 500;
    static final int DEFAULT_ALLOCATEID_BATCH_KEYS = 500;
    static final String DEFAULT_MAX_ENTITY_GROUPS_PER_RPC_SYS_PROP = "appengine.datastore.defaultMaxEntityGroupsPerRpc";
    static final int DEFAULT_MAX_ENTITY_GROUPS_PER_RPC = DatastoreServiceConfig.getDefaultMaxEntityGroupsPerRpc();
    static final String CALLBACKS_CONFIG_SYS_PROP = "appengine.datastore.callbacksConfig";
    static volatile DatastoreCallbacks CALLBACKS = null;
    private static final String CALLBACKS_CONFIG_FILE = "/META-INF/datastorecallbacks.xml";
    static final String DATASTORE_SERVICE_VERSION_SYS_PROP = "appengine.datastore.v4service";
    static final String FORCE_V4_SYS_PROP_VAL = "force";
    private final DatastoreCallbacks instanceDatastoreCallbacks;
    private ImplicitTransactionManagementPolicy implicitTransactionManagementPolicy = ImplicitTransactionManagementPolicy.NONE;
    private ReadPolicy readPolicy = new ReadPolicy(ReadPolicy.Consistency.STRONG);
    private Double deadline;
    private AppIdNamespace appIdNamespace;
    int maxRpcSizeBytes = 0x100000;
    int maxBatchWriteEntities = 500;
    int maxBatchReadEntities = 1000;
    int maxBatchAllocateIdKeys = 500;
    int maxEntityGroupsPerRpc = DEFAULT_MAX_ENTITY_GROUPS_PER_RPC;
    private EntityCacheConfig entityCacheConfig = null;
    private ApiVersion apiVersion = null;

    static int getDefaultMaxEntityGroupsPerRpc() {
        return DatastoreServiceConfig.getDefaultMaxEntityGroupsPerRpc(DEFAULT_MAX_ENTITY_GROUPS_PER_RPC_SYS_PROP, 10);
    }

    static int getDefaultMaxEntityGroupsPerRpc(String sysPropName, int defaultVal) {
        String sysPropVal = System.getProperty(sysPropName);
        return sysPropVal == null ? defaultVal : Integer.parseInt(sysPropVal);
    }

    private static InputStream getCallbacksConfigInputStream() {
        String callbacksConfig = System.getProperty(CALLBACKS_CONFIG_SYS_PROP);
        InputStream is = callbacksConfig != null ? new ByteArrayInputStream(callbacksConfig.getBytes()) : DatastoreServiceConfig.class.getResourceAsStream(CALLBACKS_CONFIG_FILE);
        return is;
    }

    private DatastoreServiceConfig(DatastoreCallbacks datastoreCallbacks) {
        this.instanceDatastoreCallbacks = datastoreCallbacks;
    }

    DatastoreServiceConfig(DatastoreServiceConfig config) {
        this.implicitTransactionManagementPolicy = config.implicitTransactionManagementPolicy;
        this.readPolicy = config.readPolicy;
        this.deadline = config.deadline;
        this.maxRpcSizeBytes = config.maxRpcSizeBytes;
        this.maxBatchWriteEntities = config.maxBatchWriteEntities;
        this.maxBatchReadEntities = config.maxBatchReadEntities;
        this.maxEntityGroupsPerRpc = config.maxEntityGroupsPerRpc;
        this.instanceDatastoreCallbacks = config.instanceDatastoreCallbacks;
        this.appIdNamespace = config.appIdNamespace;
        this.apiVersion = config.apiVersion;
    }

    public DatastoreServiceConfig implicitTransactionManagementPolicy(ImplicitTransactionManagementPolicy p) {
        if (p == null) {
            throw new NullPointerException("implicit transaction management policy must not be null");
        }
        this.implicitTransactionManagementPolicy = p;
        return this;
    }

    public DatastoreServiceConfig readPolicy(ReadPolicy readPolicy) {
        if (readPolicy == null) {
            throw new NullPointerException("read policy must not be null");
        }
        this.readPolicy = readPolicy;
        return this;
    }

    public DatastoreServiceConfig deadline(double deadline) {
        if (deadline <= 0.0) {
            throw new IllegalArgumentException("deadline must be > 0, got " + deadline);
        }
        this.deadline = deadline;
        return this;
    }

    DatastoreServiceConfig appIdNamespace(AppIdNamespace appIdNamespace) {
        this.appIdNamespace = appIdNamespace;
        return this;
    }

    DatastoreServiceConfig maxBatchWriteEntities(int maxBatchWriteEntities) {
        if (maxBatchWriteEntities <= 0) {
            throw new IllegalArgumentException("maxBatchWriteEntities must be > 0, got " + maxBatchWriteEntities);
        }
        this.maxBatchWriteEntities = maxBatchWriteEntities;
        return this;
    }

    DatastoreServiceConfig maxBatchReadEntities(int maxBatchReadEntities) {
        if (maxBatchReadEntities <= 0) {
            throw new IllegalArgumentException("maxBatchReadEntities must be > 0, got " + maxBatchReadEntities);
        }
        this.maxBatchReadEntities = maxBatchReadEntities;
        return this;
    }

    DatastoreServiceConfig maxRpcSizeBytes(int maxRpcSizeBytes) {
        if (maxRpcSizeBytes < 0) {
            throw new IllegalArgumentException("maxRpcSizeBytes must be >= 0, got " + maxRpcSizeBytes);
        }
        this.maxRpcSizeBytes = maxRpcSizeBytes;
        return this;
    }

    public DatastoreServiceConfig maxEntityGroupsPerRpc(int maxEntityGroupsPerRpc) {
        if (maxEntityGroupsPerRpc <= 0) {
            throw new IllegalArgumentException("maxEntityGroupsPerRpc must be > 0, got " + maxEntityGroupsPerRpc);
        }
        this.maxEntityGroupsPerRpc = maxEntityGroupsPerRpc;
        return this;
    }

    DatastoreServiceConfig entityCacheConfig(EntityCacheConfig entityCacheConfig) {
        Preconditions.checkNotNull(entityCacheConfig, "The entityCacheConfig argument can not be null");
        this.entityCacheConfig = entityCacheConfig;
        return this;
    }

    public ImplicitTransactionManagementPolicy getImplicitTransactionManagementPolicy() {
        return this.implicitTransactionManagementPolicy;
    }

    public ReadPolicy getReadPolicy() {
        return this.readPolicy;
    }

    public Integer getMaxEntityGroupsPerRpc() {
        return this.getMaxEntityGroupsPerRpcInternal();
    }

    int getMaxEntityGroupsPerRpcInternal() {
        return this.maxEntityGroupsPerRpc;
    }

    public Double getDeadline() {
        return this.deadline;
    }

    AppIdNamespace getAppIdNamespace() {
        return this.appIdNamespace == null ? DatastoreApiHelper.getCurrentAppIdNamespace() : this.appIdNamespace;
    }

    DatastoreCallbacks getDatastoreCallbacks() {
        if (this.instanceDatastoreCallbacks != null) {
            return this.instanceDatastoreCallbacks;
        }
        if (CALLBACKS == null) {
            InputStream is = DatastoreServiceConfig.getCallbacksConfigInputStream();
            CALLBACKS = is == null ? DatastoreCallbacks.NoOpDatastoreCallbacks.INSTANCE : new DatastoreCallbacksImpl(is, false);
        }
        return CALLBACKS;
    }

    EntityCacheConfig getEntityCacheConfig() {
        return this.entityCacheConfig;
    }

    ApiVersion getApiVersion() {
        if (this.apiVersion != null) {
            return this.apiVersion;
        }
        if (System.getProperty(DATASTORE_SERVICE_VERSION_SYS_PROP) == FORCE_V4_SYS_PROP_VAL) {
            return ApiVersion.V4;
        }
        return ApiVersion.V3;
    }

    DatastoreServiceConfig setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public static final class Builder {
        public static DatastoreServiceConfig withImplicitTransactionManagementPolicy(ImplicitTransactionManagementPolicy p) {
            return Builder.withDefaults().implicitTransactionManagementPolicy(p);
        }

        public static DatastoreServiceConfig withReadPolicy(ReadPolicy readPolicy) {
            return Builder.withDefaults().readPolicy(readPolicy);
        }

        public static DatastoreServiceConfig withDeadline(double deadline) {
            return Builder.withDefaults().deadline(deadline);
        }

        public static DatastoreServiceConfig withMaxEntityGroupsPerRpc(int maxEntityGroupsPerRpc) {
            return Builder.withDefaults().maxEntityGroupsPerRpc(maxEntityGroupsPerRpc);
        }

        static DatastoreServiceConfig withEntityCacheConfig(EntityCacheConfig entityCacheConfig) {
            return Builder.withDefaults().entityCacheConfig(entityCacheConfig);
        }

        static DatastoreServiceConfig withDatastoreCallbacks(DatastoreCallbacks datastoreCallbacks) {
            Preconditions.checkNotNull(datastoreCallbacks);
            return new DatastoreServiceConfig(datastoreCallbacks);
        }

        public static DatastoreServiceConfig withDefaults() {
            return new DatastoreServiceConfig(null);
        }

        private Builder() {
        }
    }

    static enum ApiVersion {
        V3,
        V4;

    }
}

