/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseQueryResultsSource;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

class QueryResultsSourceV4
extends BaseQueryResultsSource<DatastoreV4.RunQueryResponse, DatastoreV4.ContinueQueryRequest, DatastoreV4.ContinueQueryResponse> {
    private final ApiProxy.ApiConfig apiConfig;

    QueryResultsSourceV4(DatastoreCallbacks callbacks, FetchOptions fetchOptions, Transaction txn, Query query, Future<DatastoreV4.RunQueryResponse> runQueryResponse, ApiProxy.ApiConfig apiConfig) {
        super(callbacks, fetchOptions, txn, query, runQueryResponse);
        this.apiConfig = apiConfig;
    }

    @Override
    DatastoreV4.ContinueQueryRequest buildNextCallPrototype(DatastoreV4.RunQueryResponse initialResponse) {
        return DatastoreV4.ContinueQueryRequest.newBuilder().setQueryHandle(initialResponse.getQueryHandle()).build();
    }

    @Override
    Future<DatastoreV4.ContinueQueryResponse> makeNextCall(DatastoreV4.ContinueQueryRequest prototype, Integer fetchCountOrNull, Integer offsetOrNull) {
        return DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastoreV4.DatastoreV4Service.Method.ContinueQuery, prototype, DatastoreV4.ContinueQueryResponse.getDefaultInstance());
    }

    @Override
    BaseQueryResultsSource.WrappedQueryResult wrapInitialResult(DatastoreV4.RunQueryResponse initialResponse) {
        return new WrappedQueryResultV4(initialResponse.getBatch());
    }

    @Override
    BaseQueryResultsSource.WrappedQueryResult wrapResult(DatastoreV4.ContinueQueryResponse res) {
        return new WrappedQueryResultV4(res.getBatch());
    }

    private static class WrappedQueryResultV4
    implements BaseQueryResultsSource.WrappedQueryResult {
        private final DatastoreV4.QueryResultBatch batch;

        WrappedQueryResultV4(DatastoreV4.QueryResultBatch batch) {
            this.batch = batch;
        }

        @Override
        public Cursor getEndCursor() {
            if (this.batch.hasEndCursor()) {
                try {
                    return new Cursor(DatastorePb.CompiledCursor.PARSER.parseFrom(this.batch.getEndCursor()));
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Can't parse cursor", e);
                }
            }
            return null;
        }

        @Override
        public List<Entity> getEntities(Collection<Projection> projections) {
            ArrayList<Entity> entityList = Lists.newArrayListWithCapacity(this.batch.getEntityResultCount());
            if (projections.isEmpty()) {
                for (DatastoreV4.EntityResult entityResult : this.batch.getEntityResultList()) {
                    entityList.add(DataTypeTranslator.toEntity(entityResult.getEntity()));
                }
            } else {
                for (DatastoreV4.EntityResult entityResult : this.batch.getEntityResultList()) {
                    entityList.add(DataTypeTranslator.toEntity(entityResult.getEntity(), projections));
                }
            }
            return entityList;
        }

        @Override
        public List<Cursor> getResultCursors() {
            return Collections.nCopies(this.batch.getEntityResultCount(), null);
        }

        @Override
        public Cursor getSkippedResultsCursor() {
            return null;
        }

        @Override
        public boolean hasMoreResults() {
            return this.batch.getMoreResults() == DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED;
        }

        @Override
        public int numSkippedResults() {
            return this.batch.getSkippedResults();
        }

        @Override
        public List<Index> getIndexInfo(Collection<Index> monitoredIndexBuffer) {
            return ImmutableList.of();
        }
    }
}

