/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionHelper;
import com.google.appengine.api.taskqueue.FutureAdapter;
import com.google.appengine.api.taskqueue.InternalFailureException;
import com.google.appengine.api.taskqueue.LeaseOptions;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueApiHelper;
import com.google.appengine.api.taskqueue.QueueConstants;
import com.google.appengine.api.taskqueue.QueueNameMismatchException;
import com.google.appengine.api.taskqueue.QueueStatistics;
import com.google.appengine.api.taskqueue.RetryOptions;
import com.google.appengine.api.taskqueue.TaskAlreadyExistsException;
import com.google.appengine.api.taskqueue.TaskHandle;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.UnsupportedTranslationException;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class QueueImpl
implements Queue {
    private final String queueName;
    private final DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();
    private final QueueApiHelper apiHelper;
    static final String DEFAULT_NAMESPACE_HEADER = "X-AppEngine-Default-Namespace";
    static final String CURRENT_NAMESPACE_HEADER = "X-AppEngine-Current-Namespace";
    static final double DEFAULT_LEASE_TASKS_DEADLINE_SECONDS = 10.0;
    static final double DEFAULT_FETCH_STATISTICS_DEADLINE_SECONDS = 10.0;

    QueueImpl(String queueName, QueueApiHelper apiHelper) {
        QueueApiHelper.validateQueueName(queueName);
        this.apiHelper = apiHelper;
        this.queueName = queueName;
    }

    private <T> Future<T> extractSingleEntry(Future<List<T>> future) {
        return new FutureAdapter<List<T>, T>(future){

            @Override
            protected T wrap(List<T> key) throws Exception {
                if (key.size() != 1) {
                    String string = QueueImpl.this.queueName;
                    throw new InternalFailureException(new StringBuilder(51 + String.valueOf(string).length()).append("An internal error occurred while accessing queue '").append(string).append("'").toString());
                }
                return key.get(0);
            }
        };
    }

    @Override
    public TaskHandle add() {
        return QueueApiHelper.getInternal(this.addAsync());
    }

    @Override
    public Future<TaskHandle> addAsync() {
        return this.addAsync(this.getDatastoreService().getCurrentTransaction(null), TaskOptions.Builder.withDefaults());
    }

    private URI parsePartialUrl(String urlString) {
        URI uri;
        if (urlString == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        if (urlString.length() > QueueConstants.maxUrlLength()) {
            int n = QueueConstants.maxUrlLength();
            throw new IllegalArgumentException(new StringBuilder(31).append("url is longer than ").append(n).append(".").toString());
        }
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException exception) {
            throw new IllegalArgumentException("URL syntax error", exception);
        }
        this.uriCheckNull(uri.getScheme(), "scheme");
        this.uriCheckNull(uri.getRawAuthority(), "authority");
        this.uriCheckNull(uri.getRawFragment(), "fragment");
        String path = uri.getPath();
        if (path == null || path.length() == 0 || path.charAt(0) != '/') {
            if (path == null) {
                path = "(null)";
            } else if (path.length() == 0) {
                path = "<empty string>";
            }
            String string = String.valueOf(path);
            throw new IllegalArgumentException(string.length() != 0 ? "url must contain a path starting with '/' part - contains :".concat(string) : new String("url must contain a path starting with '/' part - contains :"));
        }
        return uri;
    }

    private void uriCheckNull(String value, String valueName) {
        if (value != null) {
            throw new IllegalArgumentException(new StringBuilder(43 + String.valueOf(valueName).length() + String.valueOf(value).length()).append("url must not contain a '").append(valueName).append("' part - contains :").append(value).toString());
        }
    }

    private void checkPullTask(String url, LinkedHashMap<String, List<String>> headers, byte[] payload, RetryOptions retryOptions) {
        if (url != null && !url.isEmpty()) {
            throw new IllegalArgumentException("May not specify url in tasks that have method PULL");
        }
        if (!headers.isEmpty()) {
            throw new IllegalArgumentException("May not specify any header in tasks that have method PULL");
        }
        if (retryOptions != null) {
            throw new IllegalArgumentException("May not specify retry options in tasks that have method PULL");
        }
        if (payload == null) {
            throw new IllegalArgumentException("payload must be specified for tasks with method PULL");
        }
    }

    private void checkPostTask(List<TaskOptions.Param> params, byte[] payload, String query) {
        if (query != null && query.length() != 0) {
            throw new IllegalArgumentException("POST method may not have a query string; use param() instead");
        }
    }

    private byte[] constructPayloadFromParams(List<TaskOptions.Param> params, byte[] payload) {
        if (!params.isEmpty() && payload != null) {
            throw new IllegalArgumentException("Message body and parameters may not both be present; only one of these may be supplied");
        }
        return payload != null ? null : this.encodeParamsPost(params);
    }

    private void validateAndFillAddRequest(Transaction txn, TaskOptions taskOptions, TaskQueuePb.TaskQueueAddRequest addRequest) {
        boolean useUrlEncodedContentType = false;
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>(taskOptions.getHeaders());
        String url = taskOptions.getUrl();
        byte[] payload = taskOptions.getPayload();
        List<TaskOptions.Param> params = taskOptions.getParams();
        RetryOptions retryOptions = taskOptions.getRetryOptions();
        TaskOptions.Method method = taskOptions.getMethod();
        URI parsedUrl = url == null ? this.parsePartialUrl(this.defaultUrl()) : this.parsePartialUrl(url);
        String query = parsedUrl.getQuery();
        StringBuilder relativeUrl = new StringBuilder(parsedUrl.getRawPath());
        if (query != null && query.length() != 0 && !params.isEmpty()) {
            throw new IllegalArgumentException("Query string and parameters both present; only one of these may be supplied");
        }
        if (method == TaskOptions.Method.PULL) {
            byte[] constructedPayload = this.constructPayloadFromParams(params, payload);
            if (constructedPayload != null) {
                payload = constructedPayload;
            }
            this.checkPullTask(url, headers, payload, retryOptions);
        } else if (method == TaskOptions.Method.POST) {
            byte[] constructedPayload = this.constructPayloadFromParams(params, payload);
            if (constructedPayload != null) {
                payload = constructedPayload;
                useUrlEncodedContentType = true;
            }
            this.checkPostTask(params, payload, query);
        } else {
            if (!params.isEmpty()) {
                query = this.encodeParamsUrlEncoded(params);
            }
            if (query != null && query.length() != 0) {
                relativeUrl.append("?").append(query);
            }
        }
        if (payload != null && payload.length != 0 && !taskOptions.getMethod().supportsBody()) {
            String string = String.valueOf((Object)taskOptions.getMethod());
            throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(string).length()).append(string).append(" method may not specify a payload.").toString());
        }
        this.fillAddRequest(txn, this.queueName, taskOptions.getTaskName(), this.determineEta(taskOptions), method, relativeUrl.toString(), payload, headers, retryOptions, useUrlEncodedContentType, taskOptions.getTagAsBytes(), addRequest);
    }

    private void fillAddRequest(Transaction txn, String queueName, String taskName, long etaMillis, TaskOptions.Method method, String relativeUrl, byte[] payload, LinkedHashMap<String, List<String>> headers, RetryOptions retryOptions, boolean useUrlEncodedContentType, byte[] tag, TaskQueuePb.TaskQueueAddRequest addRequest) {
        addRequest.setQueueName(queueName);
        addRequest.setTaskName(taskName == null ? "" : taskName);
        if (method == TaskOptions.Method.PULL) {
            addRequest.setMode(TaskQueuePb.TaskQueueMode.Mode.PULL.getValue());
        } else {
            addRequest.setUrl(relativeUrl.toString());
            addRequest.setMode(TaskQueuePb.TaskQueueMode.Mode.PUSH.getValue());
            addRequest.setMethod(method.getPbMethod());
        }
        if (payload != null) {
            addRequest.setBodyAsBytes(payload);
        }
        addRequest.setEtaUsec(etaMillis * 1000L);
        if (taskName != null && !taskName.isEmpty() && txn != null) {
            String string = String.valueOf(taskName);
            throw new IllegalArgumentException(string.length() != 0 ? "transactional tasks cannot be named: ".concat(string) : new String("transactional tasks cannot be named: "));
        }
        if (txn != null) {
            TransactionHelper.setTransaction(txn, addRequest);
        }
        if (retryOptions != null) {
            QueueImpl.fillRetryParameters(retryOptions, addRequest.getMutableRetryParameters());
        }
        if (NamespaceManager.getGoogleAppsNamespace().length() != 0 && !headers.containsKey(DEFAULT_NAMESPACE_HEADER)) {
            headers.put(DEFAULT_NAMESPACE_HEADER, Arrays.asList(NamespaceManager.getGoogleAppsNamespace()));
        }
        if (!headers.containsKey(CURRENT_NAMESPACE_HEADER)) {
            String namespace = NamespaceManager.get();
            headers.put(CURRENT_NAMESPACE_HEADER, Arrays.asList(namespace == null ? "" : namespace));
        }
        for (Map.Entry entry : headers.entrySet()) {
            if (useUrlEncodedContentType && ((String)entry.getKey()).toLowerCase().equals("content-type")) continue;
            for (String value : (List)entry.getValue()) {
                TaskQueuePb.TaskQueueAddRequest.Header header = addRequest.addHeader();
                header.setKey((String)entry.getKey());
                header.setValue(value);
            }
        }
        if (useUrlEncodedContentType) {
            TaskQueuePb.TaskQueueAddRequest.Header contentTypeHeader = addRequest.addHeader();
            contentTypeHeader.setKey("content-type");
            contentTypeHeader.setValue("application/x-www-form-urlencoded");
        }
        if (tag != null) {
            if (method != TaskOptions.Method.PULL) {
                throw new IllegalArgumentException("Only PULL tasks can have a tag.");
            }
            if (tag.length > QueueConstants.maxTaskTagLength()) {
                int n = QueueConstants.maxTaskTagLength();
                throw new IllegalArgumentException(new StringBuilder(48).append("Task tag must be no more than ").append(n).append(" bytes.").toString());
            }
            addRequest.setTagAsBytes(tag);
        }
        if (method == TaskOptions.Method.PULL ? addRequest.encodingSize() > QueueConstants.maxPullTaskSizeBytes() : addRequest.encodingSize() > QueueConstants.maxPushTaskSizeBytes()) {
            throw new IllegalArgumentException("Task size too large");
        }
    }

    private static void fillRetryParameters(RetryOptions retryOptions, TaskQueuePb.TaskQueueRetryParameters retryParameters) {
        if (retryOptions.getTaskRetryLimit() != null) {
            retryParameters.setRetryLimit(retryOptions.getTaskRetryLimit());
        }
        if (retryOptions.getTaskAgeLimitSeconds() != null) {
            retryParameters.setAgeLimitSec(retryOptions.getTaskAgeLimitSeconds());
        }
        if (retryOptions.getMinBackoffSeconds() != null) {
            retryParameters.setMinBackoffSec(retryOptions.getMinBackoffSeconds());
        }
        if (retryOptions.getMaxBackoffSeconds() != null) {
            retryParameters.setMaxBackoffSec(retryOptions.getMaxBackoffSeconds());
        }
        if (retryOptions.getMaxDoublings() != null) {
            retryParameters.setMaxDoublings(retryOptions.getMaxDoublings());
        }
        if (retryParameters.hasMinBackoffSec() && retryParameters.hasMaxBackoffSec()) {
            if (retryParameters.getMinBackoffSec() > retryParameters.getMaxBackoffSec()) {
                throw new IllegalArgumentException("minBackoffSeconds must not be greater than maxBackoffSeconds.");
            }
        } else if (retryParameters.hasMinBackoffSec()) {
            if (retryParameters.getMinBackoffSec() > retryParameters.getMaxBackoffSec()) {
                retryParameters.setMaxBackoffSec(retryParameters.getMinBackoffSec());
            }
        } else if (retryParameters.hasMaxBackoffSec() && retryParameters.getMinBackoffSec() > retryParameters.getMaxBackoffSec()) {
            retryParameters.setMinBackoffSec(retryParameters.getMaxBackoffSec());
        }
    }

    @Override
    public TaskHandle add(TaskOptions taskOptions) {
        return QueueApiHelper.getInternal(this.addAsync(taskOptions));
    }

    @Override
    public Future<TaskHandle> addAsync(TaskOptions taskOptions) {
        return this.addAsync(this.getDatastoreService().getCurrentTransaction(null), taskOptions);
    }

    @Override
    public List<TaskHandle> add(Iterable<TaskOptions> taskOptions) {
        return QueueApiHelper.getInternal(this.addAsync(taskOptions));
    }

    @Override
    public Future<List<TaskHandle>> addAsync(Iterable<TaskOptions> taskOptions) {
        return this.addAsync(this.getDatastoreService().getCurrentTransaction(null), taskOptions);
    }

    @Override
    public TaskHandle add(Transaction txn, TaskOptions taskOptions) {
        return QueueApiHelper.getInternal(this.addAsync(txn, taskOptions));
    }

    @Override
    public Future<TaskHandle> addAsync(Transaction txn, TaskOptions taskOptions) {
        return this.extractSingleEntry(this.addAsync(txn, Collections.singletonList(taskOptions)));
    }

    @Override
    public List<TaskHandle> add(Transaction txn, Iterable<TaskOptions> taskOptions) {
        return QueueApiHelper.getInternal(this.addAsync(txn, taskOptions));
    }

    @Override
    public Future<List<TaskHandle>> addAsync(Transaction txn, Iterable<TaskOptions> taskOptions) {
        final ArrayList<TaskOptions> taskOptionsList = new ArrayList<TaskOptions>();
        HashSet<String> taskNames = new HashSet<String>();
        final TaskQueuePb.TaskQueueBulkAddRequest bulkAddRequest = new TaskQueuePb.TaskQueueBulkAddRequest();
        boolean hasPushTask = false;
        boolean hasPullTask = false;
        for (TaskOptions option : taskOptions) {
            TaskQueuePb.TaskQueueAddRequest addRequest = bulkAddRequest.addAddRequest();
            this.validateAndFillAddRequest(txn, option, addRequest);
            if (addRequest.getMode() == TaskQueuePb.TaskQueueMode.Mode.PULL.getValue()) {
                hasPullTask = true;
            } else {
                hasPushTask = true;
            }
            taskOptionsList.add(option);
            if (option.getTaskName() == null || option.getTaskName().isEmpty() || taskNames.add(option.getTaskName())) continue;
            throw new IllegalArgumentException(String.format("Identical task names in request : \"%s\" duplicated", option.getTaskName()));
        }
        if (bulkAddRequest.addRequestSize() > QueueConstants.maxTasksPerAdd()) {
            throw new IllegalArgumentException(String.format("No more than %d tasks can be added in a single add call", QueueConstants.maxTasksPerAdd()));
        }
        if (hasPullTask && hasPushTask) {
            throw new IllegalArgumentException("May not add both push tasks and pull tasks in the same call.");
        }
        if (txn != null && bulkAddRequest.encodingSize() > QueueConstants.maxTransactionalRequestSizeBytes()) {
            throw new IllegalArgumentException(String.format("Transactional add may not be larger than %d bytes: %d bytes requested.", QueueConstants.maxTransactionalRequestSizeBytes(), bulkAddRequest.encodingSize()));
        }
        Future<TaskQueuePb.TaskQueueBulkAddResponse> responseFuture = this.makeAsyncCall("BulkAdd", bulkAddRequest, new TaskQueuePb.TaskQueueBulkAddResponse());
        return new FutureAdapter<TaskQueuePb.TaskQueueBulkAddResponse, List<TaskHandle>>(responseFuture){

            @Override
            protected List<TaskHandle> wrap(TaskQueuePb.TaskQueueBulkAddResponse bulkAddResponse) {
                if (bulkAddResponse.taskResultSize() != bulkAddRequest.addRequestSize()) {
                    throw new InternalFailureException(String.format("expected %d results from BulkAdd(), got %d", bulkAddRequest.addRequestSize(), bulkAddResponse.taskResultSize()));
                }
                ArrayList<TaskHandle> tasks = new ArrayList<TaskHandle>();
                RuntimeException taskqueueException = null;
                for (int i = 0; i < bulkAddResponse.taskResultSize(); ++i) {
                    int result;
                    TaskQueuePb.TaskQueueBulkAddResponse.TaskResult taskResult = bulkAddResponse.taskResults().get(i);
                    TaskQueuePb.TaskQueueAddRequest addRequest = bulkAddRequest.getAddRequest(i);
                    TaskOptions options = (TaskOptions)taskOptionsList.get(i);
                    if (taskResult.getResult() == TaskQueuePb.TaskQueueServiceError.ErrorCode.OK.getValue()) {
                        String taskName = options.getTaskName();
                        if (taskResult.hasChosenTaskName()) {
                            taskName = taskResult.getChosenTaskName();
                        }
                        TaskOptions taskResultOptions = new TaskOptions(options);
                        taskResultOptions.taskName(taskName).payload(addRequest.getBodyAsBytes());
                        TaskHandle handle = new TaskHandle(taskResultOptions, QueueImpl.this.queueName);
                        tasks.add(handle.etaUsec(addRequest.getEtaUsec()));
                        continue;
                    }
                    if (taskResult.getResult() == TaskQueuePb.TaskQueueServiceError.ErrorCode.SKIPPED.getValue() || taskqueueException != null && !(taskqueueException instanceof TaskAlreadyExistsException)) continue;
                    String detail = (result = taskResult.getResult()) == TaskQueuePb.TaskQueueServiceError.ErrorCode.UNKNOWN_QUEUE.getValue() ? QueueImpl.this.queueName : options.getTaskName();
                    RuntimeException e = QueueApiHelper.translateError(result, detail);
                    if (e instanceof TaskAlreadyExistsException) {
                        if (taskqueueException == null) {
                            taskqueueException = e;
                        }
                        TaskAlreadyExistsException taee = (TaskAlreadyExistsException)taskqueueException;
                        taee.appendTaskName(options.getTaskName());
                        continue;
                    }
                    taskqueueException = e;
                }
                if (taskqueueException != null) {
                    throw taskqueueException;
                }
                return tasks;
            }
        };
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    private long determineEta(TaskOptions taskOptions) {
        Long etaMillis = taskOptions.getEtaMillis();
        Long countdownMillis = taskOptions.getCountdownMillis();
        if (etaMillis == null) {
            if (countdownMillis == null) {
                return this.currentTimeMillis();
            }
            if (countdownMillis > QueueConstants.getMaxEtaDeltaMillis()) {
                throw new IllegalArgumentException("ETA too far into the future");
            }
            if (countdownMillis < 0L) {
                throw new IllegalArgumentException("Negative countdown is not allowed");
            }
            return this.currentTimeMillis() + countdownMillis;
        }
        if (countdownMillis == null) {
            if (etaMillis - this.currentTimeMillis() > QueueConstants.getMaxEtaDeltaMillis()) {
                throw new IllegalArgumentException("ETA too far into the future");
            }
            if (etaMillis < 0L) {
                throw new IllegalArgumentException("Negative ETA is invalid");
            }
            return etaMillis;
        }
        throw new IllegalArgumentException("Only one or neither of EtaMillis and CountdownMillis may be specified");
    }

    byte[] encodeParamsPost(List<TaskOptions.Param> params) {
        byte[] payload;
        try {
            payload = this.encodeParamsUrlEncoded(params).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new UnsupportedTranslationException(exception);
        }
        return payload;
    }

    String encodeParamsUrlEncoded(List<TaskOptions.Param> params) {
        StringBuilder result = new StringBuilder();
        try {
            String appender = "";
            for (TaskOptions.Param param : params) {
                result.append(appender);
                appender = "&";
                result.append(param.getURLEncodedName());
                result.append("=");
                result.append(param.getURLEncodedValue());
            }
        }
        catch (UnsupportedEncodingException exception) {
            throw new UnsupportedTranslationException(exception);
        }
        return result.toString();
    }

    private String defaultUrl() {
        String string = String.valueOf("/_ah/queue/");
        String string2 = String.valueOf(this.queueName);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    DatastoreService getDatastoreService() {
        return this.datastoreService;
    }

    @Override
    public void purge() {
        TaskQueuePb.TaskQueuePurgeQueueRequest purgeRequest = new TaskQueuePb.TaskQueuePurgeQueueRequest();
        TaskQueuePb.TaskQueuePurgeQueueResponse purgeResponse = new TaskQueuePb.TaskQueuePurgeQueueResponse();
        purgeRequest.setQueueName(this.queueName);
        this.apiHelper.makeSyncCall("PurgeQueue", purgeRequest, purgeResponse);
    }

    @Override
    public boolean deleteTask(String taskName) {
        return QueueApiHelper.getInternal(this.deleteTaskAsync(taskName));
    }

    @Override
    public Future<Boolean> deleteTaskAsync(String taskName) {
        TaskHandle.validateTaskName(taskName);
        return this.deleteTaskAsync(new TaskHandle(TaskOptions.Builder.withTaskName(taskName), this.queueName));
    }

    @Override
    public boolean deleteTask(TaskHandle taskHandle) {
        return QueueApiHelper.getInternal(this.deleteTaskAsync(taskHandle));
    }

    @Override
    public Future<Boolean> deleteTaskAsync(TaskHandle taskHandle) {
        return this.extractSingleEntry(this.deleteTaskAsync(Collections.singletonList(taskHandle)));
    }

    @Override
    public List<Boolean> deleteTask(List<TaskHandle> taskHandles) {
        return QueueApiHelper.getInternal(this.deleteTaskAsync(taskHandles));
    }

    @Override
    public Future<List<Boolean>> deleteTaskAsync(List<TaskHandle> taskHandles) {
        final TaskQueuePb.TaskQueueDeleteRequest deleteRequest = new TaskQueuePb.TaskQueueDeleteRequest();
        deleteRequest.setQueueName(this.queueName);
        for (TaskHandle taskHandle : taskHandles) {
            if (taskHandle.getQueueName().equals(this.queueName)) {
                deleteRequest.addTaskName(taskHandle.getName());
                continue;
            }
            throw new QueueNameMismatchException(String.format("The task %s is associated with the queue named %s and cannot be deleted from the queue named %s.", taskHandle.getName(), taskHandle.getQueueName(), this.queueName));
        }
        Future<TaskQueuePb.TaskQueueDeleteResponse> responseFuture = this.makeAsyncCall("Delete", deleteRequest, new TaskQueuePb.TaskQueueDeleteResponse());
        return new FutureAdapter<TaskQueuePb.TaskQueueDeleteResponse, List<Boolean>>(this, responseFuture){

            @Override
            protected List<Boolean> wrap(TaskQueuePb.TaskQueueDeleteResponse deleteResponse) {
                ArrayList<Boolean> result = new ArrayList<Boolean>(deleteResponse.resultSize());
                for (int i = 0; i < deleteResponse.resultSize(); ++i) {
                    int errorCode = deleteResponse.getResult(i);
                    if (errorCode != TaskQueuePb.TaskQueueServiceError.ErrorCode.OK.getValue() && errorCode != TaskQueuePb.TaskQueueServiceError.ErrorCode.TOMBSTONED_TASK.getValue() && errorCode != TaskQueuePb.TaskQueueServiceError.ErrorCode.UNKNOWN_TASK.getValue()) {
                        throw QueueApiHelper.translateError(errorCode, deleteRequest.getTaskName(i));
                    }
                    result.add(errorCode == TaskQueuePb.TaskQueueServiceError.ErrorCode.OK.getValue());
                }
                return result;
            }
        };
    }

    private Future<List<TaskHandle>> leaseTasksInternal(LeaseOptions options) {
        long leaseMillis = options.getUnit().toMillis(options.getLease());
        if (leaseMillis > QueueConstants.maxLease(TimeUnit.MILLISECONDS)) {
            throw new IllegalArgumentException(String.format("A lease period can be no longer than %d seconds", QueueConstants.maxLease(TimeUnit.SECONDS)));
        }
        if (options.getCountLimit() > QueueConstants.maxLeaseCount()) {
            throw new IllegalArgumentException(String.format("No more than %d tasks can be leased in one call", QueueConstants.maxLeaseCount()));
        }
        TaskQueuePb.TaskQueueQueryAndOwnTasksRequest leaseRequest = new TaskQueuePb.TaskQueueQueryAndOwnTasksRequest();
        leaseRequest.setQueueName(this.queueName);
        leaseRequest.setLeaseSeconds((double)leaseMillis / 1000.0);
        leaseRequest.setMaxTasks(options.getCountLimit());
        if (options.getGroupByTag()) {
            leaseRequest.setGroupByTag(true);
            if (options.getTag() != null) {
                leaseRequest.setTagAsBytes(options.getTag());
            }
        }
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        if (options.getDeadlineInSeconds() == null) {
            apiConfig.setDeadlineInSeconds(10.0);
        } else {
            apiConfig.setDeadlineInSeconds(options.getDeadlineInSeconds());
        }
        Future<TaskQueuePb.TaskQueueQueryAndOwnTasksResponse> responseFuture = this.apiHelper.makeAsyncCall("QueryAndOwnTasks", leaseRequest, new TaskQueuePb.TaskQueueQueryAndOwnTasksResponse(), apiConfig);
        return new FutureAdapter<TaskQueuePb.TaskQueueQueryAndOwnTasksResponse, List<TaskHandle>>(responseFuture){

            @Override
            protected List<TaskHandle> wrap(TaskQueuePb.TaskQueueQueryAndOwnTasksResponse leaseResponse) {
                ArrayList<TaskHandle> result = new ArrayList<TaskHandle>();
                for (TaskQueuePb.TaskQueueQueryAndOwnTasksResponse.Task response : leaseResponse.tasks()) {
                    TaskOptions taskOptions = TaskOptions.Builder.withTaskName(response.getTaskName()).payload(response.getBodyAsBytes()).method(TaskOptions.Method.PULL);
                    if (response.hasTag()) {
                        taskOptions.tag(response.getTagAsBytes());
                    }
                    TaskHandle handle = new TaskHandle(taskOptions, QueueImpl.this.queueName, (Integer)response.getRetryCount());
                    result.add(handle.etaUsec(response.getEtaUsec()));
                }
                return result;
            }
        };
    }

    @Override
    public List<TaskHandle> leaseTasks(long lease, TimeUnit unit, long countLimit) {
        return QueueApiHelper.getInternal(this.leaseTasksAsync(lease, unit, countLimit));
    }

    @Override
    public Future<List<TaskHandle>> leaseTasksAsync(long lease, TimeUnit unit, long countLimit) {
        return this.leaseTasksInternal(LeaseOptions.Builder.withLeasePeriod(lease, unit).countLimit(countLimit));
    }

    @Override
    public List<TaskHandle> leaseTasksByTagBytes(long lease, TimeUnit unit, long countLimit, byte[] tag) {
        return QueueApiHelper.getInternal(this.leaseTasksByTagBytesAsync(lease, unit, countLimit, tag));
    }

    @Override
    public Future<List<TaskHandle>> leaseTasksByTagBytesAsync(long lease, TimeUnit unit, long countLimit, byte[] tag) {
        LeaseOptions options = LeaseOptions.Builder.withLeasePeriod(lease, unit).countLimit(countLimit);
        if (tag != null) {
            options.tag(tag);
        } else {
            options.groupByTag();
        }
        return this.leaseTasksInternal(options);
    }

    @Override
    public List<TaskHandle> leaseTasksByTag(long lease, TimeUnit unit, long countLimit, String tag) {
        return QueueApiHelper.getInternal(this.leaseTasksByTagAsync(lease, unit, countLimit, tag));
    }

    @Override
    public Future<List<TaskHandle>> leaseTasksByTagAsync(long lease, TimeUnit unit, long countLimit, String tag) {
        LeaseOptions options = LeaseOptions.Builder.withLeasePeriod(lease, unit).countLimit(countLimit);
        if (tag != null) {
            options.tag(tag);
        } else {
            options.groupByTag();
        }
        return this.leaseTasksInternal(options);
    }

    @Override
    public List<TaskHandle> leaseTasks(LeaseOptions options) {
        return QueueApiHelper.getInternal(this.leaseTasksAsync(options));
    }

    @Override
    public Future<List<TaskHandle>> leaseTasksAsync(LeaseOptions options) {
        if (options.getLease() == null) {
            throw new IllegalArgumentException("The lease period must be specified");
        }
        if (options.getCountLimit() == null) {
            throw new IllegalArgumentException("The count limit must be specified");
        }
        return this.leaseTasksInternal(options);
    }

    @Override
    public TaskHandle modifyTaskLease(TaskHandle taskHandle, long lease, TimeUnit unit) {
        long leaseMillis = unit.toMillis(lease);
        if (leaseMillis > QueueConstants.maxLease(TimeUnit.MILLISECONDS)) {
            throw new IllegalArgumentException(String.format("The lease time specified (%s seconds) is too large. Lease period can be no longer than %d seconds.", this.formatLeaseTimeInSeconds(leaseMillis), QueueConstants.maxLease(TimeUnit.SECONDS)));
        }
        if (leaseMillis < 0L) {
            throw new IllegalArgumentException(String.format("The lease time must not be negative. Specified lease time was %s seconds.", this.formatLeaseTimeInSeconds(leaseMillis)));
        }
        TaskQueuePb.TaskQueueModifyTaskLeaseRequest request = new TaskQueuePb.TaskQueueModifyTaskLeaseRequest();
        TaskQueuePb.TaskQueueModifyTaskLeaseResponse response = new TaskQueuePb.TaskQueueModifyTaskLeaseResponse();
        request.setQueueName(this.queueName);
        request.setTaskName(taskHandle.getName());
        request.setLeaseSeconds((double)leaseMillis / 1000.0);
        request.setEtaUsec(taskHandle.getEtaUsec());
        this.apiHelper.makeSyncCall("ModifyTaskLease", request, response);
        taskHandle.etaUsec(response.getUpdatedEtaUsec());
        return taskHandle;
    }

    private String formatLeaseTimeInSeconds(long milliSeconds) {
        long seconds = TimeUnit.SECONDS.convert(milliSeconds, TimeUnit.MILLISECONDS);
        long remainder = milliSeconds - TimeUnit.MILLISECONDS.convert(seconds, TimeUnit.SECONDS);
        String formatString = milliSeconds < 0L ? "-%01d.%03d" : "%01d.%03d";
        return String.format(formatString, Math.abs(seconds), Math.abs(remainder));
    }

    @Override
    public QueueStatistics fetchStatistics() {
        return QueueApiHelper.getInternal(this.fetchStatisticsAsync(null));
    }

    @Override
    public Future<QueueStatistics> fetchStatisticsAsync(Double deadlineInSeconds) {
        if (deadlineInSeconds == null) {
            deadlineInSeconds = 10.0;
        }
        if (deadlineInSeconds <= 0.0) {
            String string = String.valueOf(deadlineInSeconds);
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Deadline must be > 0, got ").append(string).toString());
        }
        List<Queue> queues = Collections.singletonList(this);
        Future future = QueueStatistics.fetchForQueuesAsync(queues, this.apiHelper, deadlineInSeconds);
        return this.extractSingleEntry(future);
    }

    <T extends ProtocolMessage<T>> Future<T> makeAsyncCall(String methodName, ProtocolMessage<?> request, T response) {
        return this.apiHelper.makeAsyncCall(methodName, request, response, new ApiProxy.ApiConfig());
    }
}

