/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.prospectivesearch;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.prospectivesearch.ErrorPb;
import com.google.appengine.api.prospectivesearch.FieldType;
import com.google.appengine.api.prospectivesearch.ProspectiveSearchPb;
import com.google.appengine.api.prospectivesearch.ProspectiveSearchService;
import com.google.appengine.api.prospectivesearch.QuerySyntaxException;
import com.google.appengine.api.prospectivesearch.Subscription;
import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.UninitializedMessageException;
import com.google.appengine.repackaged.com.google.protobuf.bridge.ProtoConverter;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.apphosting.api.ApiProxy;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

@Deprecated
class ProspectiveSearchServiceImpl
implements ProspectiveSearchService {
    static final String PACKAGE = "matcher";
    static final Logger logger = Logger.getLogger(ProspectiveSearchServiceImpl.class.getName());
    private static final Converter<OnestoreEntity.EntityProto, OnestoreEntity.EntityProto> TO_ENTITY_PROTO2 = ProtoConverter.forProtos(OnestoreEntity.EntityProto.getDefaultInstance(), OnestoreEntity.EntityProto.getDefaultInstance());

    ProspectiveSearchServiceImpl() {
    }

    @Override
    public void subscribe(String topic, String subId, long leaseDurationSeconds, String query, Map<String, FieldType> schema) {
        if (leaseDurationSeconds < 0L) {
            throw new IllegalArgumentException(new StringBuilder(57).append("Lease duration must be non-negative: ").append(leaseDurationSeconds).toString());
        }
        ProspectiveSearchPb.SubscribeRequest.Builder req = ProspectiveSearchPb.SubscribeRequest.newBuilder().setTopic(ByteString.copyFromUtf8(topic)).setSubId(ByteString.copyFromUtf8(subId)).setLeaseDurationSec(leaseDurationSeconds).setVanillaQuery(ByteString.copyFromUtf8(query));
        schema.forEach((name, type) -> req.addSchemaEntry(ProspectiveSearchPb.SchemaEntry.newBuilder().setName(ByteString.copyFromUtf8(name)).setType(type.internalType)));
        try {
            ProspectiveSearchServiceImpl.doCall("Subscribe", req.build(), ProspectiveSearchPb.SubscribeResponse.getDefaultInstance());
        }
        catch (ApiProxy.ApplicationException e) {
            switch (ErrorPb.Error.ErrorCode.forNumber(e.getApplicationError())) {
                case BAD_REQUEST: {
                    throw new QuerySyntaxException(subId, topic, query, e.getErrorDetail());
                }
            }
            throw e;
        }
    }

    @Override
    public void unsubscribe(String topic, String subId) {
        ProspectiveSearchPb.UnsubscribeRequest req = ProspectiveSearchPb.UnsubscribeRequest.newBuilder().setTopic(ByteString.copyFromUtf8(topic)).setSubId(ByteString.copyFromUtf8(subId)).build();
        try {
            ProspectiveSearchServiceImpl.doCall("Unsubscribe", req, ProspectiveSearchPb.UnsubscribeResponse.getDefaultInstance());
        }
        catch (ApiProxy.ApplicationException e) {
            switch (ErrorPb.Error.ErrorCode.forNumber(e.getApplicationError())) {
                case BAD_REQUEST: {
                    throw new IllegalArgumentException(e.getErrorDetail());
                }
            }
            throw e;
        }
    }

    @Override
    public void match(Entity entity, String topic) {
        this.match(entity, topic, "");
    }

    @Override
    public void match(Entity entity, String topic, String resultKey) {
        this.match(entity, topic, resultKey, "/_ah/prospective_search", DEFAULT_RESULT_TASK_QUEUE_NAME, 100, true);
    }

    @Override
    public void match(Entity entity, String topic, String resultKey, String relativeUrl, String taskQueueName, int batchSize, boolean resultReturnDocument) {
        OnestoreEntity.EntityProto doc = EntityTranslator.convertToPb(entity);
        ProspectiveSearchPb.MatchRequest.Builder req = ProspectiveSearchPb.MatchRequest.newBuilder().setDocument(TO_ENTITY_PROTO2.convert(doc)).setTopic(ByteString.copyFromUtf8(topic)).setResultKey(ByteString.copyFromUtf8(resultKey)).setResultRelativeUrl(ByteString.copyFromUtf8(relativeUrl)).setResultTaskQueue(ByteString.copyFromUtf8(taskQueueName)).setResultBatchSize(batchSize);
        if (resultReturnDocument) {
            req.setResultPythonDocumentClass(ProspectiveSearchPb.MatchRequest.PythonDocumentClass.ENTITY);
        }
        ProspectiveSearchServiceImpl.doCall("Match", req.build(), ProspectiveSearchPb.MatchResponse.getDefaultInstance());
    }

    @Override
    public List<Subscription> listSubscriptions(String topic) {
        return this.listSubscriptions(topic, "", 1000, 0L);
    }

    @Override
    public List<Subscription> listSubscriptions(String topic, String subIdStart, int maxResults, long expiresBefore) {
        ProspectiveSearchPb.ListSubscriptionsRequest.Builder req = ProspectiveSearchPb.ListSubscriptionsRequest.newBuilder().setTopic(ByteString.copyFromUtf8(topic)).setSubscriptionIdStart(ByteString.copyFromUtf8(subIdStart)).setMaxResults(maxResults);
        if (expiresBefore > 0L) {
            req.setExpiresBefore(expiresBefore);
        }
        ProspectiveSearchPb.ListSubscriptionsResponse rsp = ProspectiveSearchServiceImpl.doCall("ListSubscriptions", req.build(), ProspectiveSearchPb.ListSubscriptionsResponse.getDefaultInstance());
        return ProspectiveSearchServiceImpl.convertSubscriptionList(rsp.getSubscriptionList());
    }

    @Override
    public Subscription getSubscription(String topic, String subId) {
        Subscription sub;
        List<Subscription> subs = this.listSubscriptions(topic, subId, 1, 0L);
        if (!subs.isEmpty() && (sub = subs.get(0)).getId().equals(subId)) {
            return sub;
        }
        throw new IllegalArgumentException(String.format("No such subscription topic: %s, id: %s", topic, subId));
    }

    @Override
    public List<String> listTopics(String topicStart, long maxResults) {
        ProspectiveSearchPb.ListTopicsRequest.Builder req = ProspectiveSearchPb.ListTopicsRequest.newBuilder();
        if (!topicStart.isEmpty()) {
            req.setTopicStart(ByteString.copyFromUtf8(topicStart));
        }
        req.setMaxResults(maxResults);
        ProspectiveSearchPb.ListTopicsResponse rsp = ProspectiveSearchServiceImpl.doCall("ListTopics", req.build(), ProspectiveSearchPb.ListTopicsResponse.getDefaultInstance());
        return rsp.getTopicList().stream().map(ByteString::toStringUtf8).collect(Collectors.toList());
    }

    @Override
    public Entity getDocument(HttpServletRequest matchCallbackPost) {
        try {
            String docStr = matchCallbackPost.getParameter("document");
            byte[] docBuf = BaseEncoding.base64Url().decode(CharMatcher.whitespace().removeFrom(docStr));
            return EntityTranslator.createFromPbBytes(docBuf);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "Could not decode returned matching message.", e);
            return null;
        }
    }

    private static <T extends Message> T doCall(String name, Message request, T responseTemplate) {
        byte[] serializedResponse = ApiProxy.makeSyncCall(PACKAGE, name, request.toByteArray());
        try {
            Message response = responseTemplate.getParserForType().parseFrom(serializedResponse, (ExtensionRegistryLite)ExtensionRegistry.getGeneratedRegistry());
            return (T)response;
        }
        catch (InvalidProtocolBufferException | UninitializedMessageException e) {
            ApiProxy.ArgumentException argumentException = new ApiProxy.ArgumentException(PACKAGE, name);
            argumentException.initCause(e);
            throw argumentException;
        }
    }

    private static List<Subscription> convertSubscriptionList(List<ProspectiveSearchPb.SubscriptionRecord> from) {
        ArrayList<Subscription> to = new ArrayList<Subscription>();
        for (ProspectiveSearchPb.SubscriptionRecord internal : from) {
            to.add(new Subscription(internal));
        }
        return to;
    }
}

