/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Cursor;
import com.google.appengine.api.search.FieldExpression;
import com.google.appengine.api.search.SortOptions;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.QueryOptionsChecker;
import com.google.appengine.repackaged.com.google.appengine.api.search.proto.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class QueryOptions {
    private final int limit;
    private final int numberFoundAccuracy;
    private final ImmutableList<String> fieldsToReturn;
    private final ImmutableList<String> fieldsToSnippet;
    private final ImmutableList<FieldExpression> expressionsToReturn;
    private final SortOptions sortOptions;
    private final Cursor cursor;
    private final Integer offset;
    private final Boolean idsOnly;

    private QueryOptions(Builder builder) {
        this.limit = QueryOptionsChecker.checkLimit(Util.defaultIfNull(builder.limit, 20));
        this.numberFoundAccuracy = Util.defaultIfNull(builder.numberFoundAccuracy, -1);
        this.sortOptions = builder.sortOptions;
        this.cursor = builder.cursor;
        this.offset = QueryOptionsChecker.checkOffset(builder.offset);
        this.fieldsToReturn = builder.fieldsToReturn;
        this.fieldsToSnippet = builder.fieldsToSnippet;
        this.expressionsToReturn = ImmutableList.copyOf(builder.expressionsToReturn);
        this.idsOnly = builder.idsOnly;
        this.checkValid();
    }

    public int getLimit() {
        return this.limit;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public int getOffset() {
        return this.offset == null ? 0 : this.offset;
    }

    public boolean hasNumberFoundAccuracy() {
        return this.numberFoundAccuracy != -1;
    }

    public int getNumberFoundAccuracy() {
        return this.numberFoundAccuracy;
    }

    public SortOptions getSortOptions() {
        return this.sortOptions;
    }

    public boolean isReturningIdsOnly() {
        return this.idsOnly == null ? false : this.idsOnly;
    }

    public List<String> getFieldsToReturn() {
        return this.fieldsToReturn;
    }

    public List<String> getFieldsToSnippet() {
        return this.fieldsToSnippet;
    }

    public List<FieldExpression> getExpressionsToReturn() {
        return this.expressionsToReturn;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(QueryOptions request) {
        return new Builder(request);
    }

    private QueryOptions checkValid() {
        QueryOptionsChecker.checkFieldNames(this.fieldsToReturn);
        return this;
    }

    private static String quoteString(String argument) {
        String string = argument.replace("\"", "\\\"");
        return new StringBuilder(2 + String.valueOf(string).length()).append("\"").append(string).append("\"").toString();
    }

    SearchServicePb.SearchParams.Builder copyToProtocolBuffer(SearchServicePb.SearchParams.Builder builder, String query) {
        builder.setLimit(this.getLimit());
        if (this.cursor != null) {
            this.cursor.copyToProtocolBuffer(builder);
        } else {
            builder.setCursorType(SearchServicePb.SearchParams.CursorType.NONE);
        }
        if (this.offset != null) {
            builder.setOffset(this.offset);
        }
        if (this.idsOnly != null) {
            builder.setKeysOnly(this.idsOnly);
        }
        if (this.hasNumberFoundAccuracy()) {
            builder.setMatchedCountAccuracy(this.numberFoundAccuracy);
        }
        if (this.sortOptions != null) {
            this.sortOptions.copyToProtocolBuffer(builder);
        }
        if (!(this.fieldsToReturn.isEmpty() && this.fieldsToSnippet.isEmpty() && this.expressionsToReturn.isEmpty())) {
            SearchServicePb.FieldSpec.Builder fieldSpec = SearchServicePb.FieldSpec.newBuilder();
            fieldSpec.addAllName(this.fieldsToReturn);
            for (String field : this.fieldsToSnippet) {
                FieldExpression.Builder expressionBuilder = FieldExpression.newBuilder().setName(field);
                String string = QueryOptions.quoteString(query);
                expressionBuilder.setExpression(new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(field).length()).append("snippet(").append(string).append(", ").append(field).append(")").toString());
                fieldSpec.addExpression(expressionBuilder.build().copyToProtocolBuffer());
            }
            for (FieldExpression expression : this.expressionsToReturn) {
                fieldSpec.addExpression(expression.copyToProtocolBuffer());
            }
            builder.setFieldSpec(fieldSpec);
        }
        return builder;
    }

    public String toString() {
        Util.ToStringHelper helper = new Util.ToStringHelper("QueryOptions").addField("limit", this.limit).addField("IDsOnly", this.idsOnly).addField("sortOptions", this.sortOptions).addIterableField("fieldsToReturn", this.fieldsToReturn).addIterableField("fieldsToSnippet", this.fieldsToSnippet).addIterableField("expressionsToReturn", this.expressionsToReturn);
        if (this.hasNumberFoundAccuracy()) {
            helper.addField("numberFoundAccuracy", this.numberFoundAccuracy);
        }
        return helper.addField("cursor", this.cursor).addField("offset", this.offset).finish();
    }

    public static final class Builder {
        private Integer limit;
        private ImmutableList<String> fieldsToReturn = ImmutableList.of();
        private ImmutableList<String> fieldsToSnippet = ImmutableList.of();
        private List<FieldExpression> expressionsToReturn = new ArrayList<FieldExpression>();
        private SortOptions sortOptions;
        private Cursor cursor;
        private Integer numberFoundAccuracy;
        private Integer offset;
        private Boolean idsOnly;

        private Builder() {
        }

        private Builder(QueryOptions request) {
            this.limit = request.getLimit();
            this.cursor = request.getCursor();
            this.numberFoundAccuracy = request.getNumberFoundAccuracy();
            this.sortOptions = request.getSortOptions();
            this.fieldsToReturn = ImmutableList.copyOf(request.getFieldsToReturn());
            this.fieldsToSnippet = ImmutableList.copyOf(request.getFieldsToSnippet());
            this.expressionsToReturn = new ArrayList<FieldExpression>(request.getExpressionsToReturn());
        }

        public Builder setLimit(int limit) {
            this.limit = QueryOptionsChecker.checkLimit(limit);
            return this;
        }

        public Builder setCursor(Cursor cursor) {
            Preconditions.checkArgument(this.offset == null || cursor == null, "offset and cursor cannot be set in the same request");
            this.cursor = cursor;
            return this;
        }

        public Builder setCursor(Cursor.Builder cursorBuilder) {
            return this.setCursor(cursorBuilder.build());
        }

        public Builder setOffset(int offset) {
            Preconditions.checkArgument(this.cursor == null, "offset and cursor cannot be set in the same request");
            this.offset = QueryOptionsChecker.checkOffset(offset);
            return this;
        }

        public Builder setNumberFoundAccuracy(int numberFoundAccuracy) {
            this.numberFoundAccuracy = QueryOptionsChecker.checkNumberFoundAccuracy(numberFoundAccuracy);
            return this;
        }

        public Builder clearNumberFoundAccuracy() {
            this.numberFoundAccuracy = -1;
            return this;
        }

        public Builder setFieldsToReturn(String ... fields) {
            Preconditions.checkNotNull(fields, "field names cannot be null");
            Preconditions.checkArgument(this.idsOnly == null, "You may not set fields to return if search returns keys only");
            this.fieldsToReturn = ImmutableList.copyOf(QueryOptionsChecker.checkFieldNames(Arrays.asList(fields)));
            return this;
        }

        public Builder setFieldsToSnippet(String ... fieldsToSnippet) {
            Preconditions.checkNotNull(fieldsToSnippet, "field names cannot be null");
            this.fieldsToSnippet = ImmutableList.copyOf(QueryOptionsChecker.checkFieldNames(Arrays.asList(fieldsToSnippet)));
            return this;
        }

        public Builder addExpressionToReturn(FieldExpression.Builder expressionBuilder) {
            Preconditions.checkArgument(this.idsOnly == null, "You may not add expressions to return if search returns keys only");
            return this.addExpressionToReturn(expressionBuilder.build());
        }

        public Builder setReturningIdsOnly(boolean idsOnly) {
            Preconditions.checkArgument(this.expressionsToReturn.isEmpty(), "You cannot request IDs only if expressions to return are set");
            Preconditions.checkArgument(this.fieldsToReturn.isEmpty(), "You cannot request IDs only if fields to return are already set");
            this.idsOnly = idsOnly;
            return this;
        }

        public Builder addExpressionToReturn(FieldExpression expression) {
            this.expressionsToReturn.add(expression);
            return this;
        }

        public Builder setSortOptions(SortOptions sortOptions) {
            this.sortOptions = sortOptions;
            return this;
        }

        public Builder setSortOptions(SortOptions.Builder builder) {
            this.sortOptions = builder.build();
            return this;
        }

        public QueryOptions build() {
            return new QueryOptions(this);
        }
    }
}

