/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.flogger.LogContext;
import com.google.appengine.repackaged.com.google.common.flogger.MetadataKey;
import com.google.appengine.repackaged.com.google.common.flogger.backend.BaseMessageFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.KeyValueFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogData;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogMessageFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MessageUtils;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Metadata;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MetadataHandler;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MetadataKeyValueHandlers;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MetadataProcessor;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class SimpleMessageFormatter {
    private static final Set<MetadataKey<?>> DEFAULT_KEYS_TO_IGNORE = Collections.singleton(LogContext.Key.LOG_CAUSE);
    private static final MetadataHandler<MetadataKey.KeyValueHandler> DEFAULT_HANDLER = MetadataKeyValueHandlers.getDefaultHandler(DEFAULT_KEYS_TO_IGNORE);
    private static final LogMessageFormatter DEFAULT_FORMATTER = new LogMessageFormatter(){

        @Override
        public StringBuilder append(LogData logData, Metadata scope, StringBuilder out) {
            return SimpleMessageFormatter.appendFormatted(logData, scope, out);
        }

        @Override
        public String format(LogData logData, Metadata scope) {
            return SimpleMessageFormatter.format(logData, scope);
        }
    };

    public static LogMessageFormatter getDefaultFormatter() {
        return DEFAULT_FORMATTER;
    }

    public static StringBuilder appendFormatted(LogData logData, Metadata scope, StringBuilder buffer) {
        return SimpleMessageFormatter.appendFormatted(logData, scope, DEFAULT_HANDLER, buffer);
    }

    public static StringBuilder appendFormatted(LogData logData, Metadata scope, MetadataHandler<MetadataKey.KeyValueHandler> metadataHandler, StringBuilder buffer) {
        BaseMessageFormatter.appendFormattedMessage(logData, buffer);
        return SimpleMessageFormatter.appendContext(MetadataProcessor.forScopeAndLogSite(scope, logData.getMetadata()), metadataHandler, buffer);
    }

    public static StringBuilder appendContext(MetadataProcessor metadataProcessor, MetadataHandler<MetadataKey.KeyValueHandler> metadataHandler, StringBuilder buffer) {
        KeyValueFormatter kvf = new KeyValueFormatter("[CONTEXT ", " ]", buffer);
        metadataProcessor.process(metadataHandler, kvf);
        kvf.done();
        return buffer;
    }

    public static String getLiteralLogMessage(LogData logData) {
        return MessageUtils.safeToString(logData.getLiteralArgument());
    }

    public static boolean mustBeFormatted(LogData logData, Metadata scope, Set<MetadataKey<?>> singleKeysToIgnore) {
        if (logData.getTemplateContext() != null || scope.size() > 0) {
            return true;
        }
        Metadata metadata = logData.getMetadata();
        int metadataSize = metadata.size();
        boolean containsAll = metadataSize <= singleKeysToIgnore.size();
        for (int n = 0; containsAll && n < metadataSize; ++n) {
            MetadataKey<?> key = metadata.getKey(n);
            containsAll = !key.canRepeat() && singleKeysToIgnore.contains(key);
        }
        return !containsAll;
    }

    private static String format(LogData logData, Metadata scope) {
        return SimpleMessageFormatter.mustBeFormatted(logData, scope, DEFAULT_KEYS_TO_IGNORE) ? SimpleMessageFormatter.appendFormatted(logData, scope, DEFAULT_HANDLER, new StringBuilder()).toString() : SimpleMessageFormatter.getLiteralLogMessage(logData);
    }

    @Deprecated
    public static void format(LogData logData, Metadata scope, SimpleLogHandler receiver) {
        receiver.handleFormattedLogMessage(logData.getLevel(), SimpleMessageFormatter.format(logData, scope), logData.getMetadata().findValue(LogContext.Key.LOG_CAUSE));
    }

    @Deprecated
    public static void format(LogData logData, SimpleLogHandler receiver) {
        SimpleMessageFormatter.format(logData, Metadata.empty(), receiver);
    }

    @Deprecated
    public static void format(LogData logData, SimpleLogHandler receiver, Option option) {
        switch (option) {
            case WITH_LOG_SITE: {
                StringBuilder buffer = new StringBuilder();
                if (MessageUtils.appendLogSite(logData.getLogSite(), buffer)) {
                    buffer.append(" ");
                }
                String message = SimpleMessageFormatter.appendFormatted(logData, Metadata.empty(), buffer).toString();
                Throwable cause = logData.getMetadata().findValue(LogContext.Key.LOG_CAUSE);
                receiver.handleFormattedLogMessage(logData.getLevel(), message, cause);
                break;
            }
            case DEFAULT: {
                SimpleMessageFormatter.format(logData, Metadata.empty(), receiver);
            }
        }
    }

    @Deprecated
    @GoogleInternal
    public static StringBuilder formatMessageOnly(LogData logData) {
        if (logData.getTemplateContext() == null) {
            return new StringBuilder(MessageUtils.safeToString(logData.getLiteralArgument()));
        }
        return BaseMessageFormatter.appendFormattedMessage(logData, new StringBuilder());
    }

    private SimpleMessageFormatter() {
    }

    @Deprecated
    public static enum Option {
        DEFAULT,
        WITH_LOG_SITE;

    }

    @Deprecated
    public static interface SimpleLogHandler {
        public void handleFormattedLogMessage(Level var1, String var2, @NullableDecl Throwable var3);
    }
}

