/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend.google;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.flogger.LogContext;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogData;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogMessageFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LoggerBackend;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Metadata;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Platform;
import com.google.appengine.repackaged.com.google.common.flogger.backend.google.ShutdownChecker;
import com.google.appengine.repackaged.com.google.common.flogger.backend.google.SimpleCustomFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.AbstractBackend;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.AbstractLogRecord;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.BackendFactory;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.SimpleLogRecord;
import java.util.concurrent.TimeUnit;

public final class GoogleLoggerBackend
extends BackendFactory {
    private static final GoogleLoggerBackend INSTANCE = new GoogleLoggerBackend();
    private final LogMessageFormatter formatter = SimpleCustomFormatter.fromTemplateString(System.getProperty("google.debug_logs.format_template"));

    public static BackendFactory getInstance() {
        return INSTANCE;
    }

    private static LogMessageFormatter getFormatter() {
        return GoogleLoggerBackend.INSTANCE.formatter;
    }

    private GoogleLoggerBackend() {
    }

    @Override
    public LoggerBackend create(String loggingClass) {
        return new BackendImpl(loggingClass);
    }

    public String toString() {
        return "Google logger backend factory";
    }

    @VisibleForTesting
    static final class GoogleLogRecord
    extends AbstractLogRecord {
        GoogleLogRecord(LogData logData, Metadata scope) {
            super(logData, scope);
            this.setThrown(logData.getMetadata().findValue(LogContext.Key.LOG_CAUSE));
            this.getMessage();
        }

        @Override
        protected LogMessageFormatter getLogMessageFormatter() {
            return GoogleLoggerBackend.getFormatter();
        }
    }

    private static final class BackendImpl
    extends AbstractBackend {
        private BackendImpl(String loggingClass) {
            super(loggingClass);
        }

        private static void logToStderr(AbstractLogRecord record) {
            LogData data = record.getLogData();
            String levelName = data.getLevel().getName();
            System.err.printf("%1$ty%1$tm%1$td %1$tT.%1$tL:%2$s %3$s [%4$s] [%5$s.%6$s:%7$d] %8$s%n", TimeUnit.NANOSECONDS.toMillis(data.getTimestampNanos()), Character.valueOf(!levelName.isEmpty() ? levelName.charAt(0) : (char)'?'), Thread.currentThread().getId(), Thread.currentThread().getName(), data.getLogSite().getClassName(), data.getLogSite().getMethodName(), data.getLogSite().getLineNumber(), record.getMessage());
        }

        @Override
        public void log(LogData data) {
            GoogleLogRecord record = new GoogleLogRecord(data, Platform.getInjectedMetadata());
            this.log(record, data.wasForced());
            if (ShutdownChecker.isInSystemShutdown()) {
                BackendImpl.logToStderr(record);
            }
        }

        @Override
        public void handleError(RuntimeException error, LogData badData) {
            SimpleLogRecord record = SimpleLogRecord.error(error, badData, Platform.getInjectedMetadata());
            this.log(record, badData.wasForced());
            if (ShutdownChecker.isInSystemShutdown()) {
                BackendImpl.logToStderr(record);
            }
        }
    }
}

