/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.appengine.repackaged.com.google.common.base.ParametricNullness;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.FormatMethod;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.jspecify.nullness.NullMarked;

@NullMarked
@ElementTypesAreNonnullByDefault
@GoogleInternal
@GwtIncompatible(value="Class.isInstance")
public final class TunnelException
extends RuntimeException {
    @ParametricNullness
    @CanIgnoreReturnValue
    public static <T> T tunnel(Callable<T> callback) {
        Preconditions.checkNotNull(callback);
        try {
            return callback.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(e);
        }
    }

    private TunnelException(Exception e) {
        super("TunnelExceptions should always be unwrapped to deal with the checked exception underneath, this message should never be seen if TunnelException is used properly.", e);
    }

    @Override
    public synchronized Exception getCause() {
        return (Exception)Objects.requireNonNull(super.getCause());
    }

    @FormatMethod
    private static ClassCastException exception(Throwable cause, String message, Object ... formatArgs) {
        ClassCastException result = new ClassCastException(String.format(message, formatArgs));
        result.initCause(cause);
        return result;
    }

    @SafeVarargs
    private static void checkNoRuntimeExceptions(String methodName, Class<? extends Exception> ... clazzes) {
        for (Class<? extends Exception> clazz : clazzes) {
            Preconditions.checkArgument(!RuntimeException.class.isAssignableFrom(clazz), "The cause of a TunnelException can never be a RuntimeException, but %s argument was %s", (Object)methodName, clazz);
        }
    }

    public <X extends Exception> X getCauseAs(Class<X> exceptionClazz) {
        Preconditions.checkNotNull(exceptionClazz);
        TunnelException.checkNoRuntimeExceptions("getCause", exceptionClazz);
        if (exceptionClazz.isInstance(this.getCause())) {
            return (X)((Exception)exceptionClazz.cast(this.getCause()));
        }
        throw TunnelException.exception(this.getCause(), "getCause(%s) doesn't match underlying exception", exceptionClazz);
    }

    @CheckReturnValue
    public <X extends Exception> RuntimeException rethrow(Class<X> exceptionClazz) throws X {
        Preconditions.checkNotNull(exceptionClazz);
        TunnelException.checkNoRuntimeExceptions("rethrow", exceptionClazz);
        Throwables.throwIfInstanceOf(this.getCause(), exceptionClazz);
        throw TunnelException.exception(this.getCause(), "rethrow(%s) doesn't match underlying exception", exceptionClazz);
    }

    @CheckReturnValue
    public <X1 extends Exception, X2 extends Exception> RuntimeException rethrow(Class<X1> exceptionClazz1, Class<X2> exceptionClazz2) throws X1, X2 {
        Preconditions.checkNotNull(exceptionClazz1);
        Preconditions.checkNotNull(exceptionClazz2);
        TunnelException.checkNoRuntimeExceptions("rethrow", exceptionClazz1, exceptionClazz2);
        Throwables.throwIfInstanceOf(this.getCause(), exceptionClazz1);
        Throwables.throwIfInstanceOf(this.getCause(), exceptionClazz2);
        throw TunnelException.exception(this.getCause(), "rethrow(%s, %s) doesn't match underlying exception", exceptionClazz1, exceptionClazz2);
    }

    @CheckReturnValue
    public <X1 extends Exception, X2 extends Exception, X3 extends Exception> RuntimeException rethrow(Class<X1> exceptionClazz1, Class<X2> exceptionClazz2, Class<X3> exceptionClazz3) throws X1, X2, X3 {
        Preconditions.checkNotNull(exceptionClazz1);
        Preconditions.checkNotNull(exceptionClazz2);
        Preconditions.checkNotNull(exceptionClazz3);
        TunnelException.checkNoRuntimeExceptions("rethrow", exceptionClazz1, exceptionClazz2, exceptionClazz3);
        Throwables.throwIfInstanceOf(this.getCause(), exceptionClazz1);
        Throwables.throwIfInstanceOf(this.getCause(), exceptionClazz2);
        Throwables.throwIfInstanceOf(this.getCause(), exceptionClazz3);
        throw TunnelException.exception(this.getCause(), "rethrow(%s, %s, %s) doesn't match underlying exception", exceptionClazz1, exceptionClazz2, exceptionClazz3);
    }

    @CheckReturnValue
    public <X1 extends Exception, X2 extends Exception, X3 extends Exception, X4 extends Exception> RuntimeException rethrow(Class<X1> exceptionClazz1, Class<X2> exceptionClazz2, Class<X3> exceptionClazz3, Class<X4> exceptionClazz4) throws X1, X2, X3, X4 {
        Preconditions.checkNotNull(exceptionClazz1);
        Preconditions.checkNotNull(exceptionClazz2);
        Preconditions.checkNotNull(exceptionClazz3);
        Preconditions.checkNotNull(exceptionClazz4);
        TunnelException.checkNoRuntimeExceptions("rethrow", exceptionClazz1, exceptionClazz2, exceptionClazz3, exceptionClazz4);
        Throwables.throwIfInstanceOf(this.getCause(), exceptionClazz1);
        Throwables.throwIfInstanceOf(this.getCause(), exceptionClazz2);
        Throwables.throwIfInstanceOf(this.getCause(), exceptionClazz3);
        Throwables.throwIfInstanceOf(this.getCause(), exceptionClazz4);
        throw TunnelException.exception(this.getCause(), "rethrow(%s, %s, %s, %s) doesn't match underlying exception", exceptionClazz1, exceptionClazz2, exceptionClazz3, exceptionClazz4);
    }
}

