/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.appengine.repackaged.com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import org.jspecify.nullness.NullMarked;

@NullMarked
@ElementTypesAreNonnullByDefault
@GoogleInternal
@GwtIncompatible
final class FixedDelayRateLimiter
extends RateLimiter {
    private final long fixedDelayMicros;

    FixedDelayRateLimiter(RateLimiter.SleepingStopwatch stopwatch, long fixedDelayMillis) {
        super(stopwatch);
        this.fixedDelayMicros = TimeUnit.MILLISECONDS.toMicros(fixedDelayMillis);
    }

    @Override
    void doSetRate(double permitsPerSecond, long nowMicros) {
        throw new UnsupportedOperationException();
    }

    @Override
    double doGetRate() {
        return 0.0;
    }

    @Override
    long queryEarliestAvailable(long nowMicros) {
        return nowMicros + this.fixedDelayMicros;
    }

    @Override
    long reserveEarliestAvailable(int requiredPermits, long nowMicros) {
        return nowMicros + this.fixedDelayMicros;
    }
}

