/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.CommittedButStillApplyingException;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreNeedIndexException;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;
import java.util.ConcurrentModificationException;
import java.util.concurrent.Future;

public final class DatastoreApiHelper {
    static final String PACKAGE = "datastore_v3";
    static final String V4_PACKAGE = "datastore_v4";
    static final String APP_ID_OVERRIDE_KEY = "com.google.appengine.datastore.AppIdOverride";

    private DatastoreApiHelper() {
    }

    public static RuntimeException translateError(ApiProxy.ApplicationException exception) {
        DatastorePb.Error.ErrorCode errorCode = DatastorePb.Error.ErrorCode.valueOf(exception.getApplicationError());
        if (errorCode == null) {
            return new DatastoreFailureException(exception.getErrorDetail());
        }
        switch (errorCode) {
            case BAD_REQUEST: {
                return new IllegalArgumentException(exception.getErrorDetail());
            }
            case CONCURRENT_TRANSACTION: {
                return new ConcurrentModificationException(exception.getErrorDetail());
            }
            case NEED_INDEX: {
                return new DatastoreNeedIndexException(exception.getErrorDetail());
            }
            case TIMEOUT: 
            case BIGTABLE_ERROR: {
                return new DatastoreTimeoutException(exception.getErrorDetail());
            }
            case COMMITTED_BUT_STILL_APPLYING: {
                return new CommittedButStillApplyingException(exception.getErrorDetail());
            }
        }
        return new DatastoreFailureException(exception.getErrorDetail());
    }

    static <T extends ProtocolMessage<T>> Future<T> makeAsyncCall(ApiProxy.ApiConfig apiConfig, DatastorePb.DatastoreService_3.Method method, ProtocolMessage<?> request, final T responseProto) {
        Future<byte[]> response = ApiProxy.makeAsyncCall(PACKAGE, method.name(), request.toByteArray(), apiConfig);
        return new AsyncCallWrapper<T>(response){

            @Override
            protected T wrap(byte[] responseBytes) {
                if (responseBytes != null) {
                    responseProto.parseFrom(responseBytes);
                }
                return responseProto;
            }
        };
    }

    static <T extends MessageLite> Future<T> makeAsyncCall(ApiProxy.ApiConfig apiConfig, DatastoreV4.DatastoreV4Service.Method method, MessageLite request, T defaultResponseProto) {
        return DatastoreApiHelper.makeAsyncCall(apiConfig, method, request.toByteArray(), defaultResponseProto);
    }

    static <T extends MessageLite> Future<T> makeAsyncCall(ApiProxy.ApiConfig apiConfig, DatastoreV4.DatastoreV4Service.Method method, byte[] request, final T defaultResponseProto) {
        Future<byte[]> response = ApiProxy.makeAsyncCall(V4_PACKAGE, method.name(), request, apiConfig);
        return new AsyncCallWrapper<T>(response){

            @Override
            protected T wrap(byte[] responseBytes) throws Exception {
                if (responseBytes != null) {
                    return defaultResponseProto.getParserForType().parseFrom(responseBytes);
                }
                return defaultResponseProto;
            }
        };
    }

    static String getCurrentAppId() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            throw new NullPointerException("No API environment is registered for this thread.");
        }
        Object appIdOverride = environment.getAttributes().get(APP_ID_OVERRIDE_KEY);
        if (appIdOverride != null) {
            return (String)appIdOverride;
        }
        return environment.getAppId();
    }

    static AppIdNamespace getCurrentAppIdNamespace() {
        return DatastoreApiHelper.getCurrentAppIdNamespace(DatastoreApiHelper.getCurrentAppId());
    }

    static AppIdNamespace getCurrentAppIdNamespace(String appId) {
        String namespace = NamespaceManager.get();
        namespace = namespace == null ? "" : namespace;
        return new AppIdNamespace(appId, namespace);
    }

    private static abstract class AsyncCallWrapper<T>
    extends FutureWrapper<byte[], T> {
        AsyncCallWrapper(Future<byte[]> response) {
            super(response);
        }

        @Override
        protected Throwable convertException(Throwable cause) {
            if (cause instanceof ApiProxy.ApplicationException) {
                return DatastoreApiHelper.translateError((ApiProxy.ApplicationException)cause);
            }
            return cause;
        }
    }
}

