/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.primitives.Bytes;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

class InternalTransactionV4
implements TransactionImpl.InternalTransaction {
    private static final AtomicLong clientIdGenerator = new AtomicLong();
    private static final Map<String, InternalTransactionV4> internalTransactionRegister = new MapMaker().weakValues().makeMap();
    private final String clientId = Long.toString(clientIdGenerator.getAndIncrement());
    private final Future<DatastoreV4.BeginTransactionResponse> beginTxnFuture;
    private final Map<EntityV4.Key, byte[]> mutationMap = Maps.newLinkedHashMap();
    private final DatastoreV4.CommitRequest.Builder commitReqBuilder = DatastoreV4.CommitRequest.newBuilder();
    private final ApiProxy.ApiConfig apiConfig;
    private boolean isWritable = true;

    InternalTransactionV4(ApiProxy.ApiConfig apiConfig, Future<DatastoreV4.BeginTransactionResponse> beginTxnFuture) {
        this.apiConfig = apiConfig;
        this.beginTxnFuture = beginTxnFuture;
    }

    static InternalTransactionV4 create(ApiProxy.ApiConfig apiConfig, Future<DatastoreV4.BeginTransactionResponse> future) {
        InternalTransactionV4 txn = new InternalTransactionV4(apiConfig, future);
        internalTransactionRegister.put(txn.clientId, txn);
        return txn;
    }

    ByteString getHandle() {
        return FutureHelper.quietGet(this.beginTxnFuture).getTransaction();
    }

    void deferPut(Entity entity) {
        this.deferPut(DataTypeTranslator.toV4Entity(entity).build());
    }

    private void setMutation(EntityV4.Key key, DatastoreV4.Mutation.Builder mutationBuilder) {
        if (!this.isWritable) {
            throw new IllegalStateException("Transaction is not writable.");
        }
        this.commitReqBuilder.addMutation(mutationBuilder.build());
        this.mutationMap.put(key, this.commitReqBuilder.buildPartial().toByteArray());
        this.commitReqBuilder.clearMutation();
    }

    void deferPut(EntityV4.Entity entityProto) {
        this.setMutation(entityProto.getKey(), DatastoreV4.Mutation.newBuilder().setOp(DatastoreV4.Mutation.Operation.UPSERT).setEntity(entityProto));
    }

    void deferDelete(Key key) {
        this.setMutation(DataTypeTranslator.toV4Key(key).build(), DatastoreV4.Mutation.newBuilder().setOp(DatastoreV4.Mutation.Operation.DELETE).setKey(DataTypeTranslator.toV4Key(key).build()));
    }

    <T extends MessageLite> Future<Void> makeAsyncCall(DatastoreV4.DatastoreV4Service.Method method, byte[] request, T defaultResponseProto) {
        return new FutureWrapper<T, Void>(DatastoreApiHelper.makeAsyncCall(this.apiConfig, method, request, defaultResponseProto)){

            @Override
            protected Void wrap(T ignore) throws Exception {
                return null;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<Void> doCommitAsync() {
        this.isWritable = false;
        byte[][] protoSegmentsArray = new byte[this.mutationMap.size() + 1][];
        protoSegmentsArray[0] = DatastoreV4.CommitRequest.newBuilder().setTransaction(this.getHandle()).build().toByteArray();
        int arrayIndex = 1;
        for (byte[] mutData : this.mutationMap.values()) {
            protoSegmentsArray[arrayIndex++] = mutData;
        }
        byte[] encodedRequest = Bytes.concat(protoSegmentsArray);
        this.mutationMap.clear();
        return this.makeAsyncCall(DatastoreV4.DatastoreV4Service.Method.Commit, encodedRequest, DatastoreV4.CommitResponse.getDefaultInstance());
    }

    @Override
    public Future<Void> doRollbackAsync() {
        this.isWritable = false;
        byte[] requestBytes = DatastoreV4.RollbackRequest.newBuilder().setTransaction(this.getHandle()).build().toByteArray();
        this.mutationMap.clear();
        return this.makeAsyncCall(DatastoreV4.DatastoreV4Service.Method.Rollback, requestBytes, DatastoreV4.RollbackResponse.getDefaultInstance());
    }

    @Override
    public String getId() {
        return this.clientId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalTransactionV4 that = (InternalTransactionV4)o;
        return this.getHandle() == that.getHandle();
    }

    @Override
    public int hashCode() {
        return this.getHandle().hashCode();
    }

    static InternalTransactionV4 getById(String txnClientId) {
        InternalTransactionV4 txnImpl = internalTransactionRegister.get(txnClientId);
        if (txnImpl == null) {
            throw new IllegalArgumentException("Transaction not found with ID: " + txnClientId);
        }
        return txnImpl;
    }
}

