/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.InternalTransactionV4;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultsSource;
import com.google.appengine.api.datastore.QueryResultsSourceV4;
import com.google.appengine.api.datastore.QueryRunner;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Future;

final class QueryRunnerV4
implements QueryRunner {
    QueryRunnerV4() {
    }

    @Override
    public QueryResultsSource runQuery(ApiProxy.ApiConfig apiConfig, DatastoreServiceConfig datastoreServiceConfig, FetchOptions fetchOptions, Query query, Transaction txn) {
        DatastoreV4.RunQueryRequest.Builder queryBldr = QueryRunnerV4.toV4Query(query, fetchOptions);
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            queryBldr.getReadOptionsBuilder().setTransaction(InternalTransactionV4.getById(txn.getId()).getHandle());
        } else if (datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            queryBldr.getReadOptionsBuilder().setReadConsistency(DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL);
        }
        Future<DatastoreV4.RunQueryResponse> result = DatastoreApiHelper.makeAsyncCall(apiConfig, DatastoreV4.DatastoreV4Service.Method.RunQuery, queryBldr.build(), DatastoreV4.RunQueryResponse.getDefaultInstance());
        return new QueryResultsSourceV4(datastoreServiceConfig.getDatastoreCallbacks(), fetchOptions, txn, query, result, apiConfig);
    }

    static DatastoreV4.RunQueryRequest.Builder toV4Query(Query query, FetchOptions fetchOptions) {
        String name;
        Preconditions.checkArgument(query.getFullTextSearch() == null, "full-text search unsupported");
        Preconditions.checkArgument(query.getFilter() == null);
        DatastoreV4.RunQueryRequest.Builder requestBldr = DatastoreV4.RunQueryRequest.newBuilder();
        if (fetchOptions.getChunkSize() != null) {
            requestBldr.setSuggestedBatchSize(fetchOptions.getChunkSize());
        } else if (fetchOptions.getPrefetchSize() != null) {
            requestBldr.setSuggestedBatchSize(fetchOptions.getPrefetchSize());
        }
        EntityV4.PartitionId.Builder partitionId = requestBldr.getPartitionIdBuilder().setDatasetId(query.getAppId());
        if (!query.getNamespace().isEmpty()) {
            partitionId.setNamespace(query.getNamespace());
        }
        DatastoreV4.Query.Builder queryBldr = requestBldr.getQueryBuilder();
        if (query.getKind() != null) {
            queryBldr.addKindBuilder().setName(query.getKind());
        }
        if (fetchOptions.getOffset() != null) {
            queryBldr.setOffset(fetchOptions.getOffset());
        }
        if (fetchOptions.getLimit() != null) {
            queryBldr.setLimit(fetchOptions.getLimit());
        }
        if (fetchOptions.getStartCursor() != null) {
            queryBldr.setStartCursor(fetchOptions.getStartCursor().convertToPb().toByteString());
        }
        if (fetchOptions.getEndCursor() != null) {
            queryBldr.setEndCursor(fetchOptions.getEndCursor().convertToPb().toByteString());
        }
        HashSet<String> groupByProperties = Sets.newHashSet();
        if (query.getDistinct()) {
            if (query.getProjections().isEmpty()) {
                throw new IllegalArgumentException("Projected properties must be set to allow for distinct projections");
            }
            for (Projection projection : query.getProjections()) {
                name = projection.getPropertyName();
                groupByProperties.add(name);
                queryBldr.addGroupByBuilder().setName(name);
            }
        }
        for (Projection projection : query.getProjections()) {
            name = projection.getPropertyName();
            DatastoreV4.PropertyExpression.Builder projBuilder = queryBldr.addProjectionBuilder();
            projBuilder.getPropertyBuilder().setName(name);
            if (groupByProperties.isEmpty() || groupByProperties.contains(name)) continue;
            projBuilder.setAggregationFunction(DatastoreV4.PropertyExpression.AggregationFunction.FIRST);
        }
        if (query.isKeysOnly()) {
            DatastoreV4.PropertyExpression.Builder projBuilder = queryBldr.addProjectionBuilder();
            projBuilder.getPropertyBuilder().setName("__key__");
            if (!groupByProperties.isEmpty() && !groupByProperties.contains("__key__")) {
                projBuilder.setAggregationFunction(DatastoreV4.PropertyExpression.AggregationFunction.FIRST);
            }
        }
        DatastoreV4.CompositeFilter.Builder compositeFilter = DatastoreV4.CompositeFilter.newBuilder();
        if (query.getAncestor() != null) {
            compositeFilter.addFilterBuilder().getPropertyFilterBuilder().setOperator(DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR).setProperty(DatastoreV4.PropertyReference.newBuilder().setName("__key__")).setValue(EntityV4.Value.newBuilder().setKeyValue(DataTypeTranslator.toV4Key(query.getAncestor())));
        }
        for (Query.FilterPredicate filterPredicate : query.getFilterPredicates()) {
            compositeFilter.addFilterBuilder().setPropertyFilter(QueryRunnerV4.toV4PropertyFilter(filterPredicate));
        }
        if (compositeFilter.getFilterCount() == 1) {
            queryBldr.setFilter(compositeFilter.getFilter(0));
        } else if (compositeFilter.getFilterCount() > 1) {
            queryBldr.getFilterBuilder().setCompositeFilter(compositeFilter.setOperator(DatastoreV4.CompositeFilter.Operator.AND));
        }
        for (Query.SortPredicate sortPredicate : query.getSortPredicates()) {
            queryBldr.addOrder(QueryRunnerV4.toV4PropertyOrder(sortPredicate));
        }
        return requestBldr;
    }

    private static DatastoreV4.PropertyFilter.Builder toV4PropertyFilter(Query.FilterPredicate predicate) {
        DatastoreV4.PropertyFilter.Builder filter = DatastoreV4.PropertyFilter.newBuilder();
        Query.FilterOperator operator = predicate.getOperator();
        Object value = predicate.getValue();
        if (operator == Query.FilterOperator.IN) {
            if (!(predicate.getValue() instanceof Collection)) {
                throw new IllegalArgumentException("IN filter value is not a Collection.");
            }
            Collection valueCollection = (Collection)value;
            if (valueCollection.size() != 1) {
                throw new IllegalArgumentException("This service only supports 1 object for IN.");
            }
            operator = Query.FilterOperator.EQUAL;
            value = valueCollection.iterator().next();
        }
        filter.setOperator(QueryRunnerV4.toV4PropertyFilterOperator(operator));
        filter.getPropertyBuilder().setName(predicate.getPropertyName());
        filter.setValue(DataTypeTranslator.toV4Value(value, true));
        return filter;
    }

    private static DatastoreV4.PropertyFilter.Operator toV4PropertyFilterOperator(Query.FilterOperator operator) {
        switch (operator) {
            case LESS_THAN: {
                return DatastoreV4.PropertyFilter.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return DatastoreV4.PropertyFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return DatastoreV4.PropertyFilter.Operator.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return DatastoreV4.PropertyFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case EQUAL: {
                return DatastoreV4.PropertyFilter.Operator.EQUAL;
            }
        }
        throw new IllegalArgumentException("Can't convert: " + (Object)((Object)operator));
    }

    private static DatastoreV4.PropertyOrder.Builder toV4PropertyOrder(Query.SortPredicate predicate) {
        return DatastoreV4.PropertyOrder.newBuilder().setProperty(DatastoreV4.PropertyReference.newBuilder().setName(predicate.getPropertyName())).setDirection(QueryRunnerV4.toV4PropertyOrderDirection(predicate.getDirection()));
    }

    private static DatastoreV4.PropertyOrder.Direction toV4PropertyOrderDirection(Query.SortDirection direction) {
        switch (direction) {
            case ASCENDING: {
                return DatastoreV4.PropertyOrder.Direction.ASCENDING;
            }
            case DESCENDING: {
                return DatastoreV4.PropertyOrder.Direction.DESCENDING;
            }
        }
        throw new IllegalArgumentException("direction: " + (Object)((Object)direction));
    }
}

