/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CallbackContext;
import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.DatastoreCallbacksImpl;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

abstract class BaseCallbackContext<T>
implements CallbackContext<T> {
    private final CurrentTransactionProvider currentTxnProvider;
    private final List<T> elements;
    private int currentIndex;

    BaseCallbackContext(CurrentTransactionProvider currentTxnProvider, List<T> elements) {
        this.currentTxnProvider = Preconditions.checkNotNull(currentTxnProvider);
        this.elements = Collections.unmodifiableList(Preconditions.checkNotNull(elements));
    }

    @Override
    public List<T> getElements() {
        return this.elements;
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.currentTxnProvider.getCurrentTransaction(null);
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public T getCurrentElement() {
        return this.elements.get(this.currentIndex);
    }

    void executeCallbacks(Multimap<String, DatastoreCallbacksImpl.Callback> callbacksByKind, Collection<DatastoreCallbacksImpl.Callback> noKindCallbacks) {
        Preconditions.checkState(this.currentIndex == 0, "executeCallbacks cannot be called more than once.");
        for (T ele : this.elements) {
            Iterable<DatastoreCallbacksImpl.Callback> allCallbacksToRun = Iterables.concat(callbacksByKind.get(this.getKind(ele)), noKindCallbacks);
            for (DatastoreCallbacksImpl.Callback callback : allCallbacksToRun) {
                callback.run(this);
            }
            ++this.currentIndex;
        }
    }

    abstract String getKind(T var1);

    public String toString() {
        return MoreObjects.toStringHelper(this).add("elements", this.elements).add("currentIndex", this.currentIndex).toString();
    }
}

