/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms;

import com.mysql.jdbc.GoogleNonRegisteringDriver;
import com.mysql.jdbc.StringUtils;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppEngineDriver
implements Driver {
    private static final String LEGACY_RDBMS_PREFIX = "jdbc:google:rdbms://";
    private static final Logger log = Logger.getLogger(AppEngineDriver.class.getName());
    private final Driver delegateDriver = AppEngineDriver.createDelegateDriver();

    private static void registerDriver() {
        try {
            DriverManager.registerDriver(new AppEngineDriver());
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to register AppEngineDriver automatically.", e);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.delegateDriver.acceptsURL(url);
    }

    @Override
    public Connection connect(String urlStr, Properties info) throws SQLException {
        return this.delegateDriver.connect(urlStr, info);
    }

    @Override
    public final int getMajorVersion() {
        return this.delegateDriver.getMajorVersion();
    }

    @Override
    public final int getMinorVersion() {
        return this.delegateDriver.getMinorVersion();
    }

    @Override
    public final DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.delegateDriver.getPropertyInfo(url, info);
    }

    @Override
    public final boolean jdbcCompliant() {
        return this.delegateDriver.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegateDriver.getParentLogger();
    }

    private static Driver createDelegateDriver() {
        AppEngineGoogleMySqlDriver driver = null;
        try {
            driver = new AppEngineGoogleMySqlDriver();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to create AppEngineGoogleMySqlDriver.", e);
        }
        return driver;
    }

    static {
        AppEngineDriver.registerDriver();
    }

    private static class AppEngineGoogleMySqlDriver
    extends GoogleNonRegisteringDriver {
        protected String getAllowedPrefix() {
            return AppEngineDriver.LEGACY_RDBMS_PREFIX;
        }

        public Connection connect(String url, Properties info) throws SQLException {
            if (url != null && StringUtils.startsWithIgnoreCase((String)url, (String)this.getAllowedPrefix())) {
                return super.connect(url, info);
            }
            return null;
        }
    }
}

