/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.io;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.repackaged.com.google.common.io.LittleEndianDataInputStream;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.Immutable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import javax.annotation.CheckForNull;
import org.jspecify.nullness.NullMarked;

@NullMarked
@GoogleInternal
@GwtIncompatible
public final class RandomAccessZipStream {
    private static final int MINIMUM_INFLATER_BUFFER_SIZE = 1024;
    private static final int MAXIMUM_INFLATER_BUFFER_SIZE = 65535;
    private static final int MAXIMUM_ZIP_COMMENT_SIZE = 65535;
    private static final int CENSIG = 33639248;
    private static final int ENDSIG = 101010256;
    private static final int ENDSIG64 = 101075792;
    private static final int ENDHDR = 22;
    private static final int LOCAL_FILE_NAME_LENGTH = 26;
    private static final int LOCEXT = 28;
    private static final String ZIP_PATH_SEPARATOR = "/";
    private final int streamLength;
    private final InputStream underlyingZipStream;
    private final LittleEndianDataInputStream littleEndianInputStream;
    private final LinkedHashMap<String, ZipStreamEntry> entries = new LinkedHashMap();

    @CanIgnoreReturnValue
    public RandomAccessZipStream(InputStream underlyingZipStream, int streamLength) throws ZipException {
        Preconditions.checkArgument(0 < streamLength, "Must specify the length of the ZIP archive");
        Preconditions.checkArgument(underlyingZipStream.markSupported(), "InputStream must support marking and resetting");
        this.streamLength = streamLength;
        this.underlyingZipStream = underlyingZipStream;
        this.littleEndianInputStream = new LittleEndianDataInputStream(underlyingZipStream);
        underlyingZipStream.mark(streamLength);
        this.initializeCentralDirectory();
    }

    public RandomAccessZipStream(byte[] buffer) throws ZipException {
        this(new ByteArrayInputStream(buffer), buffer.length);
    }

    public Collection<ZipStreamEntry> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    @CheckForNull
    public ZipStreamEntry getEntry(String name) {
        ZipStreamEntry zipStreamEntry;
        Preconditions.checkNotNull(name);
        ZipStreamEntry entry = this.entries.get(name);
        if (entry != null) {
            zipStreamEntry = entry;
        } else {
            String string = String.valueOf(name);
            String string2 = String.valueOf(ZIP_PATH_SEPARATOR);
            zipStreamEntry = this.entries.get(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        return zipStreamEntry;
    }

    public InputStream getInputStream(ZipStreamEntry entry) throws ZipException {
        InputStream streamAtEntry;
        Preconditions.checkNotNull(entry, "entry");
        Preconditions.checkArgument(entry == this.getEntry(entry.getName()), "Entry doesn't belong to this RandomAccessZipStream");
        try {
            this.underlyingZipStream.reset();
            ByteStreams.skipFully(this.underlyingZipStream, entry.relativeOffsetToLocalHeader + 28L);
            int localExtraLen = this.littleEndianInputStream.readUnsignedShort();
            ByteStreams.skipFully(this.underlyingZipStream, entry.nameLen + localExtraLen);
        }
        catch (IOException e) {
            ZipException zipException = new ZipException("Error finding local record in ZIP.");
            zipException.initCause(e);
            throw zipException;
        }
        switch (entry.getMethod()) {
            case 8: {
                int bufSize = (int)Math.max(1024L, Math.min(entry.getCompressedSize(), 65535L));
                streamAtEntry = new InflaterInputStream(this.underlyingZipStream, new Inflater(true), bufSize);
                break;
            }
            case 0: {
                streamAtEntry = this.underlyingZipStream;
                break;
            }
            default: {
                throw new ZipException("Unsupported ZIP compression method.");
            }
        }
        return ByteStreams.limit(streamAtEntry, entry.getSize());
    }

    public String getLocalFileHeaderName(ZipStreamEntry entry) throws IOException {
        Preconditions.checkNotNull(entry, "entry");
        Preconditions.checkArgument(entry == this.getEntry(entry.getName()), "Entry doesn't belong to this RandomAccessZipStream");
        this.underlyingZipStream.reset();
        ByteStreams.skipFully(this.underlyingZipStream, entry.relativeOffsetToLocalHeader + 26L);
        int fileNameLen = this.littleEndianInputStream.readUnsignedShort();
        ByteStreams.skipFully(this.underlyingZipStream, 2L);
        byte[] fileName = new byte[fileNameLen];
        this.underlyingZipStream.read(fileName);
        return new String(fileName, entry.getEncoding());
    }

    public int size() {
        return this.entries.size();
    }

    private void initializeCentralDirectory() throws ZipException {
        long scanOffset = (long)this.streamLength - 22L;
        if (scanOffset < 0L) {
            throw new ZipException("Too short to be a valid ZIP archive.");
        }
        long stopOffset = Math.max(0L, scanOffset - 65535L);
        try {
            int sig;
            block7: {
                do {
                    this.underlyingZipStream.reset();
                    ByteStreams.skipFully(this.underlyingZipStream, scanOffset);
                    if (this.littleEndianInputStream.readInt() == 101010256) break block7;
                } while (--scanOffset >= stopOffset);
                throw new ZipException("ZIP directory not found, not a ZIP archive.");
            }
            int numberOfDisk = this.littleEndianInputStream.readUnsignedShort();
            int centralDirDisk = this.littleEndianInputStream.readUnsignedShort();
            int numRecords = this.littleEndianInputStream.readUnsignedShort();
            int totalRecords = this.littleEndianInputStream.readUnsignedShort();
            this.littleEndianInputStream.readInt();
            long offsetToCentralDir = this.littleEndianInputStream.readInt();
            this.littleEndianInputStream.readUnsignedShort();
            if (numRecords != totalRecords || numberOfDisk != 0 || centralDirDisk != 0) {
                throw new ZipException("Spanned ZIP archives NOT supported.");
            }
            this.underlyingZipStream.reset();
            ByteStreams.skipFully(this.underlyingZipStream, offsetToCentralDir);
            while ((sig = this.littleEndianInputStream.readInt()) != 101010256 && sig != 101075792) {
                if (sig != 33639248) {
                    throw new ZipException("Local entry header NOT found");
                }
                ZipStreamEntry entry = new ZipStreamEntry(this.littleEndianInputStream, this.underlyingZipStream);
                this.entries.put(entry.getName(), entry);
            }
        }
        catch (IOException e) {
            ZipException zipEx = new ZipException("Invalid ZIP archive.");
            zipEx.initCause(e);
            throw zipEx;
        }
    }

    private static long dosToJavaTime(int time, int date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(14, 0);
        cal.set(1980 + (date >> 9 & 0x7F), (date >> 5 & 0xF) - 1, date & 0x1F, time >> 11 & 0x1F, time >> 5 & 0x3F, (time & 0x1F) << 1);
        return cal.getTime().getTime();
    }

    @Immutable
    public static final class ZipStreamEntry
    implements Serializable {
        private static final long serialVersionUID = -3699231327290802232L;
        private final int versionMadeBy;
        private final int versionForExtraction;
        private final int bitFlags;
        private final int method;
        private final long time;
        private final long crc;
        private final long compressedSize;
        private final long size;
        private final int nameLen;
        private final int internalFileAttributes;
        private final long externalFileAttributes;
        private final long relativeOffsetToLocalHeader;
        private final String name;
        @CheckForNull
        private final byte[] extra;
        @CheckForNull
        private final String comment;

        ZipStreamEntry(LittleEndianDataInputStream littleEndianInputStream, InputStream underlyingZipStream) throws ZipException, IOException {
            this.versionMadeBy = littleEndianInputStream.readUnsignedShort();
            this.versionForExtraction = littleEndianInputStream.readUnsignedShort();
            this.bitFlags = littleEndianInputStream.readUnsignedShort();
            this.method = littleEndianInputStream.readUnsignedShort();
            this.time = RandomAccessZipStream.dosToJavaTime(littleEndianInputStream.readUnsignedShort(), littleEndianInputStream.readUnsignedShort());
            this.crc = 0xFFFFFFFFL & (long)littleEndianInputStream.readInt();
            this.compressedSize = littleEndianInputStream.readInt();
            this.size = littleEndianInputStream.readInt();
            this.nameLen = littleEndianInputStream.readUnsignedShort();
            int extraLen = littleEndianInputStream.readUnsignedShort();
            int commentLen = littleEndianInputStream.readUnsignedShort();
            littleEndianInputStream.readUnsignedShort();
            this.internalFileAttributes = littleEndianInputStream.readUnsignedShort();
            this.externalFileAttributes = littleEndianInputStream.readInt();
            this.relativeOffsetToLocalHeader = littleEndianInputStream.readInt();
            byte[] nameBytes = new byte[this.nameLen];
            ByteStreams.readFully(underlyingZipStream, nameBytes);
            if (extraLen > 0) {
                this.extra = new byte[extraLen];
                ByteStreams.readFully(underlyingZipStream, this.extra);
            } else {
                this.extra = null;
            }
            byte[] commentBytes = null;
            if (commentLen > 0) {
                commentBytes = new byte[commentLen];
                ByteStreams.readFully(underlyingZipStream, commentBytes);
            }
            Charset encoding = this.getEncoding();
            this.name = new String(nameBytes, encoding);
            this.comment = commentBytes == null ? null : new String(commentBytes, encoding);
        }

        @CheckForNull
        public String getComment() {
            return this.comment;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public long getCrc() {
            return this.crc;
        }

        public Charset getEncoding() {
            return 0 != (this.bitFlags >>> 11 & 1) ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        }

        public boolean isEncrypted() {
            return (this.bitFlags & 1) == 1;
        }

        @CheckForNull
        public byte[] getExtra() {
            return this.extra != null ? (byte[])this.extra.clone() : null;
        }

        public int getMethod() {
            return this.method;
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        public long getTime() {
            return this.time;
        }

        public boolean isDirectory() {
            return this.name.endsWith(RandomAccessZipStream.ZIP_PATH_SEPARATOR);
        }

        public int getInternalFileAttributes() {
            return this.internalFileAttributes;
        }

        public long getExternalFileAttributes() {
            return this.externalFileAttributes;
        }

        public int getVersionMadeBy() {
            return this.versionMadeBy;
        }

        public long getRelativeOffsetToLocalHeader() {
            return this.relativeOffsetToLocalHeader;
        }

        public int getVersionForExtraction() {
            return this.versionForExtraction;
        }

        public String toString() {
            return this.name;
        }
    }
}

