/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseAsyncDatastoreServiceImpl;
import com.google.appengine.api.datastore.Batcher;
import com.google.appengine.api.datastore.CloudDatastoreV1Client;
import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceGlobalConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.InternalTransactionCloudDatastoreV1;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.QueryRunnerCloudDatastoreV1;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.HashMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.Entity;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResult;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.MutationResult;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.TransactionOptions;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;

class AsyncCloudDatastoreV1ServiceImpl
extends BaseAsyncDatastoreServiceImpl {
    private final V1Batcher<CommitResponse, CommitRequest.Builder, Key, Mutation> deleteBatcher = new V1Batcher<CommitResponse, CommitRequest.Builder, Key, Mutation>(){

        @Override
        void addToBatch(Mutation mutation, CommitRequest.Builder batch) {
            batch.addMutations(mutation);
        }

        @Override
        int getMaxCount() {
            return AsyncCloudDatastoreV1ServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<CommitResponse> makeCall(CommitRequest.Builder batch) {
            try {
                return AsyncCloudDatastoreV1ServiceImpl.this.datastoreProxy.rawCommit(batch.build().toByteArray());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
        }

        @Override
        final Object getGroup(Key key) {
            return key.getRootKey();
        }

        @Override
        final Mutation toPb(Key value) {
            return Mutation.newBuilder().setDelete(DataTypeTranslator.toV1Key(value)).build();
        }
    };
    private final V1Batcher<LookupResponse, LookupRequest.Builder, Key, com.google.appengine.repackaged.com.google.datastore.v1.Key> lookupByKeyBatcher = new V1Batcher<LookupResponse, LookupRequest.Builder, Key, com.google.appengine.repackaged.com.google.datastore.v1.Key>(){

        @Override
        void addToBatch(com.google.appengine.repackaged.com.google.datastore.v1.Key key, LookupRequest.Builder batch) {
            batch.addKeys(key);
        }

        @Override
        int getMaxCount() {
            return AsyncCloudDatastoreV1ServiceImpl.this.datastoreServiceConfig.maxBatchReadEntities;
        }

        @Override
        protected Future<LookupResponse> makeCall(LookupRequest.Builder batch) {
            return AsyncCloudDatastoreV1ServiceImpl.this.datastoreProxy.lookup(batch.build());
        }

        @Override
        final Object getGroup(Key key) {
            return key.getRootKey();
        }

        @Override
        final com.google.appengine.repackaged.com.google.datastore.v1.Key toPb(Key value) {
            return DataTypeTranslator.toV1Key(value).build();
        }
    };
    private final V1Batcher<LookupResponse, LookupRequest.Builder, com.google.appengine.repackaged.com.google.datastore.v1.Key, com.google.appengine.repackaged.com.google.datastore.v1.Key> lookupByPbBatcher = new V1Batcher<LookupResponse, LookupRequest.Builder, com.google.appengine.repackaged.com.google.datastore.v1.Key, com.google.appengine.repackaged.com.google.datastore.v1.Key>(){

        @Override
        void addToBatch(com.google.appengine.repackaged.com.google.datastore.v1.Key key, LookupRequest.Builder batch) {
            batch.addKeys(key);
        }

        @Override
        int getMaxCount() {
            return AsyncCloudDatastoreV1ServiceImpl.this.datastoreServiceConfig.maxBatchReadEntities;
        }

        @Override
        protected Future<LookupResponse> makeCall(LookupRequest.Builder batch) {
            return AsyncCloudDatastoreV1ServiceImpl.this.datastoreProxy.lookup(batch.build());
        }

        @Override
        final Object getGroup(com.google.appengine.repackaged.com.google.datastore.v1.Key key) {
            return key.getPath(0);
        }

        @Override
        final com.google.appengine.repackaged.com.google.datastore.v1.Key toPb(com.google.appengine.repackaged.com.google.datastore.v1.Key value) {
            return value;
        }
    };
    private final V1Batcher<CommitResponse, CommitRequest.Builder, Entity, Mutation> putBatcher = new V1Batcher<CommitResponse, CommitRequest.Builder, Entity, Mutation>(){

        @Override
        void addToBatch(Mutation mutation, CommitRequest.Builder batch) {
            batch.addMutations(mutation);
        }

        @Override
        int getMaxCount() {
            return AsyncCloudDatastoreV1ServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<CommitResponse> makeCall(CommitRequest.Builder batch) {
            try {
                return AsyncCloudDatastoreV1ServiceImpl.this.datastoreProxy.rawCommit(batch.build().toByteArray());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
        }

        @Override
        final Object getGroup(Entity value) {
            return value.getKey().getRootKey();
        }

        @Override
        final Mutation toPb(Entity value) {
            return Mutation.newBuilder().setUpsert(DataTypeTranslator.toV1Entity(value)).build();
        }
    };
    private final V1Batcher<AllocateIdsResponse, AllocateIdsRequest.Builder, Key, com.google.appengine.repackaged.com.google.datastore.v1.Key> allocateIdsBatcher = new V1Batcher<AllocateIdsResponse, AllocateIdsRequest.Builder, Key, com.google.appengine.repackaged.com.google.datastore.v1.Key>(){

        @Override
        void addToBatch(com.google.appengine.repackaged.com.google.datastore.v1.Key key, AllocateIdsRequest.Builder batch) {
            batch.addKeys(key);
        }

        @Override
        int getMaxCount() {
            return AsyncCloudDatastoreV1ServiceImpl.this.datastoreServiceConfig.maxBatchAllocateIdKeys;
        }

        @Override
        protected Future<AllocateIdsResponse> makeCall(AllocateIdsRequest.Builder batch) {
            return AsyncCloudDatastoreV1ServiceImpl.this.datastoreProxy.allocateIds(batch.build());
        }

        @Override
        final Object getGroup(Key key) {
            Key parent = key.getParent();
            if (parent == null) {
                return Key.PathElement.getDefaultInstance();
            }
            return DataTypeTranslator.toV1Key(parent).getPath(0);
        }

        @Override
        final com.google.appengine.repackaged.com.google.datastore.v1.Key toPb(Key value) {
            return DataTypeTranslator.toV1Key(value).build();
        }
    };
    private final CloudDatastoreV1Client datastoreProxy;

    public AsyncCloudDatastoreV1ServiceImpl(DatastoreServiceConfig datastoreServiceConfig, CloudDatastoreV1Client datastoreProxy, TransactionStack defaultTxnProvider) {
        super(datastoreServiceConfig, defaultTxnProvider, new QueryRunnerCloudDatastoreV1(datastoreServiceConfig, datastoreProxy));
        Preconditions.checkState(!DatastoreServiceGlobalConfig.getConfig().useApiProxy());
        this.datastoreProxy = datastoreProxy;
    }

    @Override
    protected TransactionImpl.InternalTransaction doBeginTransaction(TransactionOptions options) {
        BeginTransactionRequest.Builder request = BeginTransactionRequest.newBuilder();
        TransactionOptions.Builder transactionOptionsBuilder = request.getTransactionOptionsBuilder();
        boolean isReadOnly = false;
        if (options.transactionMode() != null) {
            switch (options.transactionMode()) {
                case READ_ONLY: {
                    transactionOptionsBuilder.setReadOnly(TransactionOptions.ReadOnly.getDefaultInstance());
                    isReadOnly = true;
                    break;
                }
                case READ_WRITE: {
                    transactionOptionsBuilder.setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unrecognized transaction mode: " + (Object)((Object)options.transactionMode())));
                }
            }
        }
        if (options.previousTransaction() != null) {
            try {
                transactionOptionsBuilder.getReadWriteBuilder().setPreviousTransaction(InternalTransactionCloudDatastoreV1.get(options.previousTransaction()).getTransactionBytes());
            }
            catch (RuntimeException e) {
                this.logger.log(Level.FINE, "previousTransaction threw an exception, ignoring as it is likely caused by a failed beginTransaction.", e);
            }
        }
        Future<BeginTransactionResponse> future = this.datastoreProxy.beginTransaction(request.build());
        return InternalTransactionCloudDatastoreV1.create(this.datastoreProxy, future, isReadOnly);
    }

    @Override
    protected Future<Map<Key, Entity>> doBatchGet(@Nullable Transaction txn, final Set<Key> keysToGet, final Map<Key, Entity> resultMap) {
        final LookupRequest.Builder baseReq = LookupRequest.newBuilder();
        ReadOptions.Builder readOptionsBuilder = baseReq.getReadOptionsBuilder();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            readOptionsBuilder.setTransaction(InternalTransactionCloudDatastoreV1.get(txn).getTransactionBytes());
        } else if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            readOptionsBuilder.setReadConsistency(ReadOptions.ReadConsistency.EVENTUAL);
        } else {
            baseReq.clearReadOptions();
        }
        final boolean shouldUseMultipleBatches = txn == null && this.datastoreServiceConfig.getReadPolicy().getConsistency() != ReadPolicy.Consistency.EVENTUAL;
        Iterator<LookupRequest.Builder> batches = this.lookupByKeyBatcher.getBatches(keysToGet, baseReq, baseReq.build().getSerializedSize(), shouldUseMultipleBatches);
        List futures = this.lookupByKeyBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new FutureHelper.MultiFuture<LookupResponse, Map<Key, Entity>>(futures){
            private Map<com.google.appengine.repackaged.com.google.datastore.v1.Key, Key> keyMapIgnoringAppId;

            @Override
            public Map<Key, Entity> get() throws InterruptedException, ExecutionException {
                try {
                    this.aggregate(this.futures, null, null);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
                return resultMap;
            }

            @Override
            public Map<Key, Entity> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.aggregate(this.futures, timeout, unit);
                return resultMap;
            }

            private void aggregate(Iterable<Future<LookupResponse>> currentFutures, @Nullable Long timeout, @Nullable TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
                while (true) {
                    ArrayList<com.google.appengine.repackaged.com.google.datastore.v1.Key> deferredKeys = Lists.newArrayList();
                    for (Future<LookupResponse> currentFuture : currentFutures) {
                        LookupResponse resp = this.getFutureWithOptionalTimeout(currentFuture, timeout, timeoutUnit);
                        this.addEntitiesToResultMap(resp);
                        deferredKeys.addAll(resp.getDeferredList());
                    }
                    if (deferredKeys.isEmpty()) break;
                    Iterator<LookupRequest.Builder> followupBatches = AsyncCloudDatastoreV1ServiceImpl.this.lookupByPbBatcher.getBatches(deferredKeys, baseReq, baseReq.build().getSerializedSize(), shouldUseMultipleBatches);
                    currentFutures = AsyncCloudDatastoreV1ServiceImpl.this.lookupByPbBatcher.makeCalls(followupBatches);
                }
            }

            private LookupResponse getFutureWithOptionalTimeout(Future<LookupResponse> future, @Nullable Long timeout, @Nullable TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
                if (timeout == null) {
                    return future.get();
                }
                return future.get(timeout, timeoutUnit);
            }

            private void addEntitiesToResultMap(LookupResponse response) {
                for (EntityResult entityResult : response.getFoundList()) {
                    Entity responseEntity = DataTypeTranslator.toEntity(entityResult.getEntity());
                    Key responseKey = responseEntity.getKey();
                    if (!keysToGet.contains(responseKey)) {
                        responseKey = this.findKeyFromRequestIgnoringAppId(entityResult.getEntity().getKey());
                    }
                    resultMap.put(responseKey, responseEntity);
                }
            }

            private Key findKeyFromRequestIgnoringAppId(com.google.appengine.repackaged.com.google.datastore.v1.Key keyFromResponse) {
                if (this.keyMapIgnoringAppId == null) {
                    this.keyMapIgnoringAppId = Maps.newHashMap();
                    for (Key requestKey : keysToGet) {
                        Key.Builder requestKeyAsRefWithoutApp = DataTypeTranslator.toV1Key(requestKey);
                        requestKeyAsRefWithoutApp.getPartitionIdBuilder().clearProjectId();
                        this.keyMapIgnoringAppId.put(requestKeyAsRefWithoutApp.build(), requestKey);
                    }
                }
                Key.Builder keyBuilder = keyFromResponse.toBuilder();
                keyBuilder.getPartitionIdBuilder().clearProjectId();
                Key result = this.keyMapIgnoringAppId.get(keyBuilder.build());
                if (result == null) {
                    throw new DatastoreFailureException("Internal error");
                }
                return result;
            }
        });
    }

    static List<Entity> dedupeByKey(List<Entity> entities, Multimap<Integer, Integer> dedupedIndexMap) {
        HashMap<Key, Integer> dedupedEntitiesIndexes = new HashMap<Key, Integer>();
        LinkedHashMap<Key, Entity> dedupedEntities = new LinkedHashMap<Key, Entity>();
        int entityIdx = 0;
        for (Entity entity : entities) {
            Key key = entity.getKey();
            if (dedupedEntities.put(entity.getKey(), entity) == null) {
                dedupedEntitiesIndexes.put(key, dedupedEntities.size() - 1);
            }
            dedupedIndexMap.put((Integer)dedupedEntitiesIndexes.get(key), entityIdx);
            ++entityIdx;
        }
        return new ArrayList<Entity>(dedupedEntities.values());
    }

    @Override
    protected Future<List<Key>> doBatchPut(@Nullable Transaction txn, final List<Entity> entities) {
        if (txn == null) {
            CommitRequest.Builder baseReq = CommitRequest.newBuilder();
            baseReq.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
            final HashMultimap<Integer, Integer> dedupedIndexMap = HashMultimap.create();
            final List<Entity> dedupedEntities = AsyncCloudDatastoreV1ServiceImpl.dedupeByKey(entities, dedupedIndexMap);
            ArrayList<Integer> order = Lists.newArrayListWithCapacity(dedupedEntities.size());
            Iterator<CommitRequest.Builder> batches = this.putBatcher.getBatches(dedupedEntities, baseReq, baseReq.build().getSerializedSize(), true, order);
            List futures = this.putBatcher.makeCalls(batches);
            return new Batcher.ReorderingMultiFuture<CommitResponse, List<Key>>(this, futures, order){

                @Override
                protected List<Key> aggregate(CommitResponse intermediateResult, Iterator<Integer> indexItr, List<Key> result) {
                    for (MutationResult mutationResult : intermediateResult.getMutationResultsList()) {
                        int index = indexItr.next();
                        Key key = ((Entity)dedupedEntities.get(index)).getKey();
                        if (mutationResult.hasKey()) {
                            List<Key.PathElement> pathElements = mutationResult.getKey().getPathList();
                            key.setId(pathElements.get(pathElements.size() - 1).getId());
                        }
                        for (Integer dedupedIndex : dedupedIndexMap.get(index)) {
                            result.set(dedupedIndex, key);
                        }
                    }
                    return result;
                }

                @Override
                protected List<Key> initResult() {
                    int size = entities.size();
                    ArrayList<Key> keyList = Lists.newArrayListWithCapacity(size);
                    keyList.addAll(Collections.nCopies(size, null));
                    return keyList;
                }
            };
        }
        TransactionImpl.ensureTxnActive(txn);
        final InternalTransactionCloudDatastoreV1 txnV1 = InternalTransactionCloudDatastoreV1.get(txn);
        ImmutableList.Builder keyListBuilder = ImmutableList.builder();
        final ArrayList<Key> incompleteKeys = Lists.newArrayList();
        final ArrayList<Entity.Builder> incompleteEntityBldrs = Lists.newArrayList();
        for (Entity entity : entities) {
            Key key = entity.getKey();
            keyListBuilder.add(key);
            if (key.isComplete()) {
                txnV1.deferPut(entity);
                continue;
            }
            Entity.Builder entityV1 = com.google.appengine.repackaged.com.google.datastore.v1.Entity.newBuilder();
            DataTypeTranslator.addPropertiesToPb(entity.getPropertyMap(), entityV1);
            incompleteEntityBldrs.add(entityV1);
            incompleteKeys.add(key);
        }
        ImmutableCollection allKeys = keyListBuilder.build();
        if (incompleteKeys.isEmpty()) {
            return new FutureHelper.FakeFuture<ImmutableCollection>(allKeys);
        }
        return this.registerInTransaction(txn, new FutureWrapper<List<com.google.appengine.repackaged.com.google.datastore.v1.Key>, List<Key>>(this, this.allocateIds(incompleteKeys), (List)((Object)allKeys)){
            final /* synthetic */ List val$allKeys;
            {
                this.val$allKeys = list3;
                super(parent);
            }

            @Override
            protected List<Key> wrap(List<com.google.appengine.repackaged.com.google.datastore.v1.Key> completedKeyPbs) {
                Iterator entityPbBldrIt = incompleteEntityBldrs.iterator();
                Iterator incompleteKeysIt = incompleteKeys.iterator();
                for (com.google.appengine.repackaged.com.google.datastore.v1.Key keyV1 : completedKeyPbs) {
                    AsyncCloudDatastoreV1ServiceImpl.updateKey(keyV1, (Key)incompleteKeysIt.next());
                    txnV1.deferPut(((Entity.Builder)entityPbBldrIt.next()).setKey(keyV1));
                }
                return this.val$allKeys;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        });
    }

    @Override
    protected Future<Void> doBatchDelete(@Nullable Transaction txn, Collection<Key> keys) {
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            InternalTransactionCloudDatastoreV1 txnV1 = InternalTransactionCloudDatastoreV1.get(txn);
            for (Key key : keys) {
                txnV1.deferDelete(key);
            }
            return new FutureHelper.FakeFuture<Object>(null);
        }
        CommitRequest.Builder baseReq = CommitRequest.newBuilder();
        baseReq.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
        LinkedHashSet<Key> dedupedKeys = new LinkedHashSet<Key>(keys);
        Iterator<CommitRequest.Builder> batches = this.deleteBatcher.getBatches(dedupedKeys, baseReq, baseReq.build().getSerializedSize(), true);
        List futures = this.deleteBatcher.makeCalls(batches);
        return new FutureHelper.MultiFuture<CommitResponse, Void>(this, futures){

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                for (Future future : this.futures) {
                    future.get();
                }
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                for (Future future : this.futures) {
                    future.get(timeout, unit);
                }
                return null;
            }
        };
    }

    @Override
    public Future<KeyRange> allocateIds(Key parent, String kind, long num) {
        throw new UnsupportedOperationException();
    }

    protected Future<List<com.google.appengine.repackaged.com.google.datastore.v1.Key>> allocateIds(List<Key> keyList) {
        final ArrayList<Integer> order = Lists.newArrayListWithCapacity(keyList.size());
        Iterator<AllocateIdsRequest.Builder> batches = this.allocateIdsBatcher.getBatches(keyList, AllocateIdsRequest.newBuilder(), 0, true, order);
        List futures = this.allocateIdsBatcher.makeCalls(batches);
        return new Batcher.ReorderingMultiFuture<AllocateIdsResponse, List<com.google.appengine.repackaged.com.google.datastore.v1.Key>>(this, futures, order){

            @Override
            protected List<com.google.appengine.repackaged.com.google.datastore.v1.Key> aggregate(AllocateIdsResponse batch, Iterator<Integer> indexItr, List<com.google.appengine.repackaged.com.google.datastore.v1.Key> result) {
                for (com.google.appengine.repackaged.com.google.datastore.v1.Key key : batch.getKeysList()) {
                    result.set(indexItr.next(), key);
                }
                return result;
            }

            @Override
            protected List<com.google.appengine.repackaged.com.google.datastore.v1.Key> initResult() {
                return Arrays.asList(new com.google.appengine.repackaged.com.google.datastore.v1.Key[order.size()]);
            }
        };
    }

    @Override
    public Future<DatastoreService.KeyRangeState> allocateIdRange(KeyRange range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Map<Index, Index.IndexState>> getIndexes() {
        throw new UnsupportedOperationException();
    }

    private static void updateKey(com.google.appengine.repackaged.com.google.datastore.v1.Key keyV1, Key key) {
        Key.PathElement lastElement;
        List<Key.PathElement> pathElements = keyV1.getPathList();
        if (!pathElements.isEmpty() && (lastElement = pathElements.get(pathElements.size() - 1)).getIdTypeCase() == Key.PathElement.IdTypeCase.ID) {
            key.setId(lastElement.getId());
        }
    }

    private abstract class V1Batcher<S extends Message, R extends Message.Builder, F, T extends Message>
    extends BaseAsyncDatastoreServiceImpl.BaseRpcBatcher<S, R, F, T> {
        private V1Batcher(AsyncCloudDatastoreV1ServiceImpl asyncCloudDatastoreV1ServiceImpl) {
            super(asyncCloudDatastoreV1ServiceImpl);
        }

        @Override
        final R newBatch(R baseBatch) {
            return (R)baseBatch.clone();
        }
    }
}

