/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Futures;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Internal;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListeningExecutorService;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ParametricNullness;
import com.google.appengine.repackaged.com.google.common.util.concurrent.TrustedListenableFutureTask;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import org.jspecify.nullness.NullMarked;

@NullMarked
@GoogleInternal
@GwtIncompatible
public class BoundedQueueExecutorService
implements ListeningExecutorService {
    private final Semaphore semaphore;
    private final ExecutorService delegate;

    public BoundedQueueExecutorService(int maxQueuedTasks, ExecutorService delegate, boolean fair) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkArgument(maxQueuedTasks > 0);
        this.delegate = delegate;
        this.semaphore = new Semaphore(maxQueuedTasks, fair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Callable<T> task) {
        Preconditions.checkNotNull(task);
        if (this.semaphore.tryAcquire()) {
            ReleasingFutureTask<T> futureTask = null;
            boolean successful = false;
            try {
                futureTask = new ReleasingFutureTask<T>(task);
                this.delegate.execute(futureTask);
                successful = true;
                ReleasingFutureTask<T> releasingFutureTask = futureTask;
                return releasingFutureTask;
            }
            finally {
                if (!successful) {
                    if (futureTask == null) {
                        this.semaphore.release();
                    } else {
                        futureTask.cancel(false);
                    }
                }
            }
        }
        return null;
    }

    @CheckForNull
    public ListenableFuture<?> trySubmit(Runnable task) {
        return this.trySubmit(task, (Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Runnable task, @ParametricNullness T result) {
        Preconditions.checkNotNull(task);
        if (this.semaphore.tryAcquire()) {
            ReleasingFutureTask<T> futureTask = null;
            boolean successful = false;
            try {
                futureTask = new ReleasingFutureTask<T>(Executors.callable(task, result));
                this.delegate.execute(futureTask);
                successful = true;
                ReleasingFutureTask<T> releasingFutureTask = futureTask;
                return releasingFutureTask;
            }
            finally {
                if (!successful) {
                    if (futureTask == null) {
                        this.semaphore.release();
                    } else {
                        futureTask.cancel(false);
                    }
                }
            }
        }
        return null;
    }

    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Callable<T> task, Duration timeout) throws InterruptedException {
        return this.trySubmit(task, Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Callable<T> task, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(task);
        if (this.semaphore.tryAcquire(timeout, unit)) {
            ReleasingFutureTask<T> futureTask = null;
            boolean successful = false;
            try {
                futureTask = new ReleasingFutureTask<T>(task);
                this.delegate.execute(futureTask);
                successful = true;
                ReleasingFutureTask<T> releasingFutureTask = futureTask;
                return releasingFutureTask;
            }
            finally {
                if (!successful) {
                    if (futureTask == null) {
                        this.semaphore.release();
                    } else {
                        futureTask.cancel(false);
                    }
                }
            }
        }
        return null;
    }

    @CheckForNull
    public ListenableFuture<?> trySubmit(Runnable task, Duration timeout) throws InterruptedException {
        return this.trySubmit(task, Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    @CheckForNull
    public ListenableFuture<?> trySubmit(Runnable task, long timeout, TimeUnit unit) throws InterruptedException {
        return this.trySubmit(task, null, timeout, unit);
    }

    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Runnable task, @ParametricNullness T result, Duration timeout) throws InterruptedException {
        return this.trySubmit(task, result, Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Runnable task, @ParametricNullness T result, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(task);
        if (this.semaphore.tryAcquire(timeout, unit)) {
            ReleasingFutureTask<T> futureTask = null;
            boolean successful = false;
            try {
                futureTask = new ReleasingFutureTask<T>(Executors.callable(task, result));
                this.delegate.execute(futureTask);
                successful = true;
                ReleasingFutureTask<T> releasingFutureTask = futureTask;
                return releasingFutureTask;
            }
            finally {
                if (!successful) {
                    if (futureTask == null) {
                        this.semaphore.release();
                    } else {
                        futureTask.cancel(false);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ListenableFuture<T> submitInterruptibly(Callable<T> task) throws InterruptedException {
        Preconditions.checkNotNull(task);
        this.semaphore.acquire();
        ReleasingFutureTask<T> futureTask = null;
        boolean successful = false;
        try {
            futureTask = new ReleasingFutureTask<T>(task);
            this.delegate.execute(futureTask);
            successful = true;
            ReleasingFutureTask<T> releasingFutureTask = futureTask;
            return releasingFutureTask;
        }
        finally {
            if (!successful) {
                if (futureTask == null) {
                    this.semaphore.release();
                } else {
                    futureTask.cancel(false);
                }
            }
        }
    }

    public ListenableFuture<?> submitInterruptibly(Runnable task) throws InterruptedException {
        return this.submitInterruptibly(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ListenableFuture<T> submitInterruptibly(Runnable task, @ParametricNullness T result) throws InterruptedException {
        Preconditions.checkNotNull(task);
        this.semaphore.acquire();
        ReleasingFutureTask<T> futureTask = null;
        boolean successful = false;
        try {
            futureTask = new ReleasingFutureTask<T>(Executors.callable(task, result));
            this.delegate.execute(futureTask);
            successful = true;
            ReleasingFutureTask<T> releasingFutureTask = futureTask;
            return releasingFutureTask;
        }
        finally {
            if (!successful) {
                if (futureTask == null) {
                    this.semaphore.release();
                } else {
                    futureTask.cancel(false);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    @CanIgnoreReturnValue
    public List<Runnable> shutdownNow() {
        List<Runnable> unstartedTasks = this.delegate.shutdownNow();
        for (Runnable r : unstartedTasks) {
            if (!(r instanceof Future)) continue;
            ((Future)((Object)r)).cancel(false);
        }
        return unstartedTasks;
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        Preconditions.checkNotNull(task);
        this.semaphore.acquireUninterruptibly();
        ReleasingFutureTask<T> futureTask = null;
        boolean successful = false;
        try {
            futureTask = new ReleasingFutureTask<T>(task);
            this.delegate.execute(futureTask);
            successful = true;
            ReleasingFutureTask<T> releasingFutureTask = futureTask;
            return releasingFutureTask;
        }
        finally {
            if (!successful) {
                if (futureTask == null) {
                    this.semaphore.release();
                } else {
                    futureTask.cancel(false);
                }
            }
        }
    }

    @Override
    public ListenableFuture<?> submit(Runnable task) {
        return this.submit(task, (Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ListenableFuture<T> submit(Runnable task, @ParametricNullness T result) {
        Preconditions.checkNotNull(task);
        this.semaphore.acquireUninterruptibly();
        ReleasingFutureTask<T> futureTask = null;
        boolean successful = false;
        try {
            futureTask = new ReleasingFutureTask<T>(Executors.callable(task, result));
            this.delegate.execute(futureTask);
            successful = true;
            ReleasingFutureTask<T> releasingFutureTask = futureTask;
            return releasingFutureTask;
        }
        finally {
            if (!successful) {
                if (futureTask == null) {
                    this.semaphore.release();
                } else {
                    futureTask.cancel(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Preconditions.checkNotNull(tasks);
        ArrayList<Future<T>> futures = Lists.newArrayListWithExpectedSize(tasks.size());
        try {
            for (Callable<T> callable : tasks) {
                futures.add(this.submitInterruptibly(callable));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (CancellationException | ExecutionException exception) {}
            }
        }
        finally {
            for (Future future : futures) {
                future.cancel(false);
            }
        }
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(tasks);
        Preconditions.checkNotNull(unit);
        long startTime = System.nanoTime();
        long endTime = startTime + TimeUnit.NANOSECONDS.convert(timeout, unit);
        if (endTime - startTime < 0L) {
            endTime = startTime;
        }
        ArrayList<Future<T>> futures = Lists.newArrayListWithExpectedSize(tasks.size());
        ListenableFuture unstartedTaskFuture = null;
        try {
            for (Callable<T> callable : tasks) {
                ListenableFuture<Object> future = this.trySubmit(callable, BoundedQueueExecutorService.nanosUntil(endTime), TimeUnit.NANOSECONDS);
                if (future == null) {
                    if (unstartedTaskFuture == null) {
                        unstartedTaskFuture = Futures.immediateCancelledFuture();
                    }
                    future = unstartedTaskFuture;
                }
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    future.get(BoundedQueueExecutorService.nanosUntil(endTime), TimeUnit.NANOSECONDS);
                }
                catch (CancellationException | ExecutionException | TimeoutException exception) {}
            }
        }
        finally {
            for (Future future : futures) {
                future.cancel(false);
            }
        }
        return futures;
    }

    @Override
    @ParametricNullness
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        List<Future<T>> futures = this.invokeAll(tasks);
        ExecutionException lastExec = null;
        CancellationException lastCancel = null;
        for (Future<T> future : futures) {
            try {
                return future.get();
            }
            catch (ExecutionException e) {
                lastExec = e;
            }
            catch (CancellationException e) {
                lastCancel = e;
            }
        }
        if (lastExec != null) {
            throw lastExec;
        }
        if (lastCancel != null) {
            throw new ExecutionException(lastCancel);
        }
        throw new ExecutionException(new Exception());
    }

    @Override
    @ParametricNullness
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        List<Future<T>> futures = this.invokeAll(tasks, timeout, unit);
        ExecutionException lastExec = null;
        for (Future<T> future : futures) {
            try {
                return future.get();
            }
            catch (ExecutionException e) {
                lastExec = e;
            }
            catch (CancellationException e) {
                throw new TimeoutException();
            }
        }
        if (lastExec != null) {
            throw lastExec;
        }
        throw new ExecutionException(new Exception());
    }

    @Override
    public void execute(Runnable command) {
        Future possiblyIgnoredError = this.submit(command);
    }

    public int availablePermits() {
        return this.semaphore.availablePermits();
    }

    private static long nanosUntil(long endTimeNanos) {
        return Math.max(0L, endTimeNanos - System.nanoTime());
    }

    private final class ReleasingFutureTask<V>
    extends TrustedListenableFutureTask<V> {
        private final AtomicBoolean released;

        public ReleasingFutureTask(Callable<V> callable) {
            super(callable);
            this.released = new AtomicBoolean(false);
        }

        @Override
        public void run() {
            if (this.released.compareAndSet(false, true)) {
                BoundedQueueExecutorService.this.semaphore.release();
            }
            super.run();
        }

        @Override
        protected void afterDone() {
            super.afterDone();
            if (this.isCancelled() && this.released.compareAndSet(false, true)) {
                BoundedQueueExecutorService.this.semaphore.release();
            }
        }
    }
}

