/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend.google;

import com.google.appengine.repackaged.com.google.common.flogger.backend.LoggerBackend;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Platform;
import com.google.appengine.repackaged.com.google.common.flogger.backend.google.GoogleLoggerBackend;
import com.google.appengine.repackaged.com.google.common.flogger.backend.google.HighPrecisionClock;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.BackendFactory;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.Clock;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.StackBasedCallerFinder;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.SystemClock;
import com.google.appengine.repackaged.com.google.common.flogger.context.ContextDataProvider;
import com.google.appengine.repackaged.com.google.common.flogger.util.StaticMethodCaller;

public final class GooglePlatform
extends Platform {
    private static final String SYSTEM_PROPERTY_PREFIX = "google.debug_logs.log_platform.";
    private static final String BACKEND_FACTORY_PROPERTY = "google.debug_logs.log_platform.backend_factory";
    private static final String CONTEXT_PROPERTY = "google.debug_logs.log_platform.context";
    private static final String DEFAULT_CONTEXT_IMPL = "com.google.appengine.repackaged.com.google.common.flogger.config.TraceLoggingContext";
    private final BackendFactory backendFactory;
    private final ContextDataProvider context;
    private final Clock clock;

    public GooglePlatform() {
        BackendFactory factory = StaticMethodCaller.getInstanceFromSystemProperty(BACKEND_FACTORY_PROPERTY, null, BackendFactory.class);
        this.backendFactory = factory != null ? factory : GoogleLoggerBackend.getInstance();
        ContextDataProvider context = StaticMethodCaller.getInstanceFromSystemProperty(CONTEXT_PROPERTY, DEFAULT_CONTEXT_IMPL, ContextDataProvider.class);
        this.context = context != null ? context : ContextDataProvider.getNoOpProvider();
        this.clock = GooglePlatform.resolveClock();
    }

    private static Clock resolveClock() {
        Clock highPrecisionClock = null;
        try {
            highPrecisionClock = HighPrecisionClock.getInstance();
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return highPrecisionClock != null ? highPrecisionClock : SystemClock.getInstance();
    }

    @Override
    protected Platform.LogCallerFinder getCallerFinderImpl() {
        return StackBasedCallerFinder.getInstance();
    }

    @Override
    protected LoggerBackend getBackendImpl(String className) {
        return this.backendFactory.create(className);
    }

    @Override
    protected ContextDataProvider getContextDataProviderImpl() {
        return this.context;
    }

    @Override
    protected long getCurrentTimeNanosImpl() {
        return this.clock.getCurrentTimeNanos();
    }

    @Override
    protected String getConfigInfoImpl() {
        return "Platform: " + this.getClass().getName() + "\nClock: " + this.clock + "\nBackendFactory: " + this.backendFactory + "\nLoggingContext: " + this.context + "\n";
    }
}

