/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.io;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jspecify.nullness.NullMarked;

@NullMarked
@GoogleInternal
@GwtIncompatible
public final class MultiplexingOutputStream
extends OutputStream {
    private final List<OutputStream> streams;

    public MultiplexingOutputStream(OutputStream ... streams) {
        this(Arrays.asList(streams));
    }

    public MultiplexingOutputStream(Iterable<? extends OutputStream> streams) {
        Preconditions.checkNotNull(streams);
        this.streams = new ArrayList<OutputStream>();
        for (OutputStream outputStream : streams) {
            this.streams.add(Preconditions.checkNotNull(outputStream));
        }
    }

    @Override
    public void close() throws MultiplexingIOException {
        this.runOnStreams(new OutputStreamCaller(this){

            @Override
            public void call(OutputStream stream) throws IOException {
                stream.close();
            }
        });
    }

    @Override
    public void flush() throws MultiplexingIOException {
        this.runOnStreams(new OutputStreamCaller(this){

            @Override
            public void call(OutputStream stream) throws IOException {
                stream.flush();
            }
        });
    }

    @Override
    public void write(final byte[] b) throws MultiplexingIOException {
        Preconditions.checkNotNull(b);
        this.runOnStreams(new OutputStreamCaller(){

            @Override
            public void call(OutputStream stream) throws IOException {
                stream.write(b);
            }
        });
    }

    @Override
    public void write(final byte[] b, final int off, final int len) throws MultiplexingIOException {
        Preconditions.checkNotNull(b);
        this.runOnStreams(new OutputStreamCaller(){

            @Override
            public void call(OutputStream stream) throws IOException {
                stream.write(b, off, len);
            }
        });
    }

    @Override
    public void write(final int b) throws MultiplexingIOException {
        this.runOnStreams(new OutputStreamCaller(){

            @Override
            public void call(OutputStream stream) throws IOException {
                stream.write(b);
            }
        });
    }

    private void runOnStreams(OutputStreamCaller caller) throws MultiplexingIOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>(0);
        for (OutputStream stream : this.streams) {
            try {
                caller.call(stream);
            }
            catch (IOException ioe) {
                exceptions.add(ioe);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new MultiplexingIOException(exceptions);
        }
    }

    private static interface OutputStreamCaller {
        public void call(OutputStream var1) throws IOException;
    }

    public static class MultiplexingIOException
    extends IOException {
        private final List<IOException> exceptions;

        public MultiplexingIOException(List<IOException> exceptions) {
            super(MultiplexingIOException.getComponentMessages(exceptions));
            this.exceptions = Collections.unmodifiableList(exceptions);
        }

        public List<IOException> getCauses() {
            return this.exceptions;
        }

        private static String getComponentMessages(List<IOException> exceptions) {
            Joiner joiner = Joiner.on("\n");
            ArrayList<String> messages = new ArrayList<String>();
            messages.add("Component messages:\n");
            for (IOException ioe : exceptions) {
                messages.add("\t" + ioe.getMessage());
            }
            return joiner.join(messages);
        }
    }
}

