/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JdbcMySqlConnectionCleanupFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(JdbcMySqlConnectionCleanupFilter.class.getCanonicalName());
    static final String CLOUD_SQL_JDBC_CONNECTIVITY_ENABLED_KEY = "com.google.appengine.runtime.new_database_connectivity";
    private final AppEngineApiWrapper appEngineApiWrapper;
    private final ConnectionsCleanupWrapper connectionsCleanupWrapper;
    private static final String THROW_ERROR_VARIABLE_NAME = "THROW_ERROR_ON_SQL_CLOSE_ERROR";
    private static final String ABANDONED_CONNECTIONS_CLASSNAME = "com.mysql.jdbc.AbandonedConnections";

    public JdbcMySqlConnectionCleanupFilter() {
        this.appEngineApiWrapper = new AppEngineApiWrapper();
        this.connectionsCleanupWrapper = new ConnectionsCleanupWrapper();
    }

    JdbcMySqlConnectionCleanupFilter(AppEngineApiWrapper appEngineApiWrapper, ConnectionsCleanupWrapper connectionsCleanupWrapper) {
        this.appEngineApiWrapper = appEngineApiWrapper;
        this.connectionsCleanupWrapper = connectionsCleanupWrapper;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.cleanupConnections();
        }
    }

    void cleanupConnections() {
        block5: {
            Map<String, Object> attributes = this.appEngineApiWrapper.getRequestEnvironmentAttributes();
            if (attributes == null) {
                return;
            }
            Object cloudSqlJdbcConnectivityEnabledValue = attributes.get(CLOUD_SQL_JDBC_CONNECTIVITY_ENABLED_KEY);
            if (!(cloudSqlJdbcConnectivityEnabledValue instanceof Boolean)) {
                return;
            }
            if (!((Boolean)cloudSqlJdbcConnectivityEnabledValue).booleanValue()) {
                return;
            }
            try {
                this.connectionsCleanupWrapper.cleanup();
            }
            catch (Exception e) {
                logger.logp(Level.WARNING, "com.google.apphosting.utils.servlet.JdbcMySqlConnectionCleanupFilter", "cleanupConnections", "Unable to cleanup connections", e);
                if (!Boolean.getBoolean(THROW_ERROR_VARIABLE_NAME)) break block5;
                throw new IllegalStateException(e);
            }
        }
    }

    public void destroy() {
    }

    static class AppEngineApiWrapper {
        AppEngineApiWrapper() {
        }

        Map<String, Object> getRequestEnvironmentAttributes() {
            ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
            if (environment == null) {
                logger.logp(Level.WARNING, "com.google.apphosting.utils.servlet.JdbcMySqlConnectionCleanupFilter$AppEngineApiWrapper", "getRequestEnvironmentAttributes", "Unable to fetch the request environment.");
                return null;
            }
            Map<String, Object> attributes = environment.getAttributes();
            if (attributes == null) {
                logger.logp(Level.WARNING, "com.google.apphosting.utils.servlet.JdbcMySqlConnectionCleanupFilter$AppEngineApiWrapper", "getRequestEnvironmentAttributes", "Unable to fetch the request environment attributes.");
                return null;
            }
            return attributes;
        }
    }

    static class ConnectionsCleanupWrapper {
        private static Method cleanupMethod;
        private static boolean cleanupMethodInitializationAttempted;

        ConnectionsCleanupWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() throws Exception {
            Class<ConnectionsCleanupWrapper> clazz = ConnectionsCleanupWrapper.class;
            synchronized (ConnectionsCleanupWrapper.class) {
                if (!cleanupMethodInitializationAttempted) {
                    try {
                        if (cleanupMethod == null) {
                            ClassLoader loader = Thread.currentThread().getContextClassLoader();
                            cleanupMethod = (loader == null ? Class.forName(JdbcMySqlConnectionCleanupFilter.ABANDONED_CONNECTIONS_CLASSNAME) : loader.loadClass(JdbcMySqlConnectionCleanupFilter.ABANDONED_CONNECTIONS_CLASSNAME)).getDeclaredMethod("cleanup", new Class[0]);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    finally {
                        cleanupMethodInitializationAttempted = true;
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (cleanupMethod != null) {
                    cleanupMethod.invoke(null, new Object[0]);
                }
                return;
            }
        }
    }
}

