/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.io.opencensus.tags.unsafe;

import com.google.appengine.repackaged.io.opencensus.internal.Utils;
import com.google.appengine.repackaged.io.opencensus.tags.Tag;
import com.google.appengine.repackaged.io.opencensus.tags.TagContext;
import io.grpc.Context;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class ContextUtils {
    private static final TagContext EMPTY_TAG_CONTEXT = new EmptyTagContext();
    private static final Context.Key<TagContext> TAG_CONTEXT_KEY = Context.keyWithDefault((String)"opencensus-tag-context-key", (Object)EMPTY_TAG_CONTEXT);

    private ContextUtils() {
    }

    public static Context withValue(Context context, @Nullable TagContext tagContext) {
        return Utils.checkNotNull(context, "context").withValue(TAG_CONTEXT_KEY, (Object)tagContext);
    }

    public static TagContext getValue(Context context) {
        TagContext tags = (TagContext)TAG_CONTEXT_KEY.get(context);
        return tags == null ? EMPTY_TAG_CONTEXT : tags;
    }

    @Immutable
    private static final class EmptyTagContext
    extends TagContext {
        private EmptyTagContext() {
        }

        @Override
        protected Iterator<Tag> getIterator() {
            return Collections.emptySet().iterator();
        }
    }
}

