/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.memcache.ConsistentErrorHandler;
import com.google.appengine.api.memcache.ErrorHandler;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.apphosting.api.ApiProxy;
import java.util.concurrent.Future;
import java.util.logging.Logger;

class MemcacheServiceApiHelper {
    static final String PACKAGE = "memcache";
    private static final Logger logger = Logger.getLogger(MemcacheServiceApiHelper.class.getName());

    private MemcacheServiceApiHelper() {
    }

    static <M extends Message, T> Future<T> makeAsyncCall(String methodName, Message request, final RpcResponseHandler<M, T> responseHandler, final Provider<T> defaultValue) {
        Future<byte[]> asyncResp = ApiProxy.makeAsyncCall(PACKAGE, methodName, request.toByteArray());
        return new FutureWrapper<byte[], T>(asyncResp){

            @Override
            protected T wrap(byte[] bytes) throws Exception {
                try {
                    return bytes == null ? null : (Object)responseHandler.convertResponse(bytes);
                }
                catch (Exception ex) {
                    return this.absorbParentException(ex);
                }
            }

            @Override
            protected T absorbParentException(Throwable cause) throws Exception {
                responseHandler.handleApiProxyException(cause);
                return defaultValue.get();
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    static class RpcResponseHandler<M extends Message, T> {
        private final String errorText;
        private final Message.Builder builder;
        private final Transformer<M, T> responseTransfomer;
        private final ErrorHandler errorHandler;

        RpcResponseHandler(M response, String errorText, Transformer<M, T> responseTransfomer, ErrorHandler errorHandler) {
            this.builder = response.newBuilderForType();
            this.errorText = errorText;
            this.responseTransfomer = responseTransfomer;
            this.errorHandler = errorHandler;
        }

        T convertResponse(byte[] responseBytes) throws InvalidProtocolBufferException {
            Message response = this.builder.mergeFrom(responseBytes).build();
            return this.responseTransfomer.transform(response);
        }

        void handleApiProxyException(Throwable cause) throws Exception {
            this.handleApiProxyException(cause, this.errorHandler);
        }

        void handleApiProxyException(Throwable cause, ErrorHandler errorHandler) throws Exception {
            try {
                throw cause;
            }
            catch (InvalidProtocolBufferException ex) {
                errorHandler.handleServiceError(new MemcacheServiceException("Could not decode response:", ex));
            }
            catch (ApiProxy.ApplicationException ex) {
                logger.info(this.errorText + ": " + ex.getErrorDetail());
                errorHandler.handleServiceError(new MemcacheServiceException(this.errorText));
            }
            catch (ApiProxy.ApiProxyException ex) {
                errorHandler.handleServiceError(new MemcacheServiceException(this.errorText, ex));
            }
            catch (MemcacheServiceException ex) {
                if (errorHandler instanceof ConsistentErrorHandler) {
                    errorHandler.handleServiceError(ex);
                }
                throw ex;
            }
            catch (Throwable ex) {
                Throwables.throwIfInstanceOf(ex, Exception.class);
                Throwables.throwIfUnchecked(ex);
                throw new RuntimeException(ex);
            }
        }

        Logger getLogger() {
            return logger;
        }

        ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }
    }

    static interface Transformer<F, T> {
        public T transform(F var1);
    }

    public static interface Provider<T> {
        public T get();
    }
}

