/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/datastore.proto

package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * The options shared by read requests.
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.ReadOptions}
 */
public final class ReadOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.ReadOptions)
    ReadOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadOptions.newBuilder() to construct.
  private ReadOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadOptions() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_ReadOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_ReadOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.ReadOptions.class,
            com.google.datastore.v1.ReadOptions.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The possible values for read consistencies.
   * </pre>
   *
   * Protobuf enum {@code google.datastore.v1.ReadOptions.ReadConsistency}
   */
  public enum ReadConsistency implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. This value must not be used.
     * </pre>
     *
     * <code>READ_CONSISTENCY_UNSPECIFIED = 0;</code>
     */
    READ_CONSISTENCY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Strong consistency.
     * </pre>
     *
     * <code>STRONG = 1;</code>
     */
    STRONG(1),
    /**
     *
     *
     * <pre>
     * Eventual consistency.
     * </pre>
     *
     * <code>EVENTUAL = 2;</code>
     */
    EVENTUAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. This value must not be used.
     * </pre>
     *
     * <code>READ_CONSISTENCY_UNSPECIFIED = 0;</code>
     */
    public static final int READ_CONSISTENCY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Strong consistency.
     * </pre>
     *
     * <code>STRONG = 1;</code>
     */
    public static final int STRONG_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Eventual consistency.
     * </pre>
     *
     * <code>EVENTUAL = 2;</code>
     */
    public static final int EVENTUAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReadConsistency valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ReadConsistency forNumber(int value) {
      switch (value) {
        case 0:
          return READ_CONSISTENCY_UNSPECIFIED;
        case 1:
          return STRONG;
        case 2:
          return EVENTUAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ReadConsistency> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ReadConsistency>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ReadConsistency>() {
              public ReadConsistency findValueByNumber(int number) {
                return ReadConsistency.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.datastore.v1.ReadOptions.getDescriptor().getEnumTypes().get(0);
    }

    private static final ReadConsistency[] VALUES = values();

    public static ReadConsistency valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ReadConsistency(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.datastore.v1.ReadOptions.ReadConsistency)
  }

  private int consistencyTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object consistencyType_;

  public enum ConsistencyTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    READ_CONSISTENCY(1),
    TRANSACTION(2),
    NEW_TRANSACTION(3),
    READ_TIME(4),
    CONSISTENCYTYPE_NOT_SET(0);
    private final int value;

    private ConsistencyTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConsistencyTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConsistencyTypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return READ_CONSISTENCY;
        case 2:
          return TRANSACTION;
        case 3:
          return NEW_TRANSACTION;
        case 4:
          return READ_TIME;
        case 0:
          return CONSISTENCYTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConsistencyTypeCase getConsistencyTypeCase() {
    return ConsistencyTypeCase.forNumber(consistencyTypeCase_);
  }

  public static final int READ_CONSISTENCY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The non-transactional read consistency to use.
   * </pre>
   *
   * <code>.google.datastore.v1.ReadOptions.ReadConsistency read_consistency = 1;</code>
   *
   * @return Whether the readConsistency field is set.
   */
  public boolean hasReadConsistency() {
    return consistencyTypeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The non-transactional read consistency to use.
   * </pre>
   *
   * <code>.google.datastore.v1.ReadOptions.ReadConsistency read_consistency = 1;</code>
   *
   * @return The enum numeric value on the wire for readConsistency.
   */
  public int getReadConsistencyValue() {
    if (consistencyTypeCase_ == 1) {
      return (java.lang.Integer) consistencyType_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * The non-transactional read consistency to use.
   * </pre>
   *
   * <code>.google.datastore.v1.ReadOptions.ReadConsistency read_consistency = 1;</code>
   *
   * @return The readConsistency.
   */
  public com.google.datastore.v1.ReadOptions.ReadConsistency getReadConsistency() {
    if (consistencyTypeCase_ == 1) {
      com.google.datastore.v1.ReadOptions.ReadConsistency result =
          com.google.datastore.v1.ReadOptions.ReadConsistency.forNumber(
              (java.lang.Integer) consistencyType_);
      return result == null
          ? com.google.datastore.v1.ReadOptions.ReadConsistency.UNRECOGNIZED
          : result;
    }
    return com.google.datastore.v1.ReadOptions.ReadConsistency.READ_CONSISTENCY_UNSPECIFIED;
  }

  public static final int TRANSACTION_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The identifier of the transaction in which to read. A
   * transaction identifier is returned by a call to
   * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
   * </pre>
   *
   * <code>bytes transaction = 2;</code>
   *
   * @return Whether the transaction field is set.
   */
  @java.lang.Override
  public boolean hasTransaction() {
    return consistencyTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The identifier of the transaction in which to read. A
   * transaction identifier is returned by a call to
   * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
   * </pre>
   *
   * <code>bytes transaction = 2;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransaction() {
    if (consistencyTypeCase_ == 2) {
      return (com.google.protobuf.ByteString) consistencyType_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int NEW_TRANSACTION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Options for beginning a new transaction for this request.
   *
   * The new transaction identifier will be returned in the corresponding
   * response as either
   * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
   * or
   * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
   * </pre>
   *
   * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
   *
   * @return Whether the newTransaction field is set.
   */
  @java.lang.Override
  public boolean hasNewTransaction() {
    return consistencyTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Options for beginning a new transaction for this request.
   *
   * The new transaction identifier will be returned in the corresponding
   * response as either
   * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
   * or
   * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
   * </pre>
   *
   * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
   *
   * @return The newTransaction.
   */
  @java.lang.Override
  public com.google.datastore.v1.TransactionOptions getNewTransaction() {
    if (consistencyTypeCase_ == 3) {
      return (com.google.datastore.v1.TransactionOptions) consistencyType_;
    }
    return com.google.datastore.v1.TransactionOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Options for beginning a new transaction for this request.
   *
   * The new transaction identifier will be returned in the corresponding
   * response as either
   * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
   * or
   * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
   * </pre>
   *
   * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.TransactionOptionsOrBuilder getNewTransactionOrBuilder() {
    if (consistencyTypeCase_ == 3) {
      return (com.google.datastore.v1.TransactionOptions) consistencyType_;
    }
    return com.google.datastore.v1.TransactionOptions.getDefaultInstance();
  }

  public static final int READ_TIME_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Reads entities as they were at the given time. This value is only
   * supported for Cloud Firestore in Datastore mode.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 4;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return consistencyTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Reads entities as they were at the given time. This value is only
   * supported for Cloud Firestore in Datastore mode.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 4;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    if (consistencyTypeCase_ == 4) {
      return (com.google.protobuf.Timestamp) consistencyType_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Reads entities as they were at the given time. This value is only
   * supported for Cloud Firestore in Datastore mode.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    if (consistencyTypeCase_ == 4) {
      return (com.google.protobuf.Timestamp) consistencyType_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (consistencyTypeCase_ == 1) {
      output.writeEnum(1, ((java.lang.Integer) consistencyType_));
    }
    if (consistencyTypeCase_ == 2) {
      output.writeBytes(2, (com.google.protobuf.ByteString) consistencyType_);
    }
    if (consistencyTypeCase_ == 3) {
      output.writeMessage(3, (com.google.datastore.v1.TransactionOptions) consistencyType_);
    }
    if (consistencyTypeCase_ == 4) {
      output.writeMessage(4, (com.google.protobuf.Timestamp) consistencyType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (consistencyTypeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              1, ((java.lang.Integer) consistencyType_));
    }
    if (consistencyTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              2, (com.google.protobuf.ByteString) consistencyType_);
    }
    if (consistencyTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.datastore.v1.TransactionOptions) consistencyType_);
    }
    if (consistencyTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.protobuf.Timestamp) consistencyType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.ReadOptions)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.ReadOptions other = (com.google.datastore.v1.ReadOptions) obj;

    if (!getConsistencyTypeCase().equals(other.getConsistencyTypeCase())) return false;
    switch (consistencyTypeCase_) {
      case 1:
        if (getReadConsistencyValue() != other.getReadConsistencyValue()) return false;
        break;
      case 2:
        if (!getTransaction().equals(other.getTransaction())) return false;
        break;
      case 3:
        if (!getNewTransaction().equals(other.getNewTransaction())) return false;
        break;
      case 4:
        if (!getReadTime().equals(other.getReadTime())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (consistencyTypeCase_) {
      case 1:
        hash = (37 * hash) + READ_CONSISTENCY_FIELD_NUMBER;
        hash = (53 * hash) + getReadConsistencyValue();
        break;
      case 2:
        hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getTransaction().hashCode();
        break;
      case 3:
        hash = (37 * hash) + NEW_TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getNewTransaction().hashCode();
        break;
      case 4:
        hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getReadTime().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.ReadOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.ReadOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.ReadOptions parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.ReadOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.ReadOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.ReadOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.ReadOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.ReadOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.ReadOptions parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.ReadOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.ReadOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.ReadOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.ReadOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The options shared by read requests.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.ReadOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.ReadOptions)
      com.google.datastore.v1.ReadOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_ReadOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_ReadOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.ReadOptions.class,
              com.google.datastore.v1.ReadOptions.Builder.class);
    }

    // Construct using com.google.datastore.v1.ReadOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (newTransactionBuilder_ != null) {
        newTransactionBuilder_.clear();
      }
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.clear();
      }
      consistencyTypeCase_ = 0;
      consistencyType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_ReadOptions_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.ReadOptions getDefaultInstanceForType() {
      return com.google.datastore.v1.ReadOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.ReadOptions build() {
      com.google.datastore.v1.ReadOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.ReadOptions buildPartial() {
      com.google.datastore.v1.ReadOptions result = new com.google.datastore.v1.ReadOptions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.datastore.v1.ReadOptions result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.datastore.v1.ReadOptions result) {
      result.consistencyTypeCase_ = consistencyTypeCase_;
      result.consistencyType_ = this.consistencyType_;
      if (consistencyTypeCase_ == 3 && newTransactionBuilder_ != null) {
        result.consistencyType_ = newTransactionBuilder_.build();
      }
      if (consistencyTypeCase_ == 4 && readTimeBuilder_ != null) {
        result.consistencyType_ = readTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.ReadOptions) {
        return mergeFrom((com.google.datastore.v1.ReadOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.ReadOptions other) {
      if (other == com.google.datastore.v1.ReadOptions.getDefaultInstance()) return this;
      switch (other.getConsistencyTypeCase()) {
        case READ_CONSISTENCY:
          {
            setReadConsistencyValue(other.getReadConsistencyValue());
            break;
          }
        case TRANSACTION:
          {
            setTransaction(other.getTransaction());
            break;
          }
        case NEW_TRANSACTION:
          {
            mergeNewTransaction(other.getNewTransaction());
            break;
          }
        case READ_TIME:
          {
            mergeReadTime(other.getReadTime());
            break;
          }
        case CONSISTENCYTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int rawValue = input.readEnum();
                consistencyTypeCase_ = 1;
                consistencyType_ = rawValue;
                break;
              } // case 8
            case 18:
              {
                consistencyType_ = input.readBytes();
                consistencyTypeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getNewTransactionFieldBuilder().getBuilder(), extensionRegistry);
                consistencyTypeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                consistencyTypeCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int consistencyTypeCase_ = 0;
    private java.lang.Object consistencyType_;

    public ConsistencyTypeCase getConsistencyTypeCase() {
      return ConsistencyTypeCase.forNumber(consistencyTypeCase_);
    }

    public Builder clearConsistencyType() {
      consistencyTypeCase_ = 0;
      consistencyType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The non-transactional read consistency to use.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions.ReadConsistency read_consistency = 1;</code>
     *
     * @return Whether the readConsistency field is set.
     */
    @java.lang.Override
    public boolean hasReadConsistency() {
      return consistencyTypeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The non-transactional read consistency to use.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions.ReadConsistency read_consistency = 1;</code>
     *
     * @return The enum numeric value on the wire for readConsistency.
     */
    @java.lang.Override
    public int getReadConsistencyValue() {
      if (consistencyTypeCase_ == 1) {
        return ((java.lang.Integer) consistencyType_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The non-transactional read consistency to use.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions.ReadConsistency read_consistency = 1;</code>
     *
     * @param value The enum numeric value on the wire for readConsistency to set.
     * @return This builder for chaining.
     */
    public Builder setReadConsistencyValue(int value) {
      consistencyTypeCase_ = 1;
      consistencyType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The non-transactional read consistency to use.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions.ReadConsistency read_consistency = 1;</code>
     *
     * @return The readConsistency.
     */
    @java.lang.Override
    public com.google.datastore.v1.ReadOptions.ReadConsistency getReadConsistency() {
      if (consistencyTypeCase_ == 1) {
        com.google.datastore.v1.ReadOptions.ReadConsistency result =
            com.google.datastore.v1.ReadOptions.ReadConsistency.forNumber(
                (java.lang.Integer) consistencyType_);
        return result == null
            ? com.google.datastore.v1.ReadOptions.ReadConsistency.UNRECOGNIZED
            : result;
      }
      return com.google.datastore.v1.ReadOptions.ReadConsistency.READ_CONSISTENCY_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * The non-transactional read consistency to use.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions.ReadConsistency read_consistency = 1;</code>
     *
     * @param value The readConsistency to set.
     * @return This builder for chaining.
     */
    public Builder setReadConsistency(com.google.datastore.v1.ReadOptions.ReadConsistency value) {
      if (value == null) {
        throw new NullPointerException();
      }
      consistencyTypeCase_ = 1;
      consistencyType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The non-transactional read consistency to use.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions.ReadConsistency read_consistency = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReadConsistency() {
      if (consistencyTypeCase_ == 1) {
        consistencyTypeCase_ = 0;
        consistencyType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The identifier of the transaction in which to read. A
     * transaction identifier is returned by a call to
     * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
     * </pre>
     *
     * <code>bytes transaction = 2;</code>
     *
     * @return Whether the transaction field is set.
     */
    public boolean hasTransaction() {
      return consistencyTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the transaction in which to read. A
     * transaction identifier is returned by a call to
     * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
     * </pre>
     *
     * <code>bytes transaction = 2;</code>
     *
     * @return The transaction.
     */
    public com.google.protobuf.ByteString getTransaction() {
      if (consistencyTypeCase_ == 2) {
        return (com.google.protobuf.ByteString) consistencyType_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the transaction in which to read. A
     * transaction identifier is returned by a call to
     * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
     * </pre>
     *
     * <code>bytes transaction = 2;</code>
     *
     * @param value The transaction to set.
     * @return This builder for chaining.
     */
    public Builder setTransaction(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      consistencyTypeCase_ = 2;
      consistencyType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the transaction in which to read. A
     * transaction identifier is returned by a call to
     * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
     * </pre>
     *
     * <code>bytes transaction = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransaction() {
      if (consistencyTypeCase_ == 2) {
        consistencyTypeCase_ = 0;
        consistencyType_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.TransactionOptions,
            com.google.datastore.v1.TransactionOptions.Builder,
            com.google.datastore.v1.TransactionOptionsOrBuilder>
        newTransactionBuilder_;
    /**
     *
     *
     * <pre>
     * Options for beginning a new transaction for this request.
     *
     * The new transaction identifier will be returned in the corresponding
     * response as either
     * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
     * or
     * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
     *
     * @return Whether the newTransaction field is set.
     */
    @java.lang.Override
    public boolean hasNewTransaction() {
      return consistencyTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Options for beginning a new transaction for this request.
     *
     * The new transaction identifier will be returned in the corresponding
     * response as either
     * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
     * or
     * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
     *
     * @return The newTransaction.
     */
    @java.lang.Override
    public com.google.datastore.v1.TransactionOptions getNewTransaction() {
      if (newTransactionBuilder_ == null) {
        if (consistencyTypeCase_ == 3) {
          return (com.google.datastore.v1.TransactionOptions) consistencyType_;
        }
        return com.google.datastore.v1.TransactionOptions.getDefaultInstance();
      } else {
        if (consistencyTypeCase_ == 3) {
          return newTransactionBuilder_.getMessage();
        }
        return com.google.datastore.v1.TransactionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Options for beginning a new transaction for this request.
     *
     * The new transaction identifier will be returned in the corresponding
     * response as either
     * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
     * or
     * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
     */
    public Builder setNewTransaction(com.google.datastore.v1.TransactionOptions value) {
      if (newTransactionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistencyType_ = value;
        onChanged();
      } else {
        newTransactionBuilder_.setMessage(value);
      }
      consistencyTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for beginning a new transaction for this request.
     *
     * The new transaction identifier will be returned in the corresponding
     * response as either
     * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
     * or
     * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
     */
    public Builder setNewTransaction(
        com.google.datastore.v1.TransactionOptions.Builder builderForValue) {
      if (newTransactionBuilder_ == null) {
        consistencyType_ = builderForValue.build();
        onChanged();
      } else {
        newTransactionBuilder_.setMessage(builderForValue.build());
      }
      consistencyTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for beginning a new transaction for this request.
     *
     * The new transaction identifier will be returned in the corresponding
     * response as either
     * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
     * or
     * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
     */
    public Builder mergeNewTransaction(com.google.datastore.v1.TransactionOptions value) {
      if (newTransactionBuilder_ == null) {
        if (consistencyTypeCase_ == 3
            && consistencyType_
                != com.google.datastore.v1.TransactionOptions.getDefaultInstance()) {
          consistencyType_ =
              com.google.datastore.v1.TransactionOptions.newBuilder(
                      (com.google.datastore.v1.TransactionOptions) consistencyType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consistencyType_ = value;
        }
        onChanged();
      } else {
        if (consistencyTypeCase_ == 3) {
          newTransactionBuilder_.mergeFrom(value);
        } else {
          newTransactionBuilder_.setMessage(value);
        }
      }
      consistencyTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for beginning a new transaction for this request.
     *
     * The new transaction identifier will be returned in the corresponding
     * response as either
     * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
     * or
     * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
     */
    public Builder clearNewTransaction() {
      if (newTransactionBuilder_ == null) {
        if (consistencyTypeCase_ == 3) {
          consistencyTypeCase_ = 0;
          consistencyType_ = null;
          onChanged();
        }
      } else {
        if (consistencyTypeCase_ == 3) {
          consistencyTypeCase_ = 0;
          consistencyType_ = null;
        }
        newTransactionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for beginning a new transaction for this request.
     *
     * The new transaction identifier will be returned in the corresponding
     * response as either
     * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
     * or
     * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
     */
    public com.google.datastore.v1.TransactionOptions.Builder getNewTransactionBuilder() {
      return getNewTransactionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Options for beginning a new transaction for this request.
     *
     * The new transaction identifier will be returned in the corresponding
     * response as either
     * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
     * or
     * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.TransactionOptionsOrBuilder getNewTransactionOrBuilder() {
      if ((consistencyTypeCase_ == 3) && (newTransactionBuilder_ != null)) {
        return newTransactionBuilder_.getMessageOrBuilder();
      } else {
        if (consistencyTypeCase_ == 3) {
          return (com.google.datastore.v1.TransactionOptions) consistencyType_;
        }
        return com.google.datastore.v1.TransactionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Options for beginning a new transaction for this request.
     *
     * The new transaction identifier will be returned in the corresponding
     * response as either
     * [LookupResponse.transaction][google.datastore.v1.LookupResponse.transaction]
     * or
     * [RunQueryResponse.transaction][google.datastore.v1.RunQueryResponse.transaction].
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions new_transaction = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.TransactionOptions,
            com.google.datastore.v1.TransactionOptions.Builder,
            com.google.datastore.v1.TransactionOptionsOrBuilder>
        getNewTransactionFieldBuilder() {
      if (newTransactionBuilder_ == null) {
        if (!(consistencyTypeCase_ == 3)) {
          consistencyType_ = com.google.datastore.v1.TransactionOptions.getDefaultInstance();
        }
        newTransactionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.TransactionOptions,
                com.google.datastore.v1.TransactionOptions.Builder,
                com.google.datastore.v1.TransactionOptionsOrBuilder>(
                (com.google.datastore.v1.TransactionOptions) consistencyType_,
                getParentForChildren(),
                isClean());
        consistencyType_ = null;
      }
      consistencyTypeCase_ = 3;
      onChanged();
      return newTransactionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Reads entities as they were at the given time. This value is only
     * supported for Cloud Firestore in Datastore mode.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     *
     * @return Whether the readTime field is set.
     */
    @java.lang.Override
    public boolean hasReadTime() {
      return consistencyTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Reads entities as they were at the given time. This value is only
     * supported for Cloud Firestore in Datastore mode.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     *
     * @return The readTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencyTypeCase_ == 4) {
          return (com.google.protobuf.Timestamp) consistencyType_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (consistencyTypeCase_ == 4) {
          return readTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Reads entities as they were at the given time. This value is only
     * supported for Cloud Firestore in Datastore mode.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistencyType_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }
      consistencyTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads entities as they were at the given time. This value is only
     * supported for Cloud Firestore in Datastore mode.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        consistencyType_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      consistencyTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads entities as they were at the given time. This value is only
     * supported for Cloud Firestore in Datastore mode.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (consistencyTypeCase_ == 4
            && consistencyType_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          consistencyType_ =
              com.google.protobuf.Timestamp.newBuilder(
                      (com.google.protobuf.Timestamp) consistencyType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consistencyType_ = value;
        }
        onChanged();
      } else {
        if (consistencyTypeCase_ == 4) {
          readTimeBuilder_.mergeFrom(value);
        } else {
          readTimeBuilder_.setMessage(value);
        }
      }
      consistencyTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads entities as they were at the given time. This value is only
     * supported for Cloud Firestore in Datastore mode.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencyTypeCase_ == 4) {
          consistencyTypeCase_ = 0;
          consistencyType_ = null;
          onChanged();
        }
      } else {
        if (consistencyTypeCase_ == 4) {
          consistencyTypeCase_ = 0;
          consistencyType_ = null;
        }
        readTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads entities as they were at the given time. This value is only
     * supported for Cloud Firestore in Datastore mode.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Reads entities as they were at the given time. This value is only
     * supported for Cloud Firestore in Datastore mode.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if ((consistencyTypeCase_ == 4) && (readTimeBuilder_ != null)) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        if (consistencyTypeCase_ == 4) {
          return (com.google.protobuf.Timestamp) consistencyType_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Reads entities as they were at the given time. This value is only
     * supported for Cloud Firestore in Datastore mode.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        if (!(consistencyTypeCase_ == 4)) {
          consistencyType_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) consistencyType_,
                getParentForChildren(),
                isClean());
        consistencyType_ = null;
      }
      consistencyTypeCase_ = 4;
      onChanged();
      return readTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.ReadOptions)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.ReadOptions)
  private static final com.google.datastore.v1.ReadOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.ReadOptions();
  }

  public static com.google.datastore.v1.ReadOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadOptions> PARSER =
      new com.google.protobuf.AbstractParser<ReadOptions>() {
        @java.lang.Override
        public ReadOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReadOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.ReadOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
