/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.search.SearchServiceException;

public final class SearchServiceConfig {
    private final Double deadline;
    private final String namespace;

    private SearchServiceConfig(Builder builder) {
        this.deadline = builder.deadline;
        this.namespace = builder.namespace;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Double getDeadline() {
        return this.deadline;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static final class Builder {
        private Double deadline;
        private String namespace;

        private Builder(SearchServiceConfig config) {
            this.deadline = config.deadline;
            this.namespace = config.namespace;
        }

        private Builder() {
        }

        public Builder setDeadline(Double deadlineInSeconds) throws SearchServiceException {
            if (deadlineInSeconds != null && deadlineInSeconds <= 0.0) {
                throw new IllegalArgumentException("Invalid Deadline. Must be a positive number.");
            }
            this.deadline = deadlineInSeconds;
            return this;
        }

        public Builder setNamespace(String namespace) {
            if (namespace != null) {
                NamespaceManager.validateNamespace(namespace);
            }
            this.namespace = namespace;
            return this;
        }

        public SearchServiceConfig build() {
            return new SearchServiceConfig(this);
        }
    }
}

