/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.bridge;

import com.google.appengine.repackaged.com.google.io.protocol.CoreMarshallers;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;

public abstract class BaseMessageMarshaller<T extends Message>
extends CoreMarshallers.VariableSizeLocalMarshaller<T> {
    @Override
    public int maxEncodingSize(T object) {
        return object.getSerializedSize();
    }

    @Override
    public void marshal(T message, ByteBuffer sink) {
        if (sink.hasArray()) {
            try {
                CodedOutputStream out = CodedOutputStream.newInstance(sink.array(), sink.arrayOffset() + sink.position(), sink.remaining());
                message.writeTo(out);
                sink.position(sink.limit() - out.spaceLeft());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            sink.put(message.toByteArray());
        }
    }

    @Override
    public T unmarshal(ByteBuffer source) {
        int len;
        int off;
        byte[] data;
        if (source.hasArray()) {
            data = source.array();
            off = source.arrayOffset() + source.position();
            len = source.remaining();
            source.position(source.limit());
        } else {
            data = new byte[source.remaining()];
            source.get(data);
            off = 0;
            len = data.length;
        }
        try {
            return this.reconstituteMessage(CodedInputStream.newInstance(data, off, len));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected abstract T reconstituteMessage(CodedInputStream var1) throws IOException;

    protected static <T extends Message> T getDefaultInstanceOf(Class<T> messageClass) {
        try {
            Message defaultInstance = (Message)messageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
            return (T)defaultInstance;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Message class must implement public #defaultInstance() method", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Message class must implement public #defaultInstance() method", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Error calling #defaultInstance()", e);
        }
    }
}

