/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api;

import com.google.apphosting.api.ApiProxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LifecycleManager {
    private static final LifecycleManager instance = new LifecycleManager();
    private volatile boolean shuttingDown = false;
    private volatile long deadline = -1L;
    private Map<String, ShutdownHook> hooks = new HashMap<String, ShutdownHook>();

    private LifecycleManager() {
    }

    public static LifecycleManager getInstance() {
        return instance;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public synchronized void setShutdownHook(ShutdownHook hook) {
        this.hooks.put(this.currentAppVersionId(), hook);
    }

    public void interruptAllRequests() {
        List<Thread> threads = ApiProxy.getRequestThreads();
        if (threads != null) {
            for (Thread thread : threads) {
                thread.interrupt();
            }
        }
    }

    public long getRemainingShutdownTime() {
        long value = this.deadline;
        if (value == -1L) {
            return -1L;
        }
        return value - System.currentTimeMillis();
    }

    public synchronized void beginShutdown(long deadline) {
        this.shuttingDown = true;
        this.deadline = deadline;
        ShutdownHook hook = this.hooks.get(this.currentAppVersionId());
        if (hook != null) {
            hook.shutdown();
        }
    }

    private String currentAppVersionId() {
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        if (env == null) {
            throw new NullPointerException("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager");
        }
        return env.getAppId() + "/" + env.getVersionId();
    }

    public static interface ShutdownHook {
        public void shutdown();
    }
}

